/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.portal.contextroot;

import com.sap.ide.eclipse.j2ee.model.ui.portal.contextroot.CRDialogHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CRDialog
extends Dialog {
    private static final String TEXT_DIALOG_TITLE = "Context root";
    private static final String TEXT_CONTEXT_ROOT = "Context root";
    private static final int INT_COMBO_DEFAULT_SELECTION = 0;
    private String comboSelection = null;
    private Label label;
    private Combo combo;
    private Text textField;
    private CRDialogHandler myHandler;

    public CRDialog(Shell parentShell, CRDialogHandler dialogHandler) {
        super(parentShell);
        this.myHandler = dialogHandler;
    }

    protected void okPressed() {
        int ret = this.myHandler.handleInputData(this.getComboSelection(), this.getTextFieldValue());
        switch (ret) {
            case 0: {
                super.okPressed();
                break;
            }
            case 1: {
                super.cancelPressed();
                break;
            }
            case 2: {
                this.textField.setFocus();
                break;
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        String pref;
        this.getShell().setText("Context root");
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite innerComposite = new Composite(composite, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 400;
        data.heightHint = 50;
        innerComposite.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        innerComposite.setLayout((Layout)gl);
        this.label = new Label(innerComposite, 0);
        this.label.setText("Context root");
        this.label.setLayoutData((Object)new GridData());
        if (this.myHandler.isOnline()) {
            this.combo = new Combo(innerComposite, -1);
            String[] comboContent = this.myHandler.getPrefixe();
            int i = 0;
            while (i < comboContent.length) {
                this.combo.add(comboContent[i]);
                ++i;
            }
            this.combo.select(0);
            this.comboSelection = this.combo.getItem(this.combo.getSelectionIndex());
            GridData gd = new GridData();
            gd.widthHint = 100;
            this.combo.setLayoutData((Object)gd);
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CRDialog.this.comboSelection = CRDialog.this.combo.getItem(CRDialog.this.combo.getSelectionIndex());
                }
            });
        }
        this.textField = new Text(innerComposite, -1);
        this.textField.setEditable(true);
        GridData gData = new GridData();
        gData.horizontalAlignment = 4;
        gData.grabExcessHorizontalSpace = true;
        this.textField.setLayoutData((Object)gData);
        if (this.myHandler.isOnline() && (pref = this.myHandler.getOldCRPref()) != null && this.combo.indexOf(pref) >= 0) {
            this.combo.select(this.combo.indexOf(pref));
        }
        if (this.myHandler.getOldCRName() != null) {
            this.textField.setText(this.myHandler.getOldCRName());
        }
        return composite;
    }

    private String getComboSelection() {
        if (this.myHandler.isOnline()) {
            return this.combo.getText();
        }
        return "";
    }

    private String getTextFieldValue() {
        return this.textField.getText();
    }
}

