/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.portal;

import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.component.dcmetadata.model.PublicPartFileOutputProvider;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.actions.dcmetadata.AddEntityAction;
import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.eclipse.dii.component.ProjectConsistencyManager;
import com.sap.ide.login.UserValidator;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.complib.provider.PPOutputProvider;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.tssap.j2ee.util.jdt.JDTUtils;
import com.tssap.j2ee.util.portal.IComp;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;

public class Comp
implements IComp {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$portal$Comp == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$portal$Comp = Comp.class$("com.sap.ide.eclipse.j2ee.model.ui.portal.Comp")) : class$com$sap$ide$eclipse$j2ee$model$ui$portal$Comp));
    private static final String SRC_POSTFIX = "Src";
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$portal$Comp;

    public String getName(IProject project) {
        IDevelopmentComponentNode n = ComponentUtil.getDCNode((IProject)project);
        if (n != null) {
            return n.getName();
        }
        return null;
    }

    public String getVendor(IProject project) {
        IDevelopmentComponentNode n = ComponentUtil.getDCNode((IProject)project);
        if (n != null) {
            return n.getVendor();
        }
        return null;
    }

    public String getBuildVariant(IProject project) {
        return ComponentUtil.getBuildVariant((IProject)project);
    }

    public String getDevConfiguration(IProject project) {
        IDevelopmentConfiguration cfg = ComponentUtil.getParentDevConf((IProject)project);
        if (cfg == null) {
            return null;
        }
        if (cfg.getConfigurationData() == null) {
            return null;
        }
        return cfg.getConfigurationData().getName();
    }

    public void addBuildTimeDependency(IProject project, IProject refProject, String refPublicPart) {
        IDevelopmentComponentNode dcNode = ComponentUtil.getDCNode((IProject)project);
        IDCProxy dcProxy = null;
        try {
            dcProxy = dcNode.getDCProxy();
        }
        catch (DevConfigException e) {
            tracer.error("", (Throwable)e);
            return;
        }
        DevelopmentComponent dc = dcProxy.getComponent();
        String refName = this.getName(refProject);
        String refVendor = this.getVendor(refProject);
        if (refName == null || refVendor == null) {
            return;
        }
        if (!this.isReferenced(dc, refName, refVendor, refPublicPart)) {
            DCReference dcRef = new DCReference(refName, refVendor);
            Dependency dependency = ComponentFactory.createDependency((DCReference)dcRef, (DevelopmentComponent)dc);
            dependency.setPublicPart(refPublicPart);
            dependency.setAtBuildTime(true);
            try {
                dcProxy.serializeDefinition();
            }
            catch (DevConfigException e) {
                tracer.error("", (Throwable)e);
            }
        }
    }

    public void removeBuildTimeDependency(IProject project, IProject refProject, String refPublicPart) {
        IDevelopmentComponentNode dcNode = ComponentUtil.getDCNode((IProject)project);
        IDCProxy dcProxy = null;
        try {
            dcProxy = dcNode.getDCProxy();
        }
        catch (DevConfigException e) {
            tracer.error("", (Throwable)e);
            return;
        }
        DevelopmentComponent dc = dcProxy.getComponent();
        String refName = this.getName(refProject);
        String refVendor = this.getVendor(refProject);
        List list = dc.getDependencies();
        if (refName == null || refVendor == null || list == null) {
            return;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Dependency dep;
            Object obj = it.next();
            if (!(obj instanceof Dependency) || (dep = (Dependency)obj).getComponent() == null) continue;
            String depName = dep.getComponent().getName();
            String depVendor = dep.getComponent().getVendor();
            String depPP = dep.getPublicPart();
            if (!refName.equals(depName) || !refVendor.equals(depVendor) || !refPublicPart.equals(depPP)) continue;
            list.remove(obj);
            try {
                dcProxy.serializeDefinition();
            }
            catch (DevConfigException e) {
                tracer.error("", (Throwable)e);
            }
            return;
        }
    }

    private boolean isReferenced(DevelopmentComponent dc, String refName, String refVendor, String refPP) {
        boolean ret = false;
        List list = dc.getDependencies();
        if (list == null) {
            return ret;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Dependency dep;
            Object obj = it.next();
            if (!(obj instanceof Dependency) || (dep = (Dependency)obj).getComponent() == null) continue;
            String depName = dep.getComponent().getName();
            String depVendor = dep.getComponent().getVendor();
            String depPP = dep.getPublicPart();
            if (!refName.equals(depName) || !refVendor.equals(depVendor) || !refPP.equals(depPP)) continue;
            return true;
        }
        return ret;
    }

    public void updateProjectSettings(IProject project) {
        IDevelopmentConfiguration configuration = ComponentUtil.getParentDevConf((IProject)project);
        IDevelopmentComponentNode dcNode = ComponentUtil.getDCNode((IProject)project);
        IDCProxy dcProxy = null;
        try {
            dcProxy = dcNode.getDCProxy();
        }
        catch (DevConfigException e) {
            tracer.error("", (Throwable)e);
            return;
        }
        DevelopmentComponent dc = dcProxy.getComponent();
        ProjectConsistencyManager.getInstance((IDevelopmentConfiguration)configuration).synchronizeProject(dc, (IProgressMonitor)new NullProgressMonitor());
    }

    private void reGeneratePublicPart(IProject project, String publicPart, List ppEntList) {
        this.addEntitiesToPublicPart(project, publicPart, ppEntList, true);
    }

    private void addEntitiesToPublicPart(IProject project, String publicPart, List ppEntList, boolean removeOldEntities) {
        AddEntityAction addEntityAction = new AddEntityAction();
        IPPModel pp = addEntityAction.getPPModel(project, publicPart);
        if (pp == null) {
            return;
        }
        if (removeOldEntities) {
            pp.removeAllEntities();
        }
        Iterator it = ppEntList.iterator();
        while (it.hasNext()) {
            Entity e = (Entity)it.next();
            pp.addEntity(e);
        }
        IFile thePPFile = addEntityAction.getPPFile(project, pp);
        PublicPartFileOutputProvider anOutPutProvider = new PublicPartFileOutputProvider(thePPFile);
        try {
            pp.writeModelTo((PPOutputProvider)anOutPutProvider);
        }
        catch (Exception e) {
            tracer.error("", (Throwable)e);
        }
    }

    private List createPackageEntities(IProject project, boolean withSource) {
        ArrayList<Entity> ppEntList = new ArrayList<Entity>();
        IJavaProject jp = JavaCore.create((IProject)project);
        IPackageFragment[] pf = JDTUtils.getAllPackages((IJavaProject)jp);
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < pf.length) {
            String name = pf[i].getElementName();
            if (name.length() > 0 && name.indexOf(46) < 0) {
                map.put("PR" + name, name);
            }
            ++i;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            String entName = (String)obj;
            String packageName = (String)map.get(obj);
            Entity e = ComponentFactory.createEntity();
            e.setName(entName);
            e.setPackageName(packageName);
            e.setType("Java Package Tree");
            e.setSubType("Class");
            ppEntList.add(e);
            if (!withSource) continue;
            e = ComponentFactory.createEntity();
            e.setName(entName + SRC_POSTFIX);
            e.setPackageName(packageName);
            e.setType("Java Package Tree");
            e.setSubType("Source");
            ppEntList.add(e);
        }
        Entity e = ComponentFactory.createEntity();
        e.setName("PR");
        e.setPackageName("");
        e.setType("Java Package");
        e.setSubType("Class");
        ppEntList.add(e);
        if (withSource) {
            e = ComponentFactory.createEntity();
            e.setName("PRSrc");
            e.setPackageName("");
            e.setType("Java Package");
            e.setSubType("Source");
            ppEntList.add(e);
        }
        return ppEntList;
    }

    public boolean hasBuildTimeDependency(IProject project, IProject refProject, String refPublicPart) {
        IDevelopmentComponentNode dcNode = ComponentUtil.getDCNode((IProject)project);
        IDCProxy dcProxy = null;
        try {
            dcProxy = dcNode.getDCProxy();
        }
        catch (DevConfigException e) {
            tracer.error("", (Throwable)e);
            return false;
        }
        DevelopmentComponent dc = dcProxy.getComponent();
        String refName = this.getName(refProject);
        String refVendor = this.getVendor(refProject);
        if (refName == null || refVendor == null) {
            return false;
        }
        return this.isReferenced(dc, refName, refVendor, refPublicPart);
    }

    public boolean isDefaultServerOnline() {
        return UserValidator.isDefaultServerOnline();
    }

    public boolean createPublicPart(IProject aDCProject, String aPPName, String aPPPurpose, String aPPCaption, String aPPDescription) {
        IPPModel ppModel = DCProjectUtil.createPublicPart((IProject)aDCProject, (String)aPPName, (String)aPPPurpose, (String)aPPCaption, (String)aPPDescription);
        return ppModel != null;
    }

    private List getPublicPartEntities(IProject project, String publicPart) {
        DevelopmentComponent dc;
        IDevelopmentComponentNode n = ComponentUtil.getDCNode((IProject)project);
        try {
            dc = n.getDevelopmentComponent(true);
        }
        catch (RepositoryAccessException e1) {
            tracer.error("", (Throwable)e1);
            return null;
        }
        catch (InvalidDefinitionException e1) {
            tracer.error("", (Throwable)e1);
            return null;
        }
        Map m = dc.getPublicParts();
        Object ppObject = m.get(publicPart);
        if (ppObject != null && ppObject instanceof PublicPart) {
            PublicPart pp = (PublicPart)ppObject;
            return pp.getEntities();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EntityComparator
    implements Comparator {
        private EntityComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null || !(o1 instanceof Entity) || !(o2 instanceof Entity)) {
                return 0;
            }
            Entity a = (Entity)o1;
            Entity b = (Entity)o2;
            String strA = a.getName() + a.getPackageName() + a.getType() + a.getSubType();
            String strB = b.getName() + b.getPackageName() + b.getType() + b.getSubType();
            return strA.compareTo(strB);
        }
    }
}

