/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.db;

import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.ide.eclipse.j2ee.model.ui.J2EEModelUIPlugin;
import com.sap.ide.eclipse.j2ee.model.ui.db.DatabaseCreator;
import com.sap.ide.eclipse.j2ee.model.ui.db.DictionaryHelper;
import com.sap.ide.eclipse.j2ee.model.ui.db.IDBDatabase;
import com.sap.ide.eclipse.j2ee.model.ui.db.IDBTable;
import com.tssap.j2ee.model.ext.Util;
import com.tssap.j2ee.model.ext.ejbjarpersistent.IPersistentDeltaHandlerResult;
import com.tssap.j2ee.model.ext.ejbjarpersistent.dd.IPersistentEjbMap;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GenerateDictionaryTablesDialog
extends Dialog {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$db$GenerateDictionaryTablesDialog == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$db$GenerateDictionaryTablesDialog = GenerateDictionaryTablesDialog.class$("com.sap.ide.eclipse.j2ee.model.ui.db.GenerateDictionaryTablesDialog")) : class$com$sap$ide$eclipse$j2ee$model$ui$db$GenerateDictionaryTablesDialog));
    private IPersistentEjbMap _persistentEjbMap;
    private IPersistentDeltaHandlerResult _persistentDeltaHandlerResult;
    private Combo _dictionaryProjectsCombo;
    private Group _finetuningGroup;
    private Button _displayInfoMessagesCheckbox;
    private Group _reactRedundantColumnsGroup;
    private Button _reactRedundantColumnsIgnoreRadio;
    private Button _reactRedundantColumnsWarnRadio;
    private Button _reactRedundantColumnsRemoveRadio;
    private Group _reactImproperColumnsGroup;
    private Button _reactImproperColumnsErrorRadio;
    private Button _reactImproperColumnsModifyRadio;
    private Group _reactRedundantTablesGroup;
    private Button _reactRedundantTablesIgnoreRadio;
    private Button _reactRedundantTablesWarnRadio;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$db$GenerateDictionaryTablesDialog;

    public GenerateDictionaryTablesDialog(IPersistentEjbMap persistentEjbMap, IPersistentDeltaHandlerResult persistentDeltaHandlerResult) {
        super(J2EEModelUIPlugin.getShell());
        this._persistentEjbMap = persistentEjbMap;
        this._persistentDeltaHandlerResult = persistentDeltaHandlerResult;
    }

    protected Control createDialogArea(Composite parent) {
        Composite standard = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(standard, 0);
        container.setLayoutData((Object)this.getDefaultLayoutData());
        container.setLayout((Layout)this.getDefaultLayout());
        Label dictionaryProjectsLabel = new Label(container, 0);
        dictionaryProjectsLabel.setText("Choose dictionary-project in which to create the tables");
        dictionaryProjectsLabel.setLayoutData((Object)this.getDefaultLayoutData());
        this._dictionaryProjectsCombo = new Combo(container, 12);
        this._dictionaryProjectsCombo.setItems(this.getDictionaryProjectNames());
        if (this._dictionaryProjectsCombo.getItemCount() > 0) {
            this._dictionaryProjectsCombo.select(0);
        }
        this._dictionaryProjectsCombo.setLayoutData((Object)this.getDefaultLayoutData());
        new Label(container, 0);
        this._finetuningGroup = new Group(container, 0);
        this._finetuningGroup.setText("Finetuning the feedback");
        this._finetuningGroup.setLayoutData((Object)this.getDefaultLayoutData());
        this._finetuningGroup.setLayout((Layout)this.getDefaultLayout());
        this._displayInfoMessagesCheckbox = new Button((Composite)this._finetuningGroup, 32);
        this._displayInfoMessagesCheckbox.setText("Display information-messages and not only warnings/errors");
        this._displayInfoMessagesCheckbox.setSelection(false);
        new Label((Composite)this._finetuningGroup, 0);
        this._reactRedundantColumnsGroup = new Group((Composite)this._finetuningGroup, 0);
        this._reactRedundantColumnsGroup.setText("How to react on redundant columns (e.g. ejb-field removed)");
        this._reactRedundantColumnsGroup.setLayoutData((Object)this.getDefaultLayoutData());
        this._reactRedundantColumnsGroup.setLayout((Layout)this.getDefaultLayout());
        this._reactRedundantColumnsIgnoreRadio = new Button((Composite)this._reactRedundantColumnsGroup, 16);
        this._reactRedundantColumnsIgnoreRadio.setText("Ignore");
        this._reactRedundantColumnsIgnoreRadio.setSelection(false);
        this._reactRedundantColumnsWarnRadio = new Button((Composite)this._reactRedundantColumnsGroup, 16);
        this._reactRedundantColumnsWarnRadio.setText("Display warning");
        this._reactRedundantColumnsWarnRadio.setSelection(true);
        this._reactRedundantColumnsRemoveRadio = new Button((Composite)this._reactRedundantColumnsGroup, 16);
        this._reactRedundantColumnsRemoveRadio.setText("Remove automatically (not recommended for productive usage)");
        this._reactRedundantColumnsRemoveRadio.setSelection(false);
        new Label((Composite)this._finetuningGroup, 0);
        this._reactImproperColumnsGroup = new Group((Composite)this._finetuningGroup, 0);
        this._reactImproperColumnsGroup.setText("How to react on improper columns (e.g datatype of ejb-field changed)");
        this._reactImproperColumnsGroup.setLayoutData((Object)this.getDefaultLayoutData());
        this._reactImproperColumnsGroup.setLayout((Layout)this.getDefaultLayout());
        this._reactImproperColumnsErrorRadio = new Button((Composite)this._reactImproperColumnsGroup, 16);
        this._reactImproperColumnsErrorRadio.setText("Display error");
        this._reactImproperColumnsErrorRadio.setSelection(true);
        this._reactImproperColumnsModifyRadio = new Button((Composite)this._reactImproperColumnsGroup, 16);
        this._reactImproperColumnsModifyRadio.setText("Modify automatically (not recommended for productive usage)");
        this._reactImproperColumnsModifyRadio.setSelection(false);
        new Label((Composite)this._finetuningGroup, 0);
        this._reactRedundantTablesGroup = new Group((Composite)this._finetuningGroup, 0);
        this._reactRedundantTablesGroup.setText("How to react on redundant tables (e.g. ejb removed)");
        this._reactRedundantTablesGroup.setLayoutData((Object)this.getDefaultLayoutData());
        this._reactRedundantTablesGroup.setLayout((Layout)this.getDefaultLayout());
        this._reactRedundantTablesIgnoreRadio = new Button((Composite)this._reactRedundantTablesGroup, 16);
        this._reactRedundantTablesIgnoreRadio.setText("Ignore");
        this._reactRedundantTablesIgnoreRadio.setSelection(true);
        this._reactRedundantTablesWarnRadio = new Button((Composite)this._reactRedundantTablesGroup, 16);
        this._reactRedundantTablesWarnRadio.setText("Display warning");
        this._reactRedundantTablesWarnRadio.setSelection(false);
        return standard;
    }

    protected void okPressed() {
        String projectName = this._dictionaryProjectsCombo.getText();
        if (projectName != null && projectName.length() != 0) {
            try {
                DictionaryHelper.showView("com.tssap.tools.ui.views.UserOutView");
                DataSourceManager dataSourceManager = DictionaryHelper.getDataSourceManager(projectName);
                IDBDatabase database = DatabaseCreator.createDatabaseForEjbs(this._persistentEjbMap, this._persistentDeltaHandlerResult);
                IDBTable[] table = database.getTables();
                int numberOfExceptions = 0;
                int i = 0;
                while (i < table.length) {
                    try {
                        DictionaryHelper.createTable(dataSourceManager, table[i], this.getDisplayInfoMessages(), this.getReactRedundantColumns(), this.getReactImproperColumns());
                    }
                    catch (Exception x) {
                        ++numberOfExceptions;
                    }
                    ++i;
                }
                if (this.getReactRedundantTables() != 0) {
                    DictionaryHelper.warnOfRedundantTables(dataSourceManager, table, this.getDisplayInfoMessages());
                }
                if (numberOfExceptions == 0) {
                    String message = "All " + table.length + " tables were created/modified successfully. Please check the 'General User Output' for details.";
                    MessageDialog.openInformation((Shell)J2EEModelUIPlugin.getShell(), (String)"Success", (String)message);
                } else {
                    String message = "Of the " + table.length + " tables only " + (table.length - numberOfExceptions) + " could be created successfully. The other " + numberOfExceptions + " tables could not be created/modified because of errors. Please check the 'General User Output' for details.";
                    MessageDialog.openError((Shell)J2EEModelUIPlugin.getShell(), (String)"Error", (String)message);
                }
            }
            catch (Exception e) {
                String message = "The tables could not be created.";
                TRACER.userOut("generateTables", 2, message + "\nDetails: " + e.getMessage() + "\n" + Util.getStacktrace((Throwable)e));
                MessageDialog.openError((Shell)J2EEModelUIPlugin.getShell(), (String)"Error", (String)(message + "\nReason: " + e.getMessage() + "\nSee 'General User Output' for Details."));
            }
        }
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create tables for EJBs");
    }

    protected Point getInitialSize() {
        Point p = super.getInitialSize();
        p.x += 40;
        return p;
    }

    private boolean getDisplayInfoMessages() {
        boolean result = this._displayInfoMessagesCheckbox.getSelection();
        return result;
    }

    private int getReactRedundantColumns() {
        int result = this._reactRedundantColumnsIgnoreRadio.getSelection() ? 0 : (this._reactRedundantColumnsRemoveRadio.getSelection() ? 2 : 1);
        return result;
    }

    private int getReactImproperColumns() {
        int result = this._reactImproperColumnsModifyRadio.getSelection() ? 1 : 0;
        return result;
    }

    private int getReactRedundantTables() {
        int result = this._reactRedundantTablesIgnoreRadio.getSelection() ? 0 : 1;
        return result;
    }

    private String[] getDictionaryProjectNames() {
        IProject[] dictionaryProjects = DictionaryHelper.getDictionaryProjects();
        String[] result = new String[dictionaryProjects.length];
        int i = 0;
        while (i < dictionaryProjects.length) {
            result[i] = dictionaryProjects[i].getName();
            ++i;
        }
        return result;
    }

    private GridData getDefaultLayoutData() {
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        return layoutData;
    }

    private GridLayout getDefaultLayout() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        return layout;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

