/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.db;

import com.sap.dictionary.designtime.DdMapping;
import com.sap.dictionary.designtime.DtTypeInfoForDatabase;
import com.sap.dictionary.tools.nameserver.NameServerUtil;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryObjectChecker;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryUtil;
import com.sap.ide.eclipse.j2ee.model.ui.J2EEModelUIPlugin;
import com.sap.ide.eclipse.j2ee.model.ui.db.IDBColumn;
import com.sap.ide.eclipse.j2ee.model.ui.db.IDBTable;
import com.sap.ide.eclipse.j2ee.model.ui.wizards.sapdsaliases.DBPoolAliasWizardPage;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.BooleanEnum;
import com.sap.ide.metamodel.dictionary.datatype.DatabaseEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtPrimaryKey;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.tssap.j2ee.model.ext.Util;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class DictionaryHelper {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$db$DictionaryHelper == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$db$DictionaryHelper = DictionaryHelper.class$("com.sap.ide.eclipse.j2ee.model.ui.db.DictionaryHelper")) : class$com$sap$ide$eclipse$j2ee$model$ui$db$DictionaryHelper));
    public static final int REACT_REDUNDANT_COLUMNS_IGNORE = 0;
    public static final int REACT_REDUNDANT_COLUMNS_WARN = 1;
    public static final int REACT_REDUNDANT_COLUMNS_REMOVE = 2;
    public static final int REACT_IMPROPER_COLUMNS_ERROR = 0;
    public static final int REACT_IMPROPER_COLUMNS_MODIFY = 1;
    public static final int REACT_REDUNDANT_TABLES_IGNORE = 0;
    public static final int REACT_REDUNDANT_TABLES_WARN = 1;
    public static final String USER_OUT_SUBCATEGORY = "generateTables";
    public static final String DEFAULT_TABLE_PACKAGE = "";
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$db$DictionaryHelper;

    public static DataSourceManager getDataSourceManager(String projectName) {
        DataSourceManager dataSourceManager = DataSourceManager.getDataSourceManager((String)projectName);
        return dataSourceManager;
    }

    public static DtDbTable createTable(DataSourceManager dataSourceManager, IDBTable dbTable) throws Exception {
        return DictionaryHelper.createTable(dataSourceManager, dbTable, true, 1, 0);
    }

    public static DtDbTable createTable(DataSourceManager dataSourceManager, IDBTable dbTable, boolean displayInfoMessages, int reactRedundantColumns, int reactImproperColumns) throws Exception {
        try {
            DtDictionaryRoot dtDictionaryRoot = dataSourceManager.getDictionaryRoot();
            DtDbTable dtDbTable = dtDictionaryRoot.getTable(DEFAULT_TABLE_PACKAGE, dbTable.getName());
            if (dtDbTable == null) {
                dtDbTable = DictionaryHelper.createTable(dataSourceManager, dbTable.getName());
                DictionaryHelper.displayMessage(displayInfoMessages, 4, "Table " + dbTable.getName() + " created.");
            } else {
                DictionaryHelper.displayMessage(displayInfoMessages, 4, "Table " + dbTable.getName() + " will be modified if necessary.");
            }
            HashMap<String, IDBColumn> dbColumnForName = new HashMap<String, IDBColumn>();
            IDBColumn[] dbColumn = dbTable.getColumns();
            int i = 0;
            while (i < dbColumn.length) {
                dbColumnForName.put(dbColumn[i].getName(), dbColumn[i]);
                ++i;
            }
            int i2 = dtDbTable.getStructureElementCount() - 1;
            while (i2 >= 0) {
                DtField dtField = (DtField)dtDbTable.getStructureElement(i2);
                String columnName = dtField.getName();
                IDBColumn matching = (IDBColumn)dbColumnForName.remove(columnName);
                if (matching == null) {
                    if (reactRedundantColumns == 1) {
                        DictionaryHelper.displayMessage(displayInfoMessages, 3, "Column " + columnName + " in " + dbTable.getName() + " is redundant and could be removed.");
                    } else if (reactRedundantColumns == 2) {
                        DictionaryHelper.displayMessage(displayInfoMessages, 2, "Column " + columnName + " in " + dbTable.getName() + " is redundant and should have been removed automatically (NOT IMPLEMENTED YET).");
                    }
                } else {
                    boolean anythingShouldHaveChanged = DictionaryHelper.adjustField(dtField, matching, false, displayInfoMessages, reactImproperColumns);
                    if (anythingShouldHaveChanged) {
                        if (reactImproperColumns != 0) {
                            DictionaryHelper.displayMessage(displayInfoMessages, 4, "Column " + columnName + " in " + dbTable.getName() + " was modified to adapt to the changed description.");
                        }
                    } else {
                        DictionaryHelper.displayMessage(displayInfoMessages, 4, "Column " + columnName + " in " + dbTable.getName() + " was not modified.");
                    }
                }
                --i2;
            }
            Iterator newColumns = dbColumnForName.values().iterator();
            while (newColumns.hasNext()) {
                IDBColumn newColumn = (IDBColumn)newColumns.next();
                DtField dtField = DictionaryHelper.createColumn(dtDbTable, newColumn.getName());
                DictionaryHelper.adjustField(dtField, newColumn, true, displayInfoMessages, reactImproperColumns);
                DictionaryHelper.displayMessage(displayInfoMessages, 4, "Column " + newColumn.getName() + " in " + dbTable.getName() + " created.");
            }
            HashMap<String, DtField> pkFieldForName = new HashMap<String, DtField>();
            int i3 = 0;
            while (i3 < dbColumn.length) {
                if (dbColumn[i3].getIsPrimaryKey()) {
                    String columnName = dbColumn[i3].getName();
                    DtField pkField = (DtField)dtDbTable.getStructureElement(columnName);
                    pkFieldForName.put(columnName, pkField);
                }
                ++i3;
            }
            DtPrimaryKey dtPrimaryKey = dtDbTable.getPrimaryKey();
            if (dtPrimaryKey == null) {
                dtPrimaryKey = dtDbTable.createPrimaryKey();
            }
            DtStructureElement[] currentKeys = dtPrimaryKey.getKeyElements();
            int i4 = 0;
            while (i4 < currentKeys.length) {
                Object mustBeKey = pkFieldForName.remove(currentKeys[i4].getName());
                if (mustBeKey == null) {
                    boolean columnIsNew;
                    boolean bl = columnIsNew = dbColumnForName.get(currentKeys[i4].getName()) != null;
                    if (columnIsNew || reactImproperColumns == 1) {
                        dtPrimaryKey.removeKeyElement(currentKeys[i4]);
                        DictionaryHelper.displayMessage(displayInfoMessages, 4, "The column " + currentKeys[i4].getName() + " in " + dbTable.getName() + " is no longer marked as a primarykey.");
                    } else {
                        DictionaryHelper.displayMessage(displayInfoMessages, 2, "The column " + currentKeys[i4].getName() + " in " + dtDbTable.getName() + " must not be a primarykey. Please change this manually.");
                    }
                }
                ++i4;
            }
            Iterator pkFields = pkFieldForName.values().iterator();
            while (pkFields.hasNext()) {
                boolean columnIsNew;
                DtField newPkField = (DtField)pkFields.next();
                boolean bl = columnIsNew = dbColumnForName.get(newPkField.getName()) != null;
                if (columnIsNew || reactImproperColumns == 1) {
                    dtPrimaryKey.addKeyElement((DtStructureElement)newPkField);
                    DictionaryHelper.displayMessage(displayInfoMessages, 4, "The column " + newPkField.getName() + " in " + dbTable.getName() + " was marked as a primarykey.");
                    continue;
                }
                DictionaryHelper.displayMessage(displayInfoMessages, 2, "The column " + newPkField.getName() + " in " + dtDbTable.getName() + " must be a primarykey. Please change this manually.");
            }
            DictionaryHelper.adjustPositions(dtDbTable);
            return dtDbTable;
        }
        catch (Exception x) {
            String message = "There were errors when creating/modifying the table " + dbTable.getName() + ". It might be in an inconsistent/incomplete state, and it is recommended that you do not save the changes.\nDetails: " + x.getMessage() + "\n" + Util.getStacktrace((Throwable)x);
            DictionaryHelper.displayMessage(displayInfoMessages, 2, message);
            throw x;
        }
    }

    public static void warnOfRedundantTables(DataSourceManager dataSourceManager, IDBTable[] necessaryTables, boolean displayInfoMessages) {
        try {
            DtDictionaryRoot dtDictionaryRoot = dataSourceManager.getDictionaryRoot();
            ArrayList<String> necessaryTablesList = new ArrayList<String>();
            int i = 0;
            while (i < necessaryTables.length) {
                necessaryTablesList.add(necessaryTables[i].getName());
                ++i;
            }
            DtDbTable[] allTables = dtDictionaryRoot.getTables();
            StringBuffer redundantTables = new StringBuffer();
            int i2 = 0;
            while (i2 < allTables.length) {
                if (!necessaryTablesList.contains(allTables[i2].getName())) {
                    if (redundantTables.length() != 0) {
                        redundantTables.append(", ");
                    }
                    redundantTables.append(allTables[i2].getName());
                }
                ++i2;
            }
            if (redundantTables.length() == 0) {
                if (displayInfoMessages) {
                    DictionaryHelper.displayMessage(displayInfoMessages, 4, "There were no redundant tables found");
                }
            } else {
                DictionaryHelper.displayMessage(displayInfoMessages, 3, "The following tables might be redundant and in that case could be deleted: " + redundantTables);
            }
        }
        catch (Exception x) {
            DictionaryHelper.displayMessage(displayInfoMessages, 2, "There were errors when trying to find out the redundant tables.\nDetails: " + x.getMessage() + "\n" + Util.getStacktrace((Throwable)x));
        }
    }

    private static void displayMessage(boolean displayInfoMessages, int level, String message) {
        if (level >= 4 && !displayInfoMessages) {
            return;
        }
        TRACER.userOut(USER_OUT_SUBCATEGORY, level, message);
    }

    private static boolean adjustPositions(DtDbTable dtDbTable) {
        boolean anythingChanged = false;
        DtStructureElement[] allColumns = dtDbTable.getStructureElements();
        DtStructureElement[] primaryKeyColumns = dtDbTable.getPrimaryKey().getKeyElements();
        List<DtStructureElement> primaryKeyColumnsList = Arrays.asList(primaryKeyColumns);
        ArrayList<DtStructureElement> swapColumns = new ArrayList<DtStructureElement>();
        int i = 0;
        while (i < allColumns.length) {
            if (!primaryKeyColumnsList.contains(allColumns[i]) && allColumns[i].getPosition() <= primaryKeyColumns.length) {
                swapColumns.add(allColumns[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < primaryKeyColumns.length) {
            if (primaryKeyColumns[i2].getPosition() > primaryKeyColumns.length) {
                DtStructureElement swapColumn = (DtStructureElement)swapColumns.remove(0);
                int swap = swapColumn.getPosition();
                swapColumn.setPosition(primaryKeyColumns[i2].getPosition());
                primaryKeyColumns[i2].setPosition(swap);
                anythingChanged = true;
            }
            ++i2;
        }
        return anythingChanged;
    }

    private static final DtDbTable createTable(DataSourceManager dataSourceManager, String tableName) throws Exception {
        if (tableName == null) {
            throw new Exception("The table-name must not be null");
        }
        String message = DictionaryObjectChecker.checkTableName((String)tableName, null, (char)'A', (DataSourceManager)dataSourceManager);
        if (!DictionaryUtil.stringIsEmpty((String)message)) {
            throw new Exception("The table " + tableName + " has an invalid name: " + message);
        }
        DtDictionaryRoot dtDictionaryRoot = dataSourceManager.getDictionaryRoot();
        if (dtDictionaryRoot.hasTable(DEFAULT_TABLE_PACKAGE, tableName)) {
            throw new Exception("A table/view with the name " + tableName + " already exists in the project " + dataSourceManager.getProjectName() + ".");
        }
        if (NameServerUtil.isNameReservedOnWizard((String)"SAP_DBObjectName", (String)dataSourceManager.getProjectName(), (String)tableName, (boolean)false)) {
            throw new Exception("The table " + tableName + " can not be created, because there is already a table/view with this name registered on the name-server.");
        }
        DBPoolAliasWizardPage dummyPage = new DBPoolAliasWizardPage();
        if (!NameServerUtil.isPrefixValidOnWizard((String)"SAP_DBObjectName", (String)dataSourceManager.getProjectName(), (String)tableName, (WizardPage)dummyPage, (boolean)true)) {
            throw new Exception("The table " + tableName + " can not be created, because it has an invalid prefix: " + dummyPage.getErrorMessage());
        }
        DtDbTable dtDbTable = dtDictionaryRoot.createTable(DEFAULT_TABLE_PACKAGE, tableName);
        return dtDbTable;
    }

    private static final DtField createColumn(DtDbTable dtDbTable, String columnName) throws Exception {
        String message = DictionaryObjectChecker.checkStructureName((String)columnName);
        if (!DictionaryUtil.stringIsEmpty((String)message)) {
            throw new Exception("The column " + columnName + " in table " + dtDbTable.getName() + " has an invalid name: " + message);
        }
        DtField dtField = dtDbTable.createStructureElementAsDtField(columnName);
        dtField.setPosition(dtDbTable.getStructureElementCount() - 1);
        return dtField;
    }

    private static boolean adjustField(DtField dtField, IDBColumn dbColumn, boolean columnIsNew, boolean displayInfoMessages, int reactColumnImproper) throws Exception {
        String oldType = dtField.getBuiltInType();
        String newType = DdMapping.getDdicTypeFromJavaType((String)dbColumn.getType());
        if (newType == null) {
            throw new Exception("Can not determine dictionary-type for java-type " + dbColumn.getType());
        }
        boolean typeShouldChange = !newType.equals(oldType);
        boolean typeChanged = false;
        if (typeShouldChange) {
            if (reactColumnImproper == 1 || columnIsNew) {
                dtField.setBuiltInType(newType);
                typeChanged = true;
            } else {
                DictionaryHelper.displayMessage(displayInfoMessages, 2, "The datatype of the column " + dbColumn.getName() + " in " + dbColumn.getTable().getName() + " does not match the necessary type '" + newType + "'. Please change this manually.");
            }
        }
        BooleanEnum oldNotNull = dtField.getNotNull();
        BooleanEnum newNotNull = dbColumn.getIsNotNull() ? BooleanEnum.TRUE : BooleanEnum.FALSE;
        boolean notNullShouldChange = !oldNotNull.equals(newNotNull);
        boolean notNullChanged = false;
        if (notNullShouldChange) {
            if (reactColumnImproper == 1 || columnIsNew) {
                dtField.setNotNull(dbColumn.getIsNotNull() ? BooleanEnum.TRUE : BooleanEnum.FALSE);
                notNullChanged = true;
            } else {
                DictionaryHelper.displayMessage(displayInfoMessages, 2, "The not-null flag of the column " + dbColumn.getName() + " in " + dbColumn.getTable().getName() + " does not match the necessary type '" + newNotNull + "'. Please change this manually.");
            }
        }
        if (columnIsNew || typeChanged) {
            int newLength = 0;
            int newTotalDigits = 0;
            int newFractionDigits = 0;
            if (dtField.getBuiltInType().equals("string")) {
                newLength = 80;
            } else if (dtField.getBuiltInType().equals("binary")) {
                newLength = 255;
            } else if (dtField.getBuiltInType().equals("decimal")) {
                newTotalDigits = 31;
                newFractionDigits = 16;
            }
            dtField.setLength(newLength);
            dtField.setTotalDigits(newTotalDigits);
            dtField.setFractionDigits(newFractionDigits);
            String newJdbcType = DictionaryHelper.determineJdbcType(dtField.getBuiltInType(), dtField.getLength());
            dtField.setJdbcTypeName(newJdbcType);
        }
        if (columnIsNew || typeChanged || notNullChanged) {
            String newDbDefault = "0";
            if (dtField.getBuiltInType().equals("string")) {
                newDbDefault = " ";
            } else if (dtField.getBuiltInType().equals("binary")) {
                newDbDefault = null;
            }
            if (dtField.getNotNull() != BooleanEnum.TRUE) {
                newDbDefault = null;
            }
            dtField.setDbDefault(newDbDefault);
        }
        return typeShouldChange || notNullShouldChange;
    }

    public static IProject[] getDictionaryProjects() {
        IProject[] allProjects = J2EEModelUIPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> filteredProjectsList = new ArrayList<IProject>();
        int i = 0;
        while (i < allProjects.length) {
            try {
                if (allProjects[i].hasNature("com.sap.dictionary.tools.archivebuilder.DictionaryNature")) {
                    filteredProjectsList.add(allProjects[i]);
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
            ++i;
        }
        IProject[] filteredProjects = new IProject[filteredProjectsList.size()];
        filteredProjectsList.toArray(filteredProjects);
        return filteredProjects;
    }

    public static void showView(String viewId) {
        IWorkbenchPage activePage = J2EEModelUIPlugin.getActivePage();
        if (activePage != null) {
            try {
                activePage.showView(viewId);
            }
            catch (PartInitException e) {
                TRACER.error("Can not show view: " + viewId, (Throwable)e);
            }
        }
    }

    public static String determineJdbcType(String buildInType, int length) throws Exception {
        DatabaseEnum[] databases = new DatabaseEnum[DatabaseEnum.getValues().size()];
        DatabaseEnum.getValues().toArray(databases);
        ArrayList jdbcTypeInfo = DdMapping.getJdbcTypeInfo((String)buildInType, (int)length, (DatabaseEnum[])databases);
        int i = 0;
        while (i < jdbcTypeInfo.size()) {
            DtTypeInfoForDatabase dtTypeInfoForDatabase = (DtTypeInfoForDatabase)jdbcTypeInfo.get(i);
            if (dtTypeInfoForDatabase.getDatabaseName().equalsIgnoreCase("DEFAULT")) {
                return dtTypeInfoForDatabase.getJavaSqlTypeName();
            }
            ++i;
        }
        throw new Exception("Can not determin corresponding jdbc-type for the dictionary-type " + buildInType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

