/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.db;

import com.sap.ide.eclipse.j2ee.model.ui.db.DBColumn;
import com.sap.ide.eclipse.j2ee.model.ui.db.IDBColumn;
import com.sap.ide.eclipse.j2ee.model.ui.db.IDBDatabase;
import com.sap.ide.eclipse.j2ee.model.ui.db.IDBTable;
import com.tssap.j2ee.model.ext.Util;
import java.util.HashSet;
import java.util.Set;

public class DBTable
implements IDBTable {
    private IDBDatabase _database;
    private String _name;
    private Object _associatedObject;
    private Set _columns = new HashSet();

    protected DBTable(IDBDatabase database, String name, String associatedObject) {
        this._database = database;
        this._name = name.toUpperCase();
        this._associatedObject = associatedObject;
    }

    public IDBDatabase getDatabase() {
        return this._database;
    }

    public String getName() {
        return this._name;
    }

    public Object getAssociatedObject() {
        return this._associatedObject;
    }

    public IDBColumn createColumn(String name, String associatedObject, String type, boolean isPrimaryKey, boolean isNotNull) throws IllegalArgumentException {
        DBColumn column = new DBColumn(this, name, associatedObject, type, isPrimaryKey, isNotNull);
        boolean columnIsNew = this._columns.add(column);
        if (!columnIsNew) {
            throw new IllegalArgumentException("Not possible to add the column " + column + " to the table " + this.getName() + ", because there is another column with the same name.");
        }
        return column;
    }

    public boolean removeColumn(IDBColumn column) {
        return this._columns.remove(column);
    }

    public IDBColumn[] getColumns() {
        IDBColumn[] result = new IDBColumn[this._columns.size()];
        this._columns.toArray(result);
        return result;
    }

    public IDBColumn findColumnByAssociatedObject(Object associatedObject) {
        IDBColumn[] column = this.getColumns();
        int i = 0;
        while (i < column.length) {
            if (Util.equalsWithNull((Object)associatedObject, (Object)column[i].getAssociatedObject())) {
                return column[i];
            }
            ++i;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof IDBTable)) {
            return false;
        }
        IDBTable other = (IDBTable)o;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[DBTable name=").append(this.getName()).append(" object=").append(this.getAssociatedObject()).append(" columns={\n");
        IDBColumn[] columns = this.getColumns();
        int i = 0;
        while (i < columns.length) {
            s.append("  ").append(columns[i]);
            if (i != columns.length - 1) {
                s.append('\n');
            }
            ++i;
        }
        s.append("}]");
        return s.toString();
    }
}

