/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.db;

import com.sap.ide.eclipse.j2ee.model.ui.db.DBTable;
import com.sap.ide.eclipse.j2ee.model.ui.db.IDBDatabase;
import com.sap.ide.eclipse.j2ee.model.ui.db.IDBTable;
import com.tssap.j2ee.model.ext.Util;
import java.util.HashSet;
import java.util.Set;

public class DBDatabase
implements IDBDatabase {
    private Object _associatedObject;
    private Set _tables = new HashSet();

    public DBDatabase(Object associatedObject) {
        this._associatedObject = associatedObject;
    }

    public Object getAssociatedObject() {
        return this._associatedObject;
    }

    public IDBTable createTable(String name, String associatedObject) throws IllegalArgumentException {
        DBTable table = new DBTable(this, name, associatedObject);
        boolean tableIsNew = this._tables.add(table);
        if (!tableIsNew) {
            throw new IllegalArgumentException("Not possible to add the table " + table + " to the database, because there is another table with the same name.");
        }
        return table;
    }

    public boolean removeTable(IDBTable table) {
        return this._tables.remove(table);
    }

    public IDBTable[] getTables() {
        IDBTable[] result = new IDBTable[this._tables.size()];
        this._tables.toArray(result);
        return result;
    }

    public IDBTable findTableByAssociatedObject(Object associatedObject) {
        IDBTable[] table = this.getTables();
        int i = 0;
        while (i < table.length) {
            if (Util.equalsWithNull((Object)associatedObject, (Object)table[i].getAssociatedObject())) {
                return table[i];
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[DBDatabase").append(" object=").append(this.getAssociatedObject()).append(" tables={\n");
        IDBTable[] tables = this.getTables();
        int i = 0;
        while (i < tables.length) {
            s.append(tables[i]);
            if (i != tables.length - 1) {
                s.append(",\n");
            }
            ++i;
        }
        s.append("}]");
        return s.toString();
    }
}

