/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.db;

import com.sap.ide.eclipse.j2ee.model.ui.db.IDBColumn;
import com.sap.ide.eclipse.j2ee.model.ui.db.IDBTable;
import com.tssap.j2ee.model.ext.TypeSignatureWrapper;

public class DBColumn
implements IDBColumn {
    private static final String TYPE_SERIALIZED_OBJECT = "byte[]";
    private IDBTable _table;
    private String _name;
    private String _associatedObject;
    private String _type;
    private boolean _isNotNull;
    private boolean _isPrimaryKey;

    protected DBColumn(IDBTable table, String name, String associatedObject, String type, boolean isPrimaryKey, boolean isNotNull) {
        this._table = table;
        this._name = name.toUpperCase();
        this._associatedObject = associatedObject;
        this._type = type;
        this._isPrimaryKey = isPrimaryKey;
        this._isNotNull = isNotNull;
    }

    public IDBTable getTable() {
        return this._table;
    }

    public String getName() {
        return this._name;
    }

    public Object getAssociatedObject() {
        return this._associatedObject;
    }

    public String getType() {
        return this._type;
    }

    public boolean getIsNotNull() {
        return this._isNotNull;
    }

    public boolean getIsPrimaryKey() {
        return this._isPrimaryKey;
    }

    public static String getJavaMappingType(TypeSignatureWrapper typeSignatureWrapper) {
        String result = null;
        if (typeSignatureWrapper != null) {
            result = typeSignatureWrapper.getArrayCount() != 0 ? TYPE_SERIALIZED_OBJECT : (typeSignatureWrapper.isDatatype() ? typeSignatureWrapper.getDatatype() : (typeSignatureWrapper.isDatatypeClass() ? typeSignatureWrapper.getFullClassName() : TYPE_SERIALIZED_OBJECT));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof IDBColumn)) {
            return false;
        }
        IDBColumn other = (IDBColumn)o;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[DBColumn name=").append(this.getName()).append(" object=").append(this.getAssociatedObject());
        s.append(" type=");
        if (this.getType() != null) {
            s.append(this.getType());
        } else {
            s.append("<unspecified>");
        }
        s.append(" isNotNull=").append(this.getIsNotNull());
        s.append(" isPrimaryKey=").append(this.getIsPrimaryKey());
        s.append("]");
        return s.toString();
    }
}

