/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.common;

import com.sap.dictionary.tools.tablebrowser.TableNotFoundException;
import com.sap.dictionary.tools.tablebrowser.TableSelection;
import com.sap.ide.eclipse.j2ee.model.ui.J2EEModelUIPlugin;
import com.sap.ide.eclipse.j2ee.model.ui.common.EditableGenericComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.ITableSelectionComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.ITableSelectionComponentAdapter;
import com.sap.sql.catalog.Table;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class TableSelectionComponent
extends EditableGenericComponent
implements ITableSelectionComponent {
    public static final Image IMAGE_TABLE_DIALOG = J2EEModelUIPlugin.getImage("ddTables.gif");
    public static final Image IMAGE_TABLE_NOT_VERIFIED = SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_MESSAGE_WARNING);
    public static final Image IMAGE_TABLE_VERIFIED = SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_CHECKED);
    public static final String TEXT_TABLE_NOT_VERIFIED = "The table can not be verified by the data dictionary";
    public static final String TEXT_TABLE_VERIFIED = "The table is verified by the data dictionary";
    private Text _tableNameTextField;
    private Button _tableSelectionButton;
    private Label _tableVerifiedStatusImage;
    private Label _tableVerifiedStatusText;
    private ITableSelectionComponentAdapter _adapter;
    private IProject _dictionaryProject;
    private Table _table;
    private String _tableName;
    private boolean _modifyCallbackActive = true;

    public TableSelectionComponent(ITableSelectionComponentAdapter adapter, IProject dictionaryProject) {
        this._adapter = adapter;
        this._dictionaryProject = dictionaryProject;
    }

    public void initContainer(IGridLayoutPane originalUserArea) {
        IGridLayoutPane userArea = originalUserArea.addGridLayoutPane(1, false, originalUserArea.createGridLayoutData(4, 4, true, false));
        IGridLayoutPane pane = userArea.addGridLayoutPane(3, false, userArea.createGridLayoutData(4, 4, true, false));
        pane.addTextLabel("Table name");
        this._tableNameTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this._tableSelectionButton = pane.addPushButton(IMAGE_TABLE_DIALOG, "Select table from the data dictionary", pane.createGridLayoutData(1, 2, 1, 1));
        userArea.addPlaceholder();
        pane = userArea.addGridLayoutPane(2, false, userArea.createGridLayoutData(4, 4, true, false));
        this._tableVerifiedStatusImage = pane.addImage(IMAGE_TABLE_NOT_VERIFIED, false, pane.createGridLayoutData(4, 4, false, false, 1, 1));
        this._tableVerifiedStatusText = pane.addTextLabel(" ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.decorateControls();
    }

    private void decorateControls() {
        this._tableNameTextField.addModifyListener((ModifyListener)new NameModifyAdapter());
        this._tableSelectionButton.addSelectionListener((SelectionListener)new CheckboxListener());
    }

    public void refresh() {
        this._tableName = this._adapter.getTableName();
        try {
            this._modifyCallbackActive = false;
            this._tableNameTextField.setText(this._tableName == null ? "" : this._tableName);
            Object var2_1 = null;
            this._modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._modifyCallbackActive = true;
            throw throwable;
        }
        this.updateTableAfterNameChange();
    }

    protected void updateSpecificEditableBehavior() {
        this._tableNameTextField.setEditable(this.isEditable());
        this._tableSelectionButton.setEnabled(this.isEditable());
        this._tableName = this._adapter.getTableName();
        try {
            this._modifyCallbackActive = false;
            this._tableNameTextField.setText(this._tableName == null ? "" : this._tableName);
            Object var2_1 = null;
            this._modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._modifyCallbackActive = true;
            throw throwable;
        }
        this.updateTableAfterNameChange();
    }

    public String getTableName() {
        return this._tableName;
    }

    public Table getTable() {
        return this._table;
    }

    public static Table findTable(IProject dictionaryProject, String tableName) {
        try {
            TableSelection tableSelection = new TableSelection(dictionaryProject);
            return tableSelection.getTableByName(tableName);
        }
        catch (TableNotFoundException e) {
            return null;
        }
    }

    public int getUserGridNumOfColumns() {
        return 1;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    private void updateTableAfterNameChange() {
        this._table = TableSelectionComponent.findTable(this._dictionaryProject, this._tableName);
        this.refreshStatusLabels();
    }

    private void refreshStatusLabels() {
        if (!this.isEnabled()) {
            this._tableVerifiedStatusText.setText("");
            this._tableVerifiedStatusImage.setImage(null);
        } else if (this._table == null) {
            this._tableVerifiedStatusText.setText(TEXT_TABLE_NOT_VERIFIED);
            this._tableVerifiedStatusImage.setImage(IMAGE_TABLE_NOT_VERIFIED);
        } else {
            this._tableVerifiedStatusText.setText(TEXT_TABLE_VERIFIED);
            this._tableVerifiedStatusImage.setImage(IMAGE_TABLE_VERIFIED);
        }
    }

    private void startTableSelection() {
        TableSelection tableSelection = new TableSelection(this._dictionaryProject);
        boolean selectedTable = tableSelection.open(this._table);
        if (selectedTable) {
            this._table = tableSelection.getTable();
            if (this._table != null) {
                this._tableNameTextField.setText(this._table.getName());
            }
        }
    }

    private class NameModifyAdapter
    implements ModifyListener {
        private NameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            TableSelectionComponent.this._tableName = TableSelectionComponent.this._tableNameTextField.getText();
            TableSelectionComponent.this.updateTableAfterNameChange();
            if (TableSelectionComponent.this._modifyCallbackActive) {
                TableSelectionComponent.this._adapter.tableChanged();
            }
        }
    }

    private class CheckboxListener
    extends SelectionAdapter {
        private CheckboxListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == TableSelectionComponent.this._tableSelectionButton) {
                TableSelectionComponent.this.startTableSelection();
            }
        }
    }
}

