/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.common;

import com.sap.ide.eclipse.j2ee.model.ui.common.EditableGenericComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.ISecurityRoleSelectionComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.ISecurityRoleSelectionComponentAdapter;
import com.tssap.j2ee.model.ext.Util;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class SecurityRoleSelectionComponent
extends EditableGenericComponent
implements ISecurityRoleSelectionComponent {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] DEFAULT_SECURITY_ROLES = new String[]{"administrators", "all", "guests"};
    private Button _noMappingRadioButton;
    private Button _roleBasedRadioButton;
    private IGridLayoutPane _roleBasedPane;
    private Combo _serverRoleNameTextField;
    private Button _userBasedRadioButton;
    private IGridLayoutPane _userBasedPane;
    private Text _userNameTextField;
    private Text _groupNameTextField;
    private ISecurityRoleSelectionComponentAdapter _adapter;

    public SecurityRoleSelectionComponent(ISecurityRoleSelectionComponentAdapter adapter) {
        this._adapter = adapter;
    }

    public void initContainer(IGridLayoutPane originalUserArea) {
        IGridLayoutPane userArea = originalUserArea.addGridLayoutPane(1, false, originalUserArea.createGridLayoutData(4, 4, true, true));
        IGridLayoutPane pane = userArea.addGridLayoutPane(1, false, userArea.createGridLayoutData(4, 4, true, true));
        this._noMappingRadioButton = pane.addRadioButton("No mapping (=> mapping has to be defined after deployment)");
        this._roleBasedRadioButton = pane.addRadioButton("Role based mapping");
        this._roleBasedPane = pane.addGridLayoutPane(1, false, pane.createGridLayoutData(4, 4, true, false));
        this._roleBasedPane.addTextLabel("Server role name");
        this._serverRoleNameTextField = this._roleBasedPane.addComboBox(DEFAULT_SECURITY_ROLES, "", false, this._roleBasedPane.createGridLayoutData(4, 4, true, false, 2, 1));
        this._userBasedRadioButton = pane.addRadioButton("User based mapping (DEPRECATED, values can be viewed only)");
        this._userBasedPane = pane.addGridLayoutPane(1, false, pane.createGridLayoutData(4, 4, true, true));
        this._userBasedPane.addTextLabel("Group names");
        this._groupNameTextField = this._userBasedPane.addTextPane("", false, true, this._userBasedPane.createGridLayoutData(4, 4, true, true, 2, 6));
        this._userBasedPane.addTextLabel("User names");
        this._userNameTextField = this._userBasedPane.addTextPane("", false, true, this._userBasedPane.createGridLayoutData(4, 4, true, true, 2, 6));
        this.decorateControls();
    }

    private void decorateControls() {
        this._serverRoleNameTextField.addModifyListener((ModifyListener)new TextModifyAdapter());
        this._userNameTextField.addModifyListener((ModifyListener)new TextModifyAdapter());
        this._groupNameTextField.addModifyListener((ModifyListener)new TextModifyAdapter());
        this._noMappingRadioButton.addSelectionListener((SelectionListener)new CheckboxListener());
        this._roleBasedRadioButton.addSelectionListener((SelectionListener)new CheckboxListener());
        this._userBasedRadioButton.addSelectionListener((SelectionListener)new CheckboxListener());
    }

    public void refresh() {
        String serverRoleName = this._adapter.getServerRoleName();
        if (serverRoleName != null) {
            this._roleBasedRadioButton.setSelection(true);
            this._serverRoleNameTextField.setText(serverRoleName == null ? "" : serverRoleName);
        } else {
            String[] userName = this._adapter.getUserNames();
            StringBuffer users = new StringBuffer(userName.length * 16);
            int i = 0;
            while (i < userName.length) {
                users.append(userName[i]).append('\n');
                ++i;
            }
            this._userNameTextField.setText(users.toString());
            String[] groupName = this._adapter.getGroupNames();
            StringBuffer groups = new StringBuffer(groupName.length * 16);
            int i2 = 0;
            while (i2 < groupName.length) {
                groups.append(groupName[i2]).append('\n');
                ++i2;
            }
            this._groupNameTextField.setText(groups.toString());
            if (userName.length > 0 || groupName.length > 0) {
                this._userBasedRadioButton.setSelection(true);
            } else {
                this._noMappingRadioButton.setSelection(true);
            }
        }
        this.handleMappingTypeRadioButtonSelection();
        this.updateSpecificEditableBehavior();
    }

    protected void updateSpecificEditableBehavior() {
        if (this.isEditable()) {
            // empty if block
        }
        this._groupNameTextField.setEditable(false);
        if (this.isEditable()) {
            // empty if block
        }
        this._userNameTextField.setEditable(false);
        if (this.isEditable()) {
            // empty if block
        }
        this._userBasedRadioButton.setEnabled(false);
        boolean selected = this._roleBasedRadioButton.getSelection();
        this._serverRoleNameTextField.setEnabled(this.isEditable() && selected);
    }

    public String getServerRoleName() {
        if (this._roleBasedRadioButton.getSelection()) {
            return this._serverRoleNameTextField.getText();
        }
        return null;
    }

    public String[] getGroupNames() {
        if (this._userBasedRadioButton.getSelection()) {
            return Util.splitString((String)this._groupNameTextField.getText(), null);
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getUserNames() {
        if (this._userBasedRadioButton.getSelection()) {
            return Util.splitString((String)this._userNameTextField.getText(), null);
        }
        return EMPTY_STRING_ARRAY;
    }

    public int getUserGridNumOfColumns() {
        return 1;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    private void handleMappingTypeRadioButtonSelection() {
        this.updateSpecificEditableBehavior();
        if (this._roleBasedRadioButton.getSelection()) {
            this._userNameTextField.setText("");
            this._groupNameTextField.setText("");
        } else if (this._userBasedRadioButton.getSelection()) {
            this._serverRoleNameTextField.setText("");
        } else {
            this._serverRoleNameTextField.setText("");
            this._userNameTextField.setText("");
            this._groupNameTextField.setText("");
        }
    }

    private class TextModifyAdapter
    implements ModifyListener {
        private TextModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            SecurityRoleSelectionComponent.this._adapter.securityRoleChanged();
        }
    }

    private class CheckboxListener
    extends SelectionAdapter {
        private CheckboxListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            SecurityRoleSelectionComponent.this._serverRoleNameTextField.setText("");
            SecurityRoleSelectionComponent.this.handleMappingTypeRadioButtonSelection();
            SecurityRoleSelectionComponent.this._adapter.securityRoleChanged();
        }
    }
}

