/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.common;

import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ear.dd.IApplication;
import com.tssap.j2ee.model.ear.dd.IDisplayName;
import com.tssap.j2ee.model.ext.XMLParserHelper;
import com.tssap.j2ee.model.ext.ear.dd.IApplicationJ2eeEngine;
import com.tssap.j2ee.model.ext.ear.dd.IProviderName;
import com.tssap.j2ee.model.wsproxy.IWsDeployableProxyProject;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;

public class ReferencesHelper {
    public static final char PROVIDER_SEPARATOR = '/';

    public static String getApplicationDefinition(IEarProject earProject) {
        IProviderName providerName;
        IApplicationJ2eeEngine applicationJ2eeEngine;
        IDisplayName displayName;
        if (earProject == null) {
            return null;
        }
        String name = null;
        String vendor = "";
        IApplication application = earProject.getDescriptor();
        if (application != null && (displayName = application.getDisplayName()) != null) {
            name = displayName.getValue();
        }
        if ((applicationJ2eeEngine = XMLParserHelper.getApplicationJ2eeEngineForProject((IProject)earProject.getProject())) != null && (providerName = applicationJ2eeEngine.getProviderName()) != null) {
            vendor = providerName.getValue();
        }
        if (name == null) {
            return null;
        }
        return ReferencesHelper.concatVendorAndName(vendor, name);
    }

    public static String getApplicationDefinition(IWsDeployableProxyProject wsProject) {
        if (wsProject == null) {
            return null;
        }
        String name = wsProject.getDisplayName();
        String vendor = wsProject.getProviderName();
        if (vendor == null) {
            vendor = "";
        }
        if (name == null) {
            return null;
        }
        return ReferencesHelper.concatVendorAndName(vendor, name);
    }

    public static String[] getAllApplicationDefinitions(IEarProject exclude) {
        String excludeString = ReferencesHelper.getApplicationDefinition(exclude);
        ArrayList<String> l = new ArrayList<String>();
        IEarProject[] earProjects = J2eeProjectManager.getEarProjects();
        int i = 0;
        while (i < earProjects.length) {
            String definition = ReferencesHelper.getApplicationDefinition(earProjects[i]);
            if (definition != null && !definition.equals(excludeString)) {
                l.add(definition);
            }
            ++i;
        }
        IWsDeployableProxyProject[] wsProjects = J2eeProjectManager.getWsDeployableProxyProjects();
        int i2 = 0;
        while (i2 < wsProjects.length) {
            String definition = ReferencesHelper.getApplicationDefinition(wsProjects[i2]);
            if (definition != null && !definition.equals(excludeString)) {
                l.add(definition);
            }
            ++i2;
        }
        String[] result = new String[l.size()];
        l.toArray(result);
        return result;
    }

    public static final String concatVendorAndName(String vendor, String name) {
        return vendor + '/' + name;
    }

    public static final String[] splitVendorAndName(String vendorAndName) {
        String[] result = new String[2];
        int index = vendorAndName.indexOf(47);
        result[0] = vendorAndName.substring(0, index);
        result[1] = vendorAndName.substring(index + 1);
        return result;
    }
}

