/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.common;

import com.sap.ide.eclipse.j2ee.model.ui.common.EditableGenericComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.IReferenceComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.IReferenceComponentAdapter;
import com.sap.ide.eclipse.j2ee.model.ui.common.ReferencesHelper;
import com.tssap.tools.addlib.AddLibManager;
import com.tssap.tools.addlib.IAddLib;
import com.tssap.tools.addlib.IAddLibDefinition;
import com.tssap.tools.addlib.internal.AddLibDefinition;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class ReferenceComponent
extends EditableGenericComponent
implements IReferenceComponent {
    private Combo _referenceTypeTextField;
    private Text _referenceTargetTextField;
    private Combo _referenceTargetTypeTextField;
    private Text _providerNameTextField;
    private IReferenceComponentAdapter _adapter;
    private String[] _referenceTypes;
    private String[] _referenceTargetTypes;
    private boolean _modifyCallbackActive = true;

    public ReferenceComponent(IReferenceComponentAdapter adapter, String[] referenceTypes, String[] referenceTargetTypes) {
        this._adapter = adapter;
        this._referenceTypes = referenceTypes;
        this._referenceTargetTypes = referenceTargetTypes;
    }

    public void initContainer(IGridLayoutPane originalUserArea) {
        IGridLayoutPane userArea = originalUserArea.addGridLayoutPane(1, false, originalUserArea.createGridLayoutData(4, 4, true, true));
        IGridLayoutPane pane = userArea.addGridLayoutPane(2, false, userArea.createGridLayoutData(4, 4, true, false));
        pane.addTextLabel("Reference target");
        this._referenceTargetTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        pane.addTextLabel("Reference type");
        this._referenceTypeTextField = pane.addComboBox(this._referenceTypes, "", true, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        pane.addTextLabel("Reference target type");
        this._referenceTargetTypeTextField = pane.addComboBox(this._referenceTargetTypes, "", true, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        pane.addTextLabel("Provider name");
        this._providerNameTextField = pane.addTextField("", false, pane.createGridLayoutData(4, 4, true, false, 2, 1));
        this.decorateControls();
    }

    private void decorateControls() {
        this._referenceTargetTextField.addModifyListener((ModifyListener)new TextModifyAdapter());
        this._referenceTypeTextField.addModifyListener((ModifyListener)new TextModifyAdapter());
        this._referenceTargetTypeTextField.addModifyListener((ModifyListener)new TextModifyAdapter());
        this._providerNameTextField.addModifyListener((ModifyListener)new TextModifyAdapter());
    }

    public void refresh() {
        try {
            this._modifyCallbackActive = false;
            this._referenceTypeTextField.setText(this._adapter.getAttribReferenceType());
            this._referenceTargetTextField.setText(this._adapter.getReferenceTarget());
            this._referenceTargetTypeTextField.setText(this._adapter.getAttribTargetType());
            this._providerNameTextField.setText(this._adapter.getAttribProviderName());
            this.setTitle(this._referenceTargetTextField.getText());
            this.updateSpecificEditableBehavior();
            Object var2_1 = null;
            this._modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._modifyCallbackActive = true;
            throw throwable;
        }
    }

    protected void updateSpecificEditableBehavior() {
        boolean isEnabled = true;
        String type = this._referenceTargetTypeTextField.getText();
        if (!type.equals("application")) {
            AddLibDefinition current = new AddLibDefinition(this._providerNameTextField.getText(), this._referenceTargetTextField.getText());
            IAddLib[] existing = AddLibManager.getManager().getAddLibsByVendor(current.getVendor());
            int i = 0;
            while (i < existing.length) {
                if (current.matches((IAddLibDefinition)existing[i])) {
                    isEnabled = false;
                    break;
                }
                ++i;
            }
        } else {
            String current = ReferencesHelper.concatVendorAndName(this._providerNameTextField.getText(), this._referenceTargetTextField.getText());
            String[] existing = ReferencesHelper.getAllApplicationDefinitions(null);
            int i = 0;
            while (i < existing.length) {
                if (current.equals(existing[i])) {
                    isEnabled = false;
                    break;
                }
                ++i;
            }
        }
        this._referenceTargetTextField.setEditable(this.isEditable() && isEnabled);
        this._referenceTargetTypeTextField.setEnabled(this.isEditable() && isEnabled && this._referenceTargetTypeTextField.getItemCount() > 1);
        this._providerNameTextField.setEditable(this.isEditable() && isEnabled);
        this._referenceTypeTextField.setEnabled(this.isEditable() && this._referenceTypeTextField.getItemCount() > 1);
    }

    public String getAttribReferenceType() {
        return this._referenceTypeTextField.getText();
    }

    public String getReferenceTarget() {
        return this._referenceTargetTextField.getText();
    }

    public String getAttribTargetType() {
        return this._referenceTargetTypeTextField.getText();
    }

    public String getAttribProviderName() {
        return this._providerNameTextField.getText();
    }

    public int getUserGridNumOfColumns() {
        return 1;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    private class TextModifyAdapter
    implements ModifyListener {
        private TextModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (!ReferenceComponent.this._modifyCallbackActive) {
                return;
            }
            ReferenceComponent.this._adapter.referenceChanged();
        }
    }
}

