/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.common;

import com.sap.ide.eclipse.j2ee.model.ui.common.EditableGenericComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.IColumnSelectionComponent;
import com.sap.ide.eclipse.j2ee.model.ui.common.IColumnSelectionComponentAdapter;
import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.ColumnIterator;
import com.sap.sql.catalog.Table;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import com.tssap.util.ui.pane.IGridLayoutPane;
import java.util.ArrayList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;

public class ColumnSelectionComponent
extends EditableGenericComponent
implements IColumnSelectionComponent {
    public static final Image IMAGE_COLUMN_NOT_VERIFIED = SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_MESSAGE_WARNING);
    public static final Image IMAGE_COLUMN_VERIFIED = SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_CHECKED);
    public static final String TEXT_TABLE_NOT_VERIFIED = "The table can not be verified by the data dictionary";
    public static final String TEXT_COLUMN_NOT_VERIFIED = "The column can not be verified by the data dictionary";
    public static final String TEXT_COLUMN_VERIFIED = "The column is verified by the data dictionary";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private Combo _columnNameCombo;
    private Label _columnVerifiedStatusImage;
    private Label _columnVerifiedStatusText;
    private Label _tableNameText;
    private IColumnSelectionComponentAdapter _adapter;
    private Table _table;
    private String _tableName;
    private Column _column;
    private String _columnName;
    private boolean _modifyCallbackActive = true;

    public ColumnSelectionComponent(IColumnSelectionComponentAdapter adapter) {
        this._adapter = adapter;
    }

    public void initContainer(IGridLayoutPane originalUserArea) {
        IGridLayoutPane userArea = originalUserArea.addGridLayoutPane(1, false, originalUserArea.createGridLayoutData(4, 4, true, false));
        IGridLayoutPane pane = userArea.addGridLayoutPane(2, false, userArea.createGridLayoutData(4, 4, true, false));
        pane.addTextLabel("Table name");
        this._tableNameText = pane.addTextLabel(" ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        pane.addTextLabel("Column name");
        this._columnNameCombo = pane.addComboBox(EMPTY_STRING_ARRAY, " ", false, pane.createGridLayoutData(4, 4, true, false, 1, 1));
        userArea.addPlaceholder();
        pane = userArea.addGridLayoutPane(2, false, userArea.createGridLayoutData(4, 4, true, false));
        this._columnVerifiedStatusImage = pane.addImage(IMAGE_COLUMN_NOT_VERIFIED, false, pane.createGridLayoutData(4, 4, false, false, 1, 1));
        this._columnVerifiedStatusText = pane.addTextLabel(" ", pane.createGridLayoutData(4, 4, true, false, 1, 1));
        this.decorateControls();
    }

    private void decorateControls() {
        this._columnNameCombo.addModifyListener((ModifyListener)new NameModifyAdapter());
    }

    public void refresh() {
        this._table = this._adapter.getTable();
        this._tableName = this._adapter.getTableName();
        this._tableNameText.setText(this._tableName);
        try {
            this._modifyCallbackActive = false;
            if (this._table == null) {
                this._columnNameCombo.setItems(EMPTY_STRING_ARRAY);
            } else {
                ArrayList<String> columnList = new ArrayList<String>();
                ColumnIterator iterator = this._table.getColumns();
                while (iterator.hasNext()) {
                    columnList.add(iterator.next().getName());
                }
                String[] column = new String[columnList.size()];
                columnList.toArray(column);
                this._columnNameCombo.setItems(column);
            }
            this._columnName = this._adapter.getColumnName();
            this._columnNameCombo.setText(this._columnName == null ? "" : this._columnName);
            Object var5_4 = null;
            this._modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._modifyCallbackActive = true;
            throw throwable;
        }
        this.updateColumnAfterNameChange();
    }

    protected void updateSpecificEditableBehavior() {
        this._columnNameCombo.setEnabled(this.isEditable());
        this._columnName = this._adapter.getColumnName();
        try {
            this._modifyCallbackActive = false;
            this._columnNameCombo.setText(this._columnName == null ? "" : this._columnName);
            Object var2_1 = null;
            this._modifyCallbackActive = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._modifyCallbackActive = true;
            throw throwable;
        }
        this.updateColumnAfterNameChange();
    }

    public String getColumnName() {
        return this._columnName;
    }

    public Column getColumn() {
        return this._column;
    }

    public int getUserGridNumOfColumns() {
        return 1;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    private void updateColumnAfterNameChange() {
        this._column = null;
        if (this._table != null) {
            this._column = this._table.getColumn(this._columnName);
        }
        this.refreshStatusLabels();
    }

    private void refreshStatusLabels() {
        if (!this.isEnabled()) {
            this._columnVerifiedStatusText.setText("");
            this._columnVerifiedStatusImage.setImage(null);
        } else if (this._column == null) {
            if (this._table == null) {
                this._columnVerifiedStatusText.setText(TEXT_TABLE_NOT_VERIFIED);
            } else {
                this._columnVerifiedStatusText.setText(TEXT_COLUMN_NOT_VERIFIED);
            }
            this._columnVerifiedStatusImage.setImage(IMAGE_COLUMN_NOT_VERIFIED);
        } else {
            this._columnVerifiedStatusText.setText(TEXT_COLUMN_VERIFIED);
            this._columnVerifiedStatusImage.setImage(IMAGE_COLUMN_VERIFIED);
        }
    }

    private class NameModifyAdapter
    implements ModifyListener {
        private NameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            ColumnSelectionComponent.this._columnName = ColumnSelectionComponent.this._columnNameCombo.getText();
            ColumnSelectionComponent.this.updateColumnAfterNameChange();
            if (ColumnSelectionComponent.this._modifyCallbackActive) {
                ColumnSelectionComponent.this._adapter.columnChanged();
            }
        }
    }
}

