/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.model.ui.archive;

import com.sap.ide.eclipse.j2ee.model.ui.saplibrary.internal.LibProjectInfoUtil;
import com.tssap.j2ee.model.ext.XMLParserHelper;
import com.tssap.j2ee.model.ext.library.dd.IProviderDescriptor;
import com.tssap.j2ee.model.library.IJ2EELibraryProject;
import com.tssap.tools.archive.ArchiveDescriptionManager;
import com.tssap.tools.archive.IArchiveDescriptor;
import com.tssap.tools.archive.IFileSet;
import com.tssap.tools.archive.IProjectFileSet;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BuildLibrary {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$model$ui$archive$BuildLibrary == null ? (class$com$sap$ide$eclipse$j2ee$model$ui$archive$BuildLibrary = BuildLibrary.class$("com.sap.ide.eclipse.j2ee.model.ui.archive.BuildLibrary")) : class$com$sap$ide$eclipse$j2ee$model$ui$archive$BuildLibrary));
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$model$ui$archive$BuildLibrary;

    public static void build(IJ2EELibraryProject libraryProject) {
        IProject project = libraryProject.getProject();
        String archiveName = libraryProject.getArchiveLocation() + libraryProject.getArchiveName();
        IProviderDescriptor providerDescriptor = XMLParserHelper.getProviderDescriptorForProject((IProject)project);
        if (providerDescriptor == null) {
            throw new RuntimeException("Can not read / parse the xml-file server/provider.xml");
        }
        String vendorName = providerDescriptor.getProviderName().getValue();
        String componentName = providerDescriptor.getComponentName().getValue();
        IArchiveDescriptor descriptor = ArchiveDescriptionManager.newArchiveDescription();
        descriptor.getComponentBuildInfo().setUseComponentBuild(true);
        descriptor.setDestPath(project, archiveName);
        descriptor.getComponentBuildInfo().getComponent().setName(componentName);
        descriptor.getComponentBuildInfo().getComponent().setVendor(vendorName);
        descriptor.getComponentBuildInfo().setDeployFile(libraryProject.getSDADDFile().getLocation().toFile());
        IProjectFileSet fileset = ArchiveDescriptionManager.getProjectFileSet();
        IFile providerXmlFile = project.getFile("server/provider.xml");
        fileset.addProjectFile(providerXmlFile, "server/provider.xml");
        IFile logConfigurationXmlFile = project.getFile("server/descriptors/log-configuration.xml");
        if (logConfigurationXmlFile != null && logConfigurationXmlFile.exists()) {
            fileset.addProjectFile(logConfigurationXmlFile, "server/descriptors/log-configuration.xml");
        }
        IFile[] jarFile = LibProjectInfoUtil.getReferenceJars(project);
        int i = 0;
        while (i < jarFile.length) {
            fileset.addProjectFile(jarFile[i]);
            ++i;
        }
        descriptor.addFileSet((IFileSet)fileset);
        descriptor.performBuild();
        BuildLibrary.refreshProject(project);
    }

    public static void refreshProject(IProject prj) {
        String METHOD = "refreshProject(IProject)";
        try {
            prj.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            TRACER.warning(METHOD, "Can not refresh project: " + e.toString(), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

