/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.remotedriver.tcp;

import com.sap.tc.jtools.jver.JverVersion;
import com.sap.tc.jtools.jver.core.DbgLog;
import com.sap.tc.jtools.jver.core.IJverMsgContents;
import com.sap.tc.jtools.jver.core.IJverRunnerSettings;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverMsgStack;
import com.sap.tc.jtools.jver.driver.AJverListener;
import com.sap.tc.jtools.jver.remotedriver.tcp.Driver;
import com.sap.tc.jtools.jver.remotedriver.tcp.IDatagramm;
import com.sap.tc.jtools.jver.remotedriver.tcp.StandardOut;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.net.SocketException;

class ListenerStub
extends AJverListener
implements IDatagramm {
    private final int fPort;
    private final String fHost;
    private Socket fSocket = null;
    private PrintWriter fWriter = null;
    private BufferedReader fReader = null;
    private String fTestclassName = "";
    private final boolean fTraceSteps;
    private final boolean fLocalMode;
    private final boolean fShutdownRequested = false;
    private final StandardOut fTraceOut;

    ListenerStub(String pHost, int pPort, StandardOut pTraceOut, boolean pLocalMode) {
        this.fHost = pHost;
        this.fPort = pPort;
        this.fLocalMode = pLocalMode;
        if (null != pTraceOut) {
            this.fTraceOut = pTraceOut;
            this.fTraceSteps = true;
        } else {
            this.fTraceOut = pTraceOut;
            this.fTraceSteps = false;
        }
    }

    boolean connect(Driver pDriver) {
        if (this.fLocalMode) {
            String msg = "local testmode => no connection";
            DbgLog.println(msg);
            if (this.fTraceSteps) {
                this.fTraceOut.println(msg);
            }
            this.fWriter = new PrintWriter(System.out);
            this.fReader = null;
            return true;
        }
        IOException exception = null;
        int i = 0;
        while (i < 10) {
            try {
                this.fSocket = new Socket(this.fHost, this.fPort);
                try {
                    this.fSocket.setSoLinger(true, 20);
                    this.fSocket.setKeepAlive(true);
                }
                catch (SocketException e) {
                    // empty catch block
                }
                DbgLog.println("connected to port (" + this.fPort + ")");
                this.fWriter = new PrintWriter(this.fSocket.getOutputStream(), false);
                this.fReader = new BufferedReader(new InputStreamReader(this.fSocket.getInputStream()));
                PeerMessageMonitor thr = new PeerMessageMonitor(pDriver);
                thr.setDaemon(true);
                thr.start();
                return true;
            }
            catch (IOException e) {
                exception = e;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                ++i;
            }
        }
        if (null == this.fHost || this.fHost.equals("")) {
            System.err.println("could not connect to port: [" + this.fPort + "]");
        } else {
            System.err.println("could not connect to: [" + this.fHost + ":" + this.fPort + "]");
        }
        exception.printStackTrace();
        return false;
    }

    void disconnect() {
        try {
            if (null != this.fWriter) {
                this.fWriter.flush();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.fWriter.close();
            }
            if (null != this.fSocket) {
                try {
                    this.fSocket.close();
                }
                catch (IOException iOException) {
                }
            }
            Object var3_3 = null;
            this.fWriter = null;
            this.fSocket = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fWriter = null;
            this.fSocket = null;
            throw throwable;
        }
    }

    private String getContent(Throwable pThrowable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        pThrowable.printStackTrace(writer);
        return stringWriter.getBuffer().toString();
    }

    private String getContent(IJverMsgContents pContent) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.println(pContent.getMessage());
        JverMsgStack msgStack = pContent.getStack();
        if (null != msgStack) {
            int numLines = msgStack.getLength();
            int ii = 0;
            while (ii < numLines) {
                writer.println(msgStack.getLine(ii));
                ++ii;
            }
        }
        return stringWriter.getBuffer().toString();
    }

    private void sendMessage(String pMessage) {
        if (null == this.fWriter) {
            return;
        }
        PrintWriter printWriter = this.fWriter;
        synchronized (printWriter) {
            if (this.fTraceSteps) {
                DbgLog.println(pMessage);
                this.fTraceOut.println(pMessage);
            }
            if (!this.fLocalMode) {
                this.fWriter.println(pMessage);
                this.fWriter.flush();
            }
        }
    }

    public void announceTestTaskStart(int pNumTestsets) {
        this.sendMessage("%!JVER!$" + JverVersion.VERSION);
        this.sendMessage("%!TJST!$" + pNumTestsets);
    }

    public void announceTestTaskEnd(IMsgCollector msgCollector) {
    }

    public void announceMyTestTaskCompletion(long pDuration) {
        this.sendMessage("%!TJDO!$" + pDuration);
    }

    public void announceMyTestTaskAbortion(long pDuration) {
        this.sendMessage("%!TJAB!$" + pDuration);
    }

    public void announceMyTestTaskTermination(Throwable pCause) {
        if (null != pCause) {
            this.sendMessage("\u00a7\u00a7TERM\u00a7\u00a7");
            this.sendMessage("%:TRBG:$");
            this.sendMessage(this.getContent(pCause));
            this.sendMessage("%:TRED:$");
            this.sendMessage("%!TJTE!$" + pCause.getMessage());
        } else {
            this.sendMessage("%!TJTE!$no known reason");
        }
    }

    public void announceTestsetStart(String pTestsetName) {
        this.fTestclassName = pTestsetName;
        this.sendMessage("%;TSST;$" + pTestsetName);
    }

    public void announceTestsetStart(IJverRunnerSettings runnerSettings) {
        int nTests = runnerSettings.getTestMethodCount();
        this.sendMessage("%;TSCT;$" + nTests);
    }

    public void announceTestsetEnd() {
        this.sendMessage("%;TSDO;$");
        this.fTestclassName = "";
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void announceTestStart(String pTestmethodName) {
        int posDelim = pTestmethodName.lastIndexOf(":");
        if (0 >= posDelim) {
            String methodName = pTestmethodName.substring(posDelim + 1);
            this.sendMessage("%?TCST?$" + this.fTestclassName + "(<*>)" + methodName);
        } else {
            this.sendMessage("%?TCST?$" + this.fTestclassName + "(<*>)" + pTestmethodName);
        }
    }

    public void announceTestSkip(String pTestmethodName) {
        this.sendMessage("%?TCSK?$" + this.fTestclassName + "(<*>)" + pTestmethodName);
    }

    public void announceTestEnd(boolean pOkay) {
        if (pOkay) {
            this.sendMessage("%?TCDO?$SUCCESS");
        } else {
            this.sendMessage("%?TCDO?$FAILURE");
        }
    }

    public void announceFlop(IJverMsgContents contents) {
        this.sendMessage("%%FLOP%%");
        this.sendMessage("%:TRBG:$");
        this.sendMessage(this.getContent(contents));
        this.sendMessage("%:TRED:$");
    }

    public void announcePerformanceFlop(IJverMsgContents contents) {
        this.sendMessage("%%FLOP%%");
        this.sendMessage("%:TRBG:$");
        this.sendMessage(this.getContent(contents));
        this.sendMessage("%:TRED:$");
    }

    public void announceWarning(IJverMsgContents contents) {
        this.sendMessage("%%WARN%%");
        this.sendMessage("%:TRBG:$");
        this.sendMessage(this.getContent(contents));
        this.sendMessage("%:TRED:$");
    }

    private class PeerMessageMonitor
    extends Thread {
        final Driver fDriver;

        public PeerMessageMonitor(Driver pDriver) {
            super("PeerMessageMonitor");
            this.fDriver = pDriver;
        }

        public void run() {
            try {
                String message = null;
                while (null == (message = ListenerStub.this.fReader.readLine()) || !message.startsWith("--STOP--")) {
                }
                DbgLog.println("shutdown requested");
                this.fDriver.requestHalt();
                return;
            }
            catch (Exception e) {
                this.fDriver.requestHalt();
                return;
            }
        }
    }
}

