/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.remotedriver.tcp;

import com.sap.tc.jtools.jver.remotedriver.tcp.IDatagramm;
import com.sap.tc.jtools.jver.remotedriver.tcp.IEvaluation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class ListenerPeer
implements IDatagramm {
    private IEvaluation fEval;
    private ServerSocket fServerSocket;
    private String fHost = "localhost";
    private int fPort = -1;
    private BufferedReader fBufferedReader;
    private Socket fSocket;
    private PrintWriter fWriter;
    private boolean fDebugOutput = false;
    private boolean fInReadTrace = false;
    private String fTestsetName = "";
    private String fTestclassName = "";
    private String fTestmethodName = "";
    private String fFlopMessage = "";
    private String fFailureTrace;
    private String fRunnerVersion = null;
    private int fFailureKind = 0;
    private boolean fDebug = false;

    public synchronized void startListenerThread(IEvaluation pEvaluation, int pPort) {
        this.fEval = pEvaluation;
        this.fHost = "";
        this.fPort = pPort;
        PeerServer tcpServer = new PeerServer(this.fPort);
        tcpServer.setPriority(5);
        tcpServer.setDaemon(true);
        tcpServer.start();
    }

    public synchronized void enableConsoleIO(boolean pDoDump) {
        this.fDebugOutput = pDoDump;
    }

    public synchronized void abortTestjob() {
        if (this.isRunning()) {
            this.fWriter.println("--STOP--");
            this.fWriter.flush();
        }
    }

    private synchronized void shutDown() {
        try {
            if (this.fWriter != null) {
                this.fWriter.close();
            }
            try {
                if (this.fBufferedReader != null) {
                    this.fBufferedReader.close();
                }
            }
            catch (IOException ignore) {
                // empty catch block
            }
            try {
                if (this.fSocket != null) {
                    this.fSocket.close();
                }
            }
            catch (IOException ignore) {
                // empty catch block
            }
            try {
                if (this.fServerSocket != null) {
                    this.fServerSocket.close();
                }
            }
            catch (IOException iOException) {
            }
            Object var3_4 = null;
            this.fWriter = null;
            this.fBufferedReader = null;
            this.fSocket = null;
            this.fServerSocket = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.fWriter = null;
            this.fBufferedReader = null;
            this.fSocket = null;
            this.fServerSocket = null;
            throw throwable;
        }
    }

    public boolean isRunning() {
        return this.fSocket != null;
    }

    private String readMessage(BufferedReader in) throws IOException {
        return in.readLine();
    }

    private void receiveMessage(String message) {
        String arg;
        if (this.fDebugOutput) {
            System.out.println(message);
        }
        if (message.startsWith("%:TRBG:$")) {
            this.fInReadTrace = true;
            this.fFailureTrace = "";
            return;
        }
        if (message.startsWith("%:TRED:$")) {
            this.fInReadTrace = false;
            this.fEval.processFailure(this.fTestclassName, this.fTestmethodName, this.fFailureKind, this.fFailureTrace);
            this.fFailureTrace = "";
            return;
        }
        if (message.startsWith("%:TRNO:$")) {
            this.fFailureTrace = "";
            this.fEval.processFailure(this.fTestclassName, this.fTestmethodName, this.fFailureKind, this.fFailureTrace);
            this.fFlopMessage = "";
            return;
        }
        if (this.fInReadTrace) {
            this.fFailureTrace = this.fFailureTrace + message + '\n';
        }
        try {
            arg = message.substring(8);
        }
        catch (StringIndexOutOfBoundsException ignore) {
            arg = "";
        }
        if (message.startsWith("%?TCST?$")) {
            int index = arg.indexOf("(<*>)");
            if (0 > index) {
                return;
            }
            this.fTestclassName = arg.substring(0, index);
            this.fTestmethodName = arg.substring(index + "(<*>)".length());
            this.fEval.processTestcaseStart(this.fTestclassName, this.fTestmethodName);
            return;
        }
        if (message.startsWith("%?TCDO?$")) {
            this.fEval.processTestcaseCompletion(this.fTestclassName, this.fTestmethodName);
            this.fTestmethodName = "";
            this.fTestclassName = "";
            return;
        }
        if (message.startsWith("\u00a7\u00a7TERM\u00a7\u00a7")) {
            this.fFailureKind = 3;
            return;
        }
        if (message.startsWith("%%WARN%%")) {
            this.fFailureKind = 1;
            return;
        }
        if (message.startsWith("%%FLOP%%")) {
            this.fFailureKind = 2;
            return;
        }
        if (message.startsWith("%;TSST;$")) {
            this.fTestsetName = arg;
            this.fTestmethodName = "";
            this.fTestclassName = "";
            this.fEval.processTestsetStart(this.fTestsetName);
            return;
        }
        if (message.startsWith("%;TSCT;$")) {
            int numTestmethods = Integer.parseInt(arg);
            if (numTestmethods < 1) {
                numTestmethods = 1;
            }
            this.fEval.processTestsetExpectedTestcount(this.fTestsetName, numTestmethods);
            return;
        }
        if (message.startsWith("%;TSDO;$")) {
            this.fEval.processTestsetCompletion(this.fTestsetName);
            this.fTestsetName = "";
            this.fTestmethodName = "";
            this.fTestclassName = "";
            return;
        }
        if (message.startsWith("%!TJST!$")) {
            int numTestsets;
            try {
                numTestsets = Integer.parseInt(arg);
            }
            catch (NumberFormatException ignore) {
                numTestsets = 0;
            }
            this.fEval.processJobStart(numTestsets, this.fRunnerVersion);
            this.fTestsetName = "";
            this.fTestmethodName = "";
            this.fTestclassName = "";
            return;
        }
        if (message.startsWith("%!TJDO!$")) {
            long elapsedTime;
            try {
                elapsedTime = Long.parseLong(arg);
            }
            catch (NumberFormatException ignore) {
                elapsedTime = 0L;
            }
            this.fEval.processJobCompletion(elapsedTime);
            this.fTestsetName = "";
            this.fTestmethodName = "";
            this.fTestclassName = "";
            return;
        }
        if (message.startsWith("%!TJAB!$")) {
            long elapsedTime;
            try {
                elapsedTime = Long.parseLong(arg);
            }
            catch (NumberFormatException ignore) {
                elapsedTime = 0L;
            }
            this.fEval.processJobAbortion(elapsedTime);
            this.fTestsetName = "";
            this.fTestmethodName = "";
            this.fTestclassName = "";
            return;
        }
        if (message.startsWith("%!TJTE!$")) {
            this.fEval.processJobTermination(arg);
            this.fTestsetName = "";
            this.fTestmethodName = "";
            this.fTestclassName = "";
            this.shutDown();
            return;
        }
        if (message.startsWith("%!JVER!$")) {
            this.fRunnerVersion = arg;
            return;
        }
    }

    private class PeerServer
    extends Thread {
        int fPortNumber;

        public PeerServer(int pPortNumber) {
            super("PeerServer");
            this.fPortNumber = pPortNumber;
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            try {
                String message;
                ListenerPeer.this.fServerSocket = new ServerSocket(this.fPortNumber);
                ListenerPeer.this.fServerSocket.setSoTimeout(600000);
                ListenerPeer.this.fSocket = ListenerPeer.this.fServerSocket.accept();
                ListenerPeer.this.fBufferedReader = new BufferedReader(new InputStreamReader(ListenerPeer.this.fSocket.getInputStream()));
                ListenerPeer.this.fWriter = new PrintWriter(ListenerPeer.this.fSocket.getOutputStream(), true);
                while (ListenerPeer.this.fBufferedReader != null && (message = ListenerPeer.this.readMessage(ListenerPeer.this.fBufferedReader)) != null) {
                    void var1_1;
                    ListenerPeer.this.receiveMessage((String)var1_1);
                }
            }
            catch (SocketException e) {
                ListenerPeer.this.fEval.processJobTermination(e.getMessage());
            }
            catch (IOException e) {
                System.out.println(e);
            }
            ListenerPeer.this.shutDown();
        }
    }
}

