/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.remotedriver.tcp;

import com.sap.tc.jtools.jver.JverVersion;
import com.sap.tc.jtools.jver.driver.JverOption;
import com.sap.tc.jtools.jver.remotedriver.tcp.CommandOption;
import com.sap.tc.jtools.jver.remotedriver.tcp.StandardOut;
import com.sap.tc.jtools.jver.scanner.JverClassLoaderType;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;

class ArgumentHandler {
    private static final String[] fgEmptyArray = new String[0];
    private static final CommandOption[] fgOptions;
    private static final CommandOption fgOptLogRunner;
    private static final CommandOption fgOptCfgFile;
    private static final CommandOption fgOptDebugOutput;
    private static final CommandOption fgOptHelp;
    private static final CommandOption fgOptHost;
    private static final CommandOption fgOptIniFile;
    private static final CommandOption fgOptJobFile;
    private static final CommandOption fgOptLoader;
    private static final CommandOption fgOptLocalOnly;
    private static final CommandOption fgOptPerformanceMode;
    private static final CommandOption fgOptSelfTest;
    private static final CommandOption fgOptLogTestcase;
    private JverOption fOption;
    private StandardOut fOutput;
    private String[] fTestcases = fgEmptyArray;
    private String fRemoteHost = "";
    private int fRemotePort = 12000;
    private boolean fSplatterScreen = false;
    private boolean fLocalOnly = false;
    private URL fTaskFileURL = null;
    static /* synthetic */ Class class$com$sap$tc$jtools$jver$remotedriver$tcp$Driver;

    public ArgumentHandler(StandardOut pOutput) {
        this.fOutput = pOutput;
        this.fOption = new JverOption();
        this.fOption.setClassTargets(true);
        this.fOption.setClassLoaderType(JverClassLoaderType.SYSTEM_CLASS_LOADER);
    }

    public JverOption getOption() {
        return this.fOption;
    }

    public String[] getTestcases() {
        return null == this.fTestcases ? fgEmptyArray : this.fTestcases;
    }

    public URL getTaskFileURL() {
        return this.fTaskFileURL;
    }

    public String getHost() {
        return null == this.fRemoteHost ? "" : this.fRemoteHost;
    }

    public int getPort() {
        return 100 > this.fRemotePort ? 10000 : this.fRemotePort;
    }

    public boolean getLocalRequested() {
        return this.fLocalOnly;
    }

    public boolean getTraceRequested() {
        return this.fSplatterScreen;
    }

    public void processArguments(String[] pArguments) {
        block37: {
            int numTestcases;
            Vector<String> testCases;
            block36: {
                testCases = new Vector<String>(100, 10);
                if (2 > pArguments.length) {
                    this.abortBadArgs("too few arguments");
                }
                try {
                    this.fRemotePort = Integer.parseInt(pArguments[0]);
                }
                catch (NumberFormatException numberFormat) {
                    this.abortBadArgs("argument is no valid port number:" + pArguments[0]);
                }
                int ii = 1;
                boolean taskFile = false;
                while (ii < pArguments.length) {
                    String curArg = pArguments[ii++];
                    String curParm = null;
                    if (this.isOption(curArg)) {
                        char option = curArg.charAt(1);
                        if (ArgumentHandler.fgOptLogRunner.fLiteral == option) {
                            if (ii >= pArguments.length || this.isOption(pArguments[ii])) {
                                this.abortBadArgs("arguments miss a log file specification");
                            }
                            if ((curParm = pArguments[ii++]).equals("verbose")) {
                                this.fOption.setVerbose(true);
                                if (ii >= pArguments.length || this.isOption(pArguments[ii])) {
                                    this.abortBadArgs("arguments miss a log file specification");
                                }
                                curParm = pArguments[ii++];
                            }
                            this.fOption.setDbgLogFile(curParm);
                            continue;
                        }
                        if (ArgumentHandler.fgOptCfgFile.fLiteral == option) {
                            if (ii >= pArguments.length || this.isOption(pArguments[ii])) {
                                this.abortBadArgs("arguments miss a config file specification");
                            }
                            curParm = pArguments[ii++];
                            this.fOption.setJverConfigFile(curParm);
                            continue;
                        }
                        if (ArgumentHandler.fgOptDebugOutput.fLiteral == option) {
                            this.fSplatterScreen = true;
                            continue;
                        }
                        if (ArgumentHandler.fgOptHelp.fLiteral == option) {
                            this.printUsage();
                            System.exit(0);
                            continue;
                        }
                        if (ArgumentHandler.fgOptHost.fLiteral == option) {
                            if (ii >= pArguments.length || this.isOption(pArguments[ii])) {
                                this.abortBadArgs("arguments miss a host specification");
                            }
                            this.fRemoteHost = curParm = pArguments[ii++];
                            continue;
                        }
                        if (ArgumentHandler.fgOptIniFile.fLiteral == option) {
                            if (ii >= pArguments.length || this.isOption(pArguments[ii])) {
                                this.abortBadArgs("arguments miss a parameter file specification");
                            }
                            curParm = pArguments[ii++];
                            if (taskFile) {
                                this.fOutput.printWarning("attrib file due task file ignored " + curParm);
                                continue;
                            }
                            this.fOption.setParametersFromFile(true);
                            this.fOption.setParametersFromThisFile(curParm);
                            continue;
                        }
                        if (ArgumentHandler.fgOptJobFile.fLiteral == option) {
                            if (ii >= pArguments.length || this.isOption(pArguments[ii])) {
                                this.abortBadArgs("arguments miss a task file specification");
                            }
                            curParm = pArguments[ii++];
                            try {
                                this.fTaskFileURL = this.getClass().getClassLoader().getResource(curParm);
                                this.fTaskFileURL.getContent();
                            }
                            catch (IOException noFile) {
                                this.abortBadArgs("task file is missing: " + curParm);
                            }
                            this.fOption.setJverConfigFile(curParm);
                            this.fOption.setParametersFromFile(false);
                            taskFile = true;
                            continue;
                        }
                        if (ArgumentHandler.fgOptLoader.fLiteral == option) {
                            if (ii >= pArguments.length || this.isOption(pArguments[ii])) {
                                this.abortBadArgs("arguments miss a class loader specification");
                            }
                            if ((curParm = pArguments[ii++]).equals("url")) {
                                this.fOption.setClassLoaderType(JverClassLoaderType.URL_CLASS_LOADER);
                                continue;
                            }
                            if (curParm.equals("system")) {
                                this.fOption.setClassLoaderType(JverClassLoaderType.SYSTEM_CLASS_LOADER);
                                continue;
                            }
                            this.abortBadArgs("arguments specify an invalid class loader");
                            continue;
                        }
                        if (ArgumentHandler.fgOptLocalOnly.fLiteral == option) {
                            this.fLocalOnly = true;
                            continue;
                        }
                        if (ArgumentHandler.fgOptPerformanceMode.fLiteral == option) {
                            if (ii >= pArguments.length || this.isOption(pArguments[ii])) {
                                this.abortBadArgs("arguments miss a performance log specification");
                            }
                            curParm = pArguments[ii++];
                            this.fOption.setPerfLogFile(curParm);
                            continue;
                        }
                        if (ArgumentHandler.fgOptSelfTest.fLiteral == option) {
                            JverOption.setSelfTest(true);
                            continue;
                        }
                        if (ArgumentHandler.fgOptLogTestcase.fLiteral == option) {
                            if (ii >= pArguments.length || this.isOption(pArguments[ii])) {
                                this.abortBadArgs("arguments miss a user log specification");
                            }
                            curParm = pArguments[ii++];
                            this.fOption.setUserLogFile(curParm);
                            continue;
                        }
                        this.fOutput.printWarning("unknown option: " + option);
                        continue;
                    }
                    testCases.add(curArg);
                }
                if (!taskFile) break block36;
                this.fTestcases = new String[0];
                numTestcases = testCases.size();
                if (0 == numTestcases) break block37;
                this.fOutput.printWarning("testcases due jobfile ignored.");
                int jj = 0;
                while (jj < numTestcases) {
                    this.fOutput.printWarning(testCases.get(jj).toString());
                    ++jj;
                }
                break block37;
            }
            if (testCases.isEmpty()) {
                this.abortBadArgs("arguments do not contain a testcase specification");
            } else {
                numTestcases = testCases.size();
                this.fTestcases = new String[numTestcases];
                int jj = 0;
                while (jj < numTestcases) {
                    this.fTestcases[jj] = (String)testCases.get(jj);
                    ++jj;
                }
            }
        }
    }

    private void abortBadArgs(String pReason) throws IllegalArgumentException {
        this.fOutput.printError(pReason);
        this.printUsage();
        throw new IllegalArgumentException();
    }

    private void printUsage() {
        StringBuffer msgBuf = new StringBuffer(1024);
        msgBuf.append("Usage: ");
        msgBuf.append((class$com$sap$tc$jtools$jver$remotedriver$tcp$Driver == null ? (class$com$sap$tc$jtools$jver$remotedriver$tcp$Driver = ArgumentHandler.class$("com.sap.tc.jtools.jver.remotedriver.tcp.Driver")) : class$com$sap$tc$jtools$jver$remotedriver$tcp$Driver).getName());
        msgBuf.append(" <port> [<option>]* <testclass> [<testclass>]*");
        this.fOutput.println(msgBuf.toString());
        int ii = 0;
        while (ii < fgOptions.length) {
            CommandOption curOpt = fgOptions[ii];
            msgBuf.setLength(0);
            msgBuf.append("-  ").setCharAt(1, curOpt.fLiteral);
            msgBuf.append(curOpt.fHelpArgs).append(": ");
            msgBuf.append(curOpt.fHelpInfo);
            this.fOutput.println(msgBuf.toString());
            ++ii;
        }
    }

    private void printVersion() {
        this.fOutput.println("JVER Base: " + JverVersion.VERSION);
    }

    private boolean isOption(String pArgument) {
        return 2 == pArgument.length() && '-' == pArgument.charAt(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        fgOptLogTestcase = new CommandOption('a', "<file>", "application/user/testcase logging");
        fgOptCfgFile = new CommandOption('c', "<file>", "property file to use for runner execution");
        fgOptLogRunner = new CommandOption('d', "[verbose] <file>", "debug logging of the runner execution");
        fgOptDebugOutput = new CommandOption('D', null, "internal debug output");
        fgOptHelp = new CommandOption('h', null, "prints this information");
        fgOptHost = new CommandOption('H', "<tcp_host_address, for future use: currently only localhost>", "specifies a tcp address of an host");
        fgOptIniFile = new CommandOption('i', "<file>", "initialize test parameters from property file");
        fgOptJobFile = new CommandOption('j', "<file>", "a valid jver jobfile");
        fgOptLoader = new CommandOption('l', "url | system", "specify the class loader for the testcase classes");
        fgOptLocalOnly = new CommandOption('L', null, "local test mode (no tcp connection)");
        fgOptPerformanceMode = new CommandOption('p', "<file>", "enable performance testing and write results to file");
        fgOptSelfTest = new CommandOption('S', null, "jver self test mode");
        fgOptions = new CommandOption[]{fgOptLogRunner, fgOptDebugOutput, fgOptHelp, fgOptHost, fgOptIniFile, fgOptLoader, fgOptLocalOnly, fgOptLogTestcase, fgOptPerformanceMode, fgOptSelfTest, fgOptLogTestcase};
    }
}

