/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.framework;

import com.sap.tc.jtools.jver.core.IJverTestAttributesInternal;
import com.sap.tc.jtools.jver.core.IPerformanceTest;
import com.sap.tc.jtools.jver.core.JverTestParameters;
import com.sap.tc.jtools.jver.framework.PerformanceTest;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class TestAttributesFix
extends JverTestParameters
implements IJverTestAttributesInternal {
    protected final String theTitleID = "title";
    protected String defaultTitle = "title not set";
    protected String theResource = null;
    protected String theVersion;
    protected boolean fixtureForMethod = true;
    protected boolean instantiationForMethod = true;
    protected String[] testSet = null;
    protected PerformanceTest[] performanceTestSet = null;

    public String getTitle(Locale language, ClassLoader loader) {
        String title = this.defaultTitle;
        if (this.theResource != null) {
            try {
                title = ResourceBundle.getBundle(this.theResource, language, loader).getString("title");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return title;
    }

    public String getVersion() {
        return this.theVersion;
    }

    public boolean isInstantiationPerTestMethod() {
        boolean isInstantiationPerTestMethod = this.isFixtureForMethod() && this.isInstantiationForMethod();
        return isInstantiationPerTestMethod;
    }

    public boolean isFixturePerTestMethod() {
        boolean isFixturePerTestMethod = this.isFixtureForMethod() && !this.isInstantiationForMethod();
        return isFixturePerTestMethod;
    }

    public boolean isFixturePerTestSet() {
        boolean isFixturePerTestSet = !this.isFixtureForMethod();
        return isFixturePerTestSet;
    }

    public String[] getTestSet() {
        return this.testSet;
    }

    public boolean hasTestSet() {
        return this.testSet != null && this.testSet.length > 0;
    }

    public boolean hasPerformanceTestSet() {
        return this.performanceTestSet != null && this.performanceTestSet.length > 0;
    }

    public IPerformanceTest[] getPerformanceTestSet() {
        return this.performanceTestSet;
    }

    public JverTestParameters getTestParameters() {
        return this;
    }

    public void setTestSet(PerformanceTest[] performanceTestSet) {
        this.performanceTestSet = performanceTestSet;
        this.testSet = new String[performanceTestSet.length];
        int ii = 0;
        while (ii < performanceTestSet.length) {
            this.testSet[ii] = performanceTestSet[ii].getMethodName();
            ++ii;
        }
    }

    public void setTestSet(String[] methodList) {
        this.testSet = methodList;
    }

    private boolean isFixtureForMethod() {
        return this.fixtureForMethod;
    }

    private boolean isInstantiationForMethod() {
        return this.instantiationForMethod;
    }
}

