/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver.performance;

import com.sap.tc.jtools.jver.core.AJverRuntimeException;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverLogPerf;
import com.sap.tc.jtools.jver.driver.IJverFixture;
import com.sap.tc.jtools.jver.driver.performance.APerfTestRun;
import com.sap.tc.jtools.jver.driver.performance.PerfConfig;
import com.sap.tc.jtools.jver.driver.performance.PerfResultMT;
import com.sap.tc.jtools.jver.driver.performance.PerfTestDescription;
import com.sap.tc.jtools.jver.framework.Test;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PerfTestRunST
extends APerfTestRun {
    public PerfTestRunST(IMsgCollector msgCollector, PerfConfig config) {
        super(msgCollector, config);
    }

    protected APerfTestRun.IPerfResult execTestMethod(PerfTestDescription testDescription, Test testObject) throws InstantiationException, IllegalAccessException, InvocationTargetException, Exception {
        IJverFixture testFixture = testDescription.getFixture();
        Class testClass = testDescription.getTestClass();
        Method testMethod = testDescription.getMethod();
        long repetitions = testDescription.getRepetitions();
        long testStart = System.currentTimeMillis();
        long jj = repetitions;
        while (jj > 0L) {
            Object var15_9;
            try {
                try {
                    testObject = testFixture.beginTestMethod(testClass, testObject);
                    testMethod.invoke((Object)testObject, (Object[])new Class[0]);
                }
                catch (InvocationTargetException e) {
                    Throwable te = e.getTargetException();
                    if (te instanceof AJverRuntimeException) {
                        ((AJverRuntimeException)te).setLevel(3);
                    }
                    throw e;
                }
                var15_9 = null;
            }
            catch (Throwable throwable) {
                var15_9 = null;
                testFixture.finishTestMethod(testObject);
                throw throwable;
            }
            testFixture.finishTestMethod(testObject);
            --jj;
        }
        final long durationMilliSecs = System.currentTimeMillis() - testStart;
        return new APerfTestRun.IPerfResult(){

            public PerfResultMT[] getResultArray() {
                return null;
            }

            public long getDurationMilliSecs() {
                return durationMilliSecs;
            }
        };
    }

    protected boolean evalResult(PerfTestDescription pTestMethod, APerfTestRun.IPerfResult pTestResult, APerfTestRun.IPerfResult pRefResult, long pGcTestMillis, long pGcRefMillis) {
        String logText;
        long millisTest = pTestResult.getDurationMilliSecs();
        long millisBurden = pRefResult.getDurationMilliSecs();
        millisBurden = Math.min(millisBurden, millisTest);
        long repetitions = pTestMethod.getRepetitions();
        long microsPerTestNet = -1L;
        long microsPerBurden = -1L;
        try {
            long microsTestNet = (millisTest - millisBurden) * 1000L;
            microsPerTestNet = microsTestNet / repetitions;
            long microsBurden = millisBurden * 1000L;
            microsPerBurden = microsBurden / repetitions;
        }
        catch (ArithmeticException e1) {
            microsPerTestNet = (millisTest - millisBurden) / repetitions * 1000L;
            microsPerBurden = millisBurden / repetitions * 1000L;
        }
        long microsPerTestMax = 1000L * pTestMethod.getMaxMillis();
        long microsTestGC = 1000L * pGcTestMillis;
        long microsBurdenGC = 1000L * pGcRefMillis;
        if (this.config_.isDoShowTimesGC()) {
            JverLogPerf.println("tgc:" + this.formatMicroSeconds(microsTestGC) + ",bgc:" + this.formatMicroSeconds(microsBurdenGC));
        }
        String fullNameBrackets = "[" + pTestMethod.getFullName() + "]";
        JverLogPerf.println(fullNameBrackets + ": executed (" + repetitions + ") times.");
        JverLogPerf.println("duration per single step(repetition):");
        JverLogPerf.println("burden:            \t " + this.formatMicroSeconds(microsPerBurden));
        JverLogPerf.println("invocation:        \t " + this.formatMicroSeconds(microsPerTestNet));
        boolean success = true;
        if (microsPerTestNet > microsPerTestMax) {
            logText = fullNameBrackets + " max.duration exceeded: " + microsPerTestNet + " > " + this.formatMicroSeconds(microsPerTestMax);
            JverLogPerf.println(logText);
            this.performanceWarning(logText, "perf.lim.exceed");
            success = false;
        }
        if (microsPerBurden * (long)this.config_.getRelTestBurden() > microsPerTestNet) {
            logText = fullNameBrackets + " duration disprop.: " + microsPerTestNet + " < " + this.config_.getRelTestBurdenAsString() + " * " + this.formatMicroSeconds(microsPerBurden) + " ( test - burden < burden * min_prop )";
            JverLogPerf.println(logText);
            this.performanceWarning(logText, "perf.burden.disprop");
            success = false;
        }
        return success;
    }

    protected IJverFixture getPerfTestFixture(IJverFixture fixture) {
        IJverFixture clone = fixture.getClone();
        clone.setMsgCollector(null);
        return clone;
    }
}

