/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver.performance;

final class PerfExecStateMT {
    private static final byte OK = 0;
    private static final byte TIMEOUT = 1;
    private static final byte ERROR = 2;
    public static final PerfExecStateMT STATE_ILLEGAL = new PerfExecStateMT(-111, "internal error", 2);
    public static final PerfExecStateMT STATE_INITIAL = new PerfExecStateMT(-99, "not started", 2);
    public static final PerfExecStateMT STATE_STARTED = new PerfExecStateMT(-88, "execution started, still running", 2);
    public static final PerfExecStateMT STATE_XPT_SWALLOWED = new PerfExecStateMT(-77, "max.duration exceeded, interrupt ignored", 1);
    public static final PerfExecStateMT STATE_INTERRUPTED = new PerfExecStateMT(-66, "max.duration exceeded, stopped by interrupt", 1);
    public static final PerfExecStateMT STATE_CANCELLED = new PerfExecStateMT(-55, "max.duration exceeded, stopped by soft cancel", 1);
    public static final PerfExecStateMT STATE_RUNTIME_ERROR = new PerfExecStateMT(-44, "runtime error in performance unit", 2);
    public static final PerfExecStateMT STATE_TESTCASE_FLOP = new PerfExecStateMT(-33, "flop during performance run", 2);
    public static final PerfExecStateMT STATE_TESTCASE_WARN = new PerfExecStateMT(-22, "warning during performance run", 2);
    public static final PerfExecStateMT STATE_TESTCASE_ERROR = new PerfExecStateMT(-11, "exception thrown during performance run", 2);
    public static final PerfExecStateMT STATE_SUCCESS = new PerfExecStateMT(-1, "performance run success", 0);
    private final int id_;
    private final String descr_;
    private final byte errno_;

    final int getId() {
        return this.id_;
    }

    String getDescription() {
        return this.toString();
    }

    public String toString() {
        return this.descr_;
    }

    boolean isTimeout() {
        return (this.errno_ & 1) != 0;
    }

    boolean isError() {
        return (this.errno_ & 2) != 0;
    }

    public boolean equals(PerfExecStateMT state) {
        return this.getId() == state.getId();
    }

    public boolean isSuccessfull() {
        return this.equals(STATE_SUCCESS);
    }

    private PerfExecStateMT(int id, String descr, byte errno) {
        this.descr_ = descr;
        this.id_ = id;
        this.errno_ = errno;
    }
}

