/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver;

import com.sap.tc.jtools.jver.core.IJverTestAttributesInternal;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.IPerformanceTest;
import com.sap.tc.jtools.jver.core.JverConfig;
import com.sap.tc.jtools.jver.core.JverLogPerf;
import com.sap.tc.jtools.jver.driver.AJverMethodRunner;
import com.sap.tc.jtools.jver.driver.IJverDriverMsg;
import com.sap.tc.jtools.jver.driver.IJverDriverState;
import com.sap.tc.jtools.jver.driver.IJverFixture;
import com.sap.tc.jtools.jver.driver.performance.APerfTestRun;
import com.sap.tc.jtools.jver.driver.performance.PerfConfig;
import com.sap.tc.jtools.jver.driver.performance.PerfTestDescription;
import com.sap.tc.jtools.jver.driver.performance.PerfTestRunMT;
import com.sap.tc.jtools.jver.driver.performance.PerfTestRunST;
import com.sap.tc.jtools.jver.framework.Test;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

class JverMethodRunnerPerformance
extends AJverMethodRunner {
    private final boolean bSkipFunctionalTest_;
    private final IJverDriverState fDriverState;
    private PerfConfig perfConfig_;
    private PerfTestDescription[] methodArray = null;

    public JverMethodRunnerPerformance(IMsgCollector collector, JverConfig jverConfig, IJverDriverState pDriverState) {
        super(collector);
        PerfConfig perfConfig = new PerfConfig();
        perfConfig.init(jverConfig);
        this.bSkipFunctionalTest_ = perfConfig.isSkipFunctional();
        this.perfConfig_ = perfConfig;
        this.fDriverState = pDriverState;
    }

    public void init(Class testClass, IJverTestAttributesInternal attributes) {
        super.init(testClass, attributes);
        this.methodArray = this.getMethods();
    }

    public Enumeration getTestMethods() {
        return new Enumeration(){
            private int index_ = 0;

            public boolean hasMoreElements() {
                ++this.index_;
                return this.index_ < JverMethodRunnerPerformance.this.methodArray.length;
            }

            public Object nextElement() {
                return JverMethodRunnerPerformance.this.methodArray[this.index_];
            }
        };
    }

    public int getTestMethodCount() {
        return this.methodArray.length;
    }

    protected void runTestMethods() throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, Exception {
        Test testObject = null;
        if (null == this.methodArray || 0 >= this.methodArray.length) {
            return;
        }
        IJverFixture fixture = this.getTestFixture();
        this.printTestHeader(this.getTestClass().getName(), fixture.getFixtureDescription());
        try {
            testObject = fixture.beginTestSet(this.getTestClass());
        }
        catch (Exception prepEx) {
            JverLogPerf.println("Cannot prepare " + prepEx.toString());
            throw prepEx;
        }
        try {
            Method refMethod = this.getReferenceMethod(this.getTestClass());
            int ii = 0;
            while (ii < this.methodArray.length) {
                if (this.fDriverState.isAbortionRequested()) {
                    return;
                }
                APerfTestRun testRun = this.methodArray[ii].getNumThreads() > 1 ? new PerfTestRunMT(this.msgCollector_, this.perfConfig_) : new PerfTestRunST(this.msgCollector_, this.perfConfig_);
                testRun.runPerfTest(testObject, refMethod, this.methodArray[ii]);
                ++ii;
            }
        }
        catch (Exception e) {
            try {
                fixture.finishTestSet(testObject);
            }
            catch (Exception e2) {
                JverLogPerf.println("Cannot clean up: " + e2.toString());
            }
            throw e;
        }
        fixture.finishTestSet(testObject);
    }

    private Method getReferenceMethod(Class pTestClass) {
        Method refMethod;
        String refMethodName = "nopPerformanceReference";
        try {
            refMethod = pTestClass.getMethod("nopPerformanceReference", AJverMethodRunner.noArg_);
        }
        catch (NoSuchMethodException e) {
            IJverDriverMsg.NO_REFERENCE_METHOD.add(this.msgCollector_, "nopPerformanceReference");
            return null;
        }
        return refMethod;
    }

    private PerfTestDescription[] getMethods() {
        IJverTestAttributesInternal curAttribs = this.getTestAttributes();
        IPerformanceTest[] perfTests = curAttribs.getPerformanceTestSet();
        Vector<PerfTestDescription> methodVector = new Vector<PerfTestDescription>(perfTests.length);
        int numMethods = 0;
        int numTests = perfTests.length;
        int ii = 0;
        while (ii < numTests) {
            IPerformanceTest curPerf = perfTests[ii];
            String curName = curPerf.getMethodName();
            if (0 < curPerf.getRepetitions()) {
                boolean isFixturePerMethod = curAttribs.isFixturePerTestMethod();
                if (isFixturePerMethod && 1 < curPerf.getNumThreads()) {
                    IJverDriverMsg.NO_MT_FIXPERMETHOD.add(this.msgCollector_, curName);
                } else {
                    try {
                        Method curMeth = this.getTestClass().getMethod(curName, AJverMethodRunner.noArg_);
                        methodVector.add(new PerfTestDescription(this.getTestClass(), curMeth, this.getTestFixture(), curPerf.getRepetitions(), curPerf.getLimitMillis(), curPerf.getNumThreads()));
                        ++numMethods;
                    }
                    catch (NoSuchMethodException exp1) {
                        IJverDriverMsg.NO_SUCH_METHOD.add(this.msgCollector_, curName);
                    }
                }
            }
            ++ii;
        }
        if (0 < numMethods) {
            PerfTestDescription[] methodArray = new PerfTestDescription[numMethods];
            int jj = 0;
            while (jj < numMethods) {
                methodArray[jj] = (PerfTestDescription)methodVector.get(jj);
                ++jj;
            }
            return methodArray;
        }
        return null;
    }

    private void printTestHeader(String className, String variant) {
        JverLogPerf.printHeader(className, '-');
        JverLogPerf.println(variant);
        try {
            IJverTestAttributesInternal attributes = this.getTestAttributes();
            JverLogPerf.printHeader("parameter", '-');
            String[] parameters = attributes.getParameters();
            int ii = 0;
            while (ii < parameters.length) {
                JverLogPerf.println(parameters[ii]);
                ++ii;
            }
            JverLogPerf.printHeader("---", '-');
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean getSkipFunctional() {
        return this.bSkipFunctionalTest_;
    }
}

