/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.core;

import com.sap.tc.jtools.jver.core.IJverPrinter;
import java.io.PrintStream;
import java.io.PrintWriter;

public class JverPrinter
implements IJverPrinter {
    private IJverPrinter printer = null;
    private boolean isStandardOutputStream = false;

    public JverPrinter(PrintStream stream) {
        this.printer = new JverPrintStream(stream);
        this.isStandardOutputStream = stream.equals(System.err) || stream.equals(System.out);
    }

    public JverPrinter(PrintWriter writer) {
        this.printer = new JverPrintWriter(writer);
    }

    public void print(String s) {
        this.printer.print(s);
    }

    public void print(Object s) {
        this.printer.print(s);
    }

    public void print(char c) {
        this.printer.print(c);
    }

    public void println(String s) {
        this.printer.println(s);
    }

    public void println(Object s) {
        this.printer.println(s);
    }

    public void flush() {
        this.printer.flush();
    }

    public void close() {
        if (!this.isStandardOutputStream) {
            this.printer.close();
        }
    }

    public void printStackTrace(Throwable e) {
        this.printer.printStackTrace(e);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private class JverPrintWriter
    extends PrintWriter
    implements IJverPrinter {
        JverPrintWriter(PrintWriter writer) {
            super(writer);
        }

        public void printStackTrace(Throwable e) {
            e.printStackTrace(this);
        }
    }

    private class JverPrintStream
    extends PrintStream
    implements IJverPrinter {
        JverPrintStream(PrintStream stream) {
            super(stream);
        }

        public void printStackTrace(Throwable e) {
            e.printStackTrace(this);
        }
    }
}

