/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.core;

import com.sap.tc.jtools.jver.core.DbgLog;
import com.sap.tc.jtools.jver.core.IJverMsgFmt;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;

public class JverMsgStack {
    private Object[] stack_ = null;
    private static String[] jverFilter_ = new String[]{"com.sap.tc.jtools.jver.", "sun.reflect.", "java.lang.reflect.Method.invoke(", "com.sap.ide.jbuilder.opentools.wizard.jver."};

    public JverMsgStack(Throwable throwable) {
        this.createMsgStack(throwable);
    }

    public JverMsgStack(String[] filter, JverMsgStack stack) {
        this.createMsgStack(filter, stack);
    }

    public String getLine(int index) {
        return this.stack_[index].toString().trim();
    }

    private void setStack(Vector stack) {
        this.stack_ = stack.size() > 0 ? stack.toArray() : null;
    }

    public int getLength() {
        if (this.stack_ == null) {
            return 0;
        }
        return this.stack_.length;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int numLines = this.getLength();
        int ii = 0;
        while (ii < numLines) {
            buffer.append(IJverMsgFmt.FMT_NEWLINE);
            buffer.append(' ');
            buffer.append(this.getLine(ii));
            ++ii;
        }
        return buffer.toString();
    }

    /*
     * Loose catch block
     */
    private void createMsgStack(Throwable throwable) {
        Vector<String> stack;
        block12: {
            if (this.stack_ != null) {
                return;
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            String trace = stringBuffer.toString();
            StringReader stringReader = new StringReader(trace);
            BufferedReader reader = new BufferedReader(stringReader);
            String line = null;
            stack = new Vector<String>();
            DbgLog.println("save filtered:");
            DbgLog.printStackTrace(throwable);
            line = reader.readLine();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("\tat ")) break;
            }
            while (line != null) {
                if (!this.isStackInJverFramework(line)) {
                    stack.add(line);
                }
                line = reader.readLine();
            }
            Object var12_10 = null;
            printWriter.close();
            try {
                reader.close();
            }
            catch (IOException e) {}
            break block12;
            {
                catch (IOException ioe) {
                    Object var12_11 = null;
                    printWriter.close();
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
            catch (Throwable throwable2) {
                Object var12_12 = null;
                printWriter.close();
                try {
                    reader.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable2;
            }
        }
        this.setStack(stack);
    }

    private void createMsgStack(String[] filter, JverMsgStack origStack) {
        if (filter == null || origStack == null) {
            return;
        }
        String line = null;
        Vector<String> stack = new Vector<String>();
        int lengthOrigStack = origStack.getLength();
        int ii = 0;
        while (ii < lengthOrigStack) {
            line = origStack.getLine(ii);
            if (!this.isContainedInAdditionalFilter(filter, line)) {
                stack.add(line);
            }
            ++ii;
        }
        this.setStack(stack);
    }

    private boolean isStackInJverFramework(String line) {
        boolean isInJverFW = false;
        int ii = 0;
        while (ii < jverFilter_.length) {
            if (line.indexOf(jverFilter_[ii]) > 0) {
                isInJverFW = true;
                break;
            }
            ++ii;
        }
        return isInJverFW;
    }

    private boolean isContainedInAdditionalFilter(String[] filter, String line) {
        boolean isInFilter = false;
        int ii = 0;
        while (ii < filter.length) {
            if (line.indexOf(filter[ii]) > 0) {
                isInFilter = true;
                break;
            }
            ++ii;
        }
        return isInFilter;
    }
}

