/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.core;

import java.io.ObjectStreamException;

public class JverExceptionType {
    private static final int WARNING_ID = 1;
    private static final int FLOP_ID = 2;
    private static final int PERFORMANCE_ID = 3;
    private static final int RUNTIME_ID = 4;
    public static final JverExceptionType WARNING = new JverExceptionType("warning", 1);
    public static final JverExceptionType FLOP = new JverExceptionType("flop", 2);
    public static final JverExceptionType PERFORMANCE = new JverExceptionType("performance", 3);
    public static final JverExceptionType RUNTIME = new JverExceptionType("runtime", 4);
    public static final String FMT_TYPE = "choice, 1#W| 2#F| 3#P| 4#E";
    public static final String FMT_TYPE_VERBOSE = "choice, 1#Warning| 2#Flop| 3#Performance| 4#Error";
    private final int id_;
    private final String name_;

    public boolean equals(JverExceptionType type) {
        return this.getId() == type.getId();
    }

    public String toString() {
        return this.name_;
    }

    public int getId() {
        return this.id_;
    }

    private Object readResolve() throws ObjectStreamException {
        switch (this.getId()) {
            case 1: {
                return WARNING;
            }
            case 2: {
                return FLOP;
            }
            case 3: {
                return PERFORMANCE;
            }
            case 4: {
                return RUNTIME;
            }
        }
        return null;
    }

    private JverExceptionType(String name, int id) {
        this.name_ = name;
        this.id_ = id;
    }
}

