/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.core;

import com.sap.tc.jtools.jver.core.AJverLog;
import com.sap.tc.jtools.jver.core.IJverPrinter;
import java.io.IOException;

public class DbgLog
extends AJverLog {
    private static int countNested = 0;
    private static DbgLog log = null;

    private DbgLog(String fileName, boolean append) throws IOException {
        super(fileName, append);
    }

    public static String init(String fileName, boolean append) throws IOException {
        if (log == null) {
            log = new DbgLog(fileName, append);
            if (!append) {
                DbgLog.println("-------- Log file: " + fileName);
            }
        }
        ++countNested;
        return log.getLogFileName();
    }

    public static void finish() {
        if (countNested > 0 && --countNested == 0) {
            DbgLog.println("-------- Log file end --------");
            log.finish_();
            log = null;
        }
    }

    public static void print(String msg) {
        if (log != null) {
            log.print_(msg);
        }
    }

    public static void println(String msg) {
        if (log != null) {
            log.println_(msg);
        }
    }

    public static void printStackTrace(Throwable t) {
        if (log != null) {
            log.printStackTrace_(t);
        }
    }

    public static IJverPrinter getPrintWriter() {
        if (log != null) {
            return log.getPrintWriter_();
        }
        return null;
    }
}

