/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.InetAddress;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.http.HttpConnector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.logger.FileLogger;
import org.apache.catalina.logger.SystemOutLogger;
import org.apache.catalina.net.SSLServerSocketFactory;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public class Embedded
implements Lifecycle {
    protected Connector[] connectors = new Connector[0];
    protected int debug = 0;
    protected boolean useNaming = true;
    protected Engine[] engines = new Engine[0];
    protected static final String info = "org.apache.catalina.startup.Embedded/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected Logger logger = null;
    protected Realm realm = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected String socketFactory = "org.apache.catalina.net.SSLSocketFactory";
    protected boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public Embedded() {
        this(null, null);
    }

    public Embedded(Logger logger, Realm realm) {
        this.setLogger(logger);
        this.setRealm(realm);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        int oldDebug = this.debug;
        this.debug = debug;
        this.support.firePropertyChange("debug", new Integer(oldDebug), new Integer(this.debug));
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean useNaming) {
        boolean oldUseNaming = this.useNaming;
        this.useNaming = useNaming;
        this.support.firePropertyChange("useNaming", new Boolean(oldUseNaming), new Boolean(this.useNaming));
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        Logger oldLogger = this.logger;
        this.logger = logger;
        this.support.firePropertyChange("logger", oldLogger, this.logger);
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setRealm(Realm realm) {
        Realm oldRealm = this.realm;
        this.realm = realm;
        this.support.firePropertyChange("realm", oldRealm, this.realm);
    }

    public String getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(String socketFactory) {
        this.socketFactory = socketFactory;
    }

    public synchronized void addConnector(Connector connector) {
        block8: {
            if (this.debug >= 1) {
                if (connector instanceof HttpConnector) {
                    HttpConnector hc = (HttpConnector)connector;
                    this.logger.log("Adding connector for address '" + (hc.getAddress() == null ? "ALL" : hc.getAddress()) + "' port='" + hc.getPort() + "'");
                } else {
                    this.logger.log("Adding connector (" + connector.getInfo() + ")");
                }
            }
            if (this.engines.length < 1) {
                throw new IllegalStateException(sm.getString("embedded.noEngines"));
            }
            connector.setContainer(this.engines[this.engines.length - 1]);
            Connector[] results = new Connector[this.connectors.length + 1];
            int i = 0;
            while (i < this.connectors.length) {
                results[i] = this.connectors[i];
                ++i;
            }
            results[this.connectors.length] = connector;
            this.connectors = results;
            if (!this.started) break block8;
            try {
                connector.initialize();
                if (connector instanceof Lifecycle) {
                    ((Lifecycle)((Object)connector)).start();
                }
            }
            catch (LifecycleException e) {
                this.logger.log("Connector.start", e);
            }
        }
    }

    public synchronized void addEngine(Engine engine) {
        block4: {
            if (this.debug >= 1) {
                this.logger.log("Adding engine (" + engine.getInfo() + ")");
            }
            Engine[] results = new Engine[this.engines.length + 1];
            int i = 0;
            while (i < this.engines.length) {
                results[i] = this.engines[i];
                ++i;
            }
            results[this.engines.length] = engine;
            this.engines = results;
            if (!this.started || !(engine instanceof Lifecycle)) break block4;
            try {
                ((Lifecycle)((Object)engine)).start();
            }
            catch (LifecycleException e) {
                this.logger.log("Engine.start", e);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public Connector createConnector(InetAddress address, int port, boolean secure) {
        if (this.debug >= 1) {
            this.logger.log("Creating connector for address='" + (address == null ? "ALL" : address.getHostAddress()) + "' port='" + port + "' secure='" + secure + "'");
        }
        HttpConnector connector = new HttpConnector();
        if (address != null) {
            connector.setAddress(address.getHostAddress());
        }
        connector.setDebug(this.debug);
        connector.setPort(port);
        if (secure) {
            connector.setScheme("https");
            connector.setSecure(true);
            connector.setFactory(new SSLServerSocketFactory());
        }
        return connector;
    }

    public Context createContext(String path, String docBase) {
        if (this.debug >= 1) {
            this.logger.log("Creating context '" + path + "' with docBase '" + docBase + "'");
        }
        StandardContext context = new StandardContext();
        context.setDebug(this.debug);
        context.setDocBase(docBase);
        context.setPath(path);
        ContextConfig config = new ContextConfig();
        config.setDebug(this.debug);
        context.addLifecycleListener(config);
        return context;
    }

    public Engine createEngine() {
        if (this.debug >= 1) {
            this.logger.log("Creating engine");
        }
        StandardEngine engine = new StandardEngine();
        engine.setDebug(this.debug);
        engine.setLogger(this.logger);
        engine.setRealm(this.realm);
        return engine;
    }

    public Host createHost(String name, String appBase) {
        if (this.debug >= 1) {
            this.logger.log("Creating host '" + name + "' with appBase '" + appBase + "'");
        }
        StandardHost host = new StandardHost();
        host.setAppBase(appBase);
        host.setDebug(this.debug);
        host.setName(name);
        return host;
    }

    public Loader createLoader(ClassLoader parent) {
        if (this.debug >= 1) {
            this.logger.log("Creating Loader with parent class loader '" + parent + "'");
        }
        WebappLoader loader = new WebappLoader(parent);
        return loader;
    }

    public String getInfo() {
        return info;
    }

    public synchronized void removeConnector(Connector connector) {
        if (this.debug >= 1) {
            if (connector instanceof HttpConnector) {
                HttpConnector hc = (HttpConnector)connector;
                this.logger.log("Removing connector for address '" + (hc.getAddress() == null ? "ALL" : hc.getAddress()) + "' port='" + hc.getPort() + "'");
            } else {
                this.logger.log("Removing connector (" + connector.getInfo() + ")");
            }
        }
        int j = -1;
        int i = 0;
        while (i < this.connectors.length) {
            if (connector == this.connectors[i]) {
                j = i;
                break;
            }
            ++i;
        }
        if (j < 0) {
            return;
        }
        if (connector instanceof Lifecycle) {
            if (this.debug >= 1) {
                this.logger.log(" Stopping this Connector");
            }
            try {
                ((Lifecycle)((Object)connector)).stop();
            }
            catch (LifecycleException e) {
                this.logger.log("Connector.stop", e);
            }
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing this Connector");
        }
        int k = 0;
        Connector[] results = new Connector[this.connectors.length - 1];
        int i2 = 0;
        while (i2 < this.connectors.length) {
            if (i2 != j) {
                results[k++] = this.connectors[i2];
            }
            ++i2;
        }
        this.connectors = results;
    }

    public synchronized void removeContext(Context context) {
        if (this.debug >= 1) {
            this.logger.log("Removing context[" + context.getPath() + "]");
        }
        boolean found = false;
        int i = 0;
        while (i < this.engines.length) {
            Container[] hosts = this.engines[i].findChildren();
            int j = 0;
            while (j < hosts.length) {
                Container[] contexts = hosts[j].findChildren();
                int k = 0;
                while (k < contexts.length) {
                    if (context == (Context)contexts[k]) {
                        found = true;
                        break;
                    }
                    ++k;
                }
                if (found) break;
                ++j;
            }
            if (found) break;
            ++i;
        }
        if (!found) {
            return;
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing this Context");
        }
        context.getParent().removeChild(context);
    }

    public synchronized void removeEngine(Engine engine) {
        if (this.debug >= 1) {
            this.logger.log("Removing engine (" + engine.getInfo() + ")");
        }
        int j = -1;
        int i = 0;
        while (i < this.engines.length) {
            if (engine == this.engines[i]) {
                j = i;
                break;
            }
            ++i;
        }
        if (j < 0) {
            return;
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing related Containers");
        }
        while (true) {
            int n = -1;
            int i2 = 0;
            while (i2 < this.connectors.length) {
                if (this.connectors[i2].getContainer() == engine) {
                    n = i2;
                    break;
                }
                ++i2;
            }
            if (n < 0) break;
            this.removeConnector(this.connectors[n]);
        }
        if (engine instanceof Lifecycle) {
            if (this.debug >= 1) {
                this.logger.log(" Stopping this Engine");
            }
            try {
                ((Lifecycle)((Object)engine)).stop();
            }
            catch (LifecycleException e) {
                this.logger.log("Engine.stop", e);
            }
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing this Engine");
        }
        int k = 0;
        Engine[] results = new Engine[this.engines.length - 1];
        int i3 = 0;
        while (i3 < this.engines.length) {
            if (i3 != j) {
                results[k++] = this.engines[i3];
            }
            ++i3;
        }
        this.engines = results;
    }

    public synchronized void removeHost(Host host) {
        if (this.debug >= 1) {
            this.logger.log("Removing host[" + host.getName() + "]");
        }
        boolean found = false;
        int i = 0;
        while (i < this.engines.length) {
            Container[] hosts = this.engines[i].findChildren();
            int j = 0;
            while (j < hosts.length) {
                if (host == (Host)hosts[j]) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (found) break;
            ++i;
        }
        if (!found) {
            return;
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing this Host");
        }
        host.getParent().removeChild(host);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.debug >= 1) {
            this.logger.log("Starting embedded server");
        }
        if (System.getProperty("catalina.home") == null) {
            String j2eeHome = System.getProperty("com.sun.enterprise.home");
            if (j2eeHome != null) {
                System.setProperty("catalina.home", System.getProperty("com.sun.enterprise.home"));
            } else {
                throw new LifecycleException("Must set 'catalina.home' system property");
            }
        }
        if (System.getProperty("catalina.base") == null) {
            System.setProperty("catalina.base", System.getProperty("catalina.home"));
        }
        if (this.started) {
            throw new LifecycleException(sm.getString("embedded.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (!this.useNaming) {
            System.setProperty("catalina.useNaming", "false");
        } else {
            System.setProperty("catalina.useNaming", "true");
            String value = "org.apache.naming";
            String oldValue = System.getProperty("java.naming.factory.url.pkgs");
            if (oldValue != null) {
                value = oldValue + ":" + value;
            }
            System.setProperty("java.naming.factory.url.pkgs", value);
            System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        }
        int i = 0;
        while (i < this.engines.length) {
            if (this.engines[i] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.engines[i])).start();
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.connectors.length) {
            this.connectors[i2].initialize();
            if (this.connectors[i2] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.connectors[i2])).start();
            }
            ++i2;
        }
    }

    public void stop() throws LifecycleException {
        if (this.debug >= 1) {
            this.logger.log("Stopping embedded server");
        }
        if (!this.started) {
            throw new LifecycleException(sm.getString("embedded.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        int i = 0;
        while (i < this.connectors.length) {
            if (this.connectors[i] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.connectors[i])).stop();
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.engines.length) {
            if (this.engines[i2] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.engines[i2])).stop();
            }
            ++i2;
        }
    }

    public static void main(String[] args) {
        String base;
        Embedded embedded = new Embedded(new SystemOutLogger(), new MemoryRealm());
        embedded.setDebug(5);
        embedded.setLogger(new SystemOutLogger());
        String home = System.getProperty("catalina.home");
        if (home == null) {
            System.err.println("You must set the 'catalina.home' system property");
            System.exit(1);
        }
        if ((base = System.getProperty("catalina.base")) == null) {
            base = home;
            System.setProperty("catalina.base", base);
        }
        try {
            embedded.start();
        }
        catch (LifecycleException e) {
            System.err.println("start: " + e.toString());
            e.printStackTrace();
        }
        Engine engine = embedded.createEngine();
        engine.setDefaultHost("localhost");
        Host host = embedded.createHost("localhost", home + "/webapps");
        engine.addChild(host);
        Context root = embedded.createContext("", home + "/webapps/ROOT");
        host.addChild(root);
        Context examples = embedded.createContext("/examples", home + "/webapps/examples");
        Embedded.customize(examples);
        host.addChild(examples);
        embedded.addEngine(engine);
        Connector connector = embedded.createConnector(null, 8080, false);
        embedded.addConnector(connector);
        try {
            Thread.sleep(120000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        embedded.removeContext(examples);
        embedded.removeEngine(engine);
        try {
            embedded.stop();
        }
        catch (LifecycleException e) {
            System.err.println("stop: " + e.toString());
            e.printStackTrace();
        }
    }

    private static void customize(Context context) {
        String basename = context.getPath();
        basename = basename.length() < 1 ? "ROOT" : basename.substring(1);
        FileLogger special = new FileLogger();
        special.setPrefix(basename + "_log.");
        special.setSuffix(".txt");
        special.setTimestamp(true);
        context.setLogger(special);
    }
}

