/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.directory.DirContext;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContextValve;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.ResourceParams;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.util.CharsetMapper;
import org.apache.catalina.util.RequestUtil;
import org.apache.naming.ContextAccessController;
import org.apache.naming.ContextBindings;
import org.apache.naming.EjbRef;
import org.apache.naming.NamingContext;
import org.apache.naming.ResourceEnvRef;
import org.apache.naming.ResourceRef;
import org.apache.naming.TransactionRef;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.WARDirContext;

public class StandardContext
extends ContainerBase
implements Context {
    private String[] applicationListeners = new String[0];
    private Object[] applicationListenersObjects = new Object[0];
    private ApplicationParameter[] applicationParameters = new ApplicationParameter[0];
    private boolean available = false;
    private CharsetMapper charsetMapper = null;
    private String charsetMapperClass = "org.apache.catalina.util.CharsetMapper";
    private boolean configured = false;
    private SecurityConstraint[] constraints = new SecurityConstraint[0];
    private ApplicationContext context = null;
    private boolean cookies = true;
    private boolean crossContext = false;
    private String displayName = null;
    private boolean distributable = false;
    private String docBase = null;
    private HashMap ejbs = new HashMap();
    private HashMap envs = new HashMap();
    private HashMap exceptionPages = new HashMap();
    private HashMap filterConfigs = new HashMap();
    private HashMap filterDefs = new HashMap();
    private FilterMap[] filterMaps = new FilterMap[0];
    private static final String info = "org.apache.catalina.core.StandardContext/1.0";
    private String[] instanceListeners = new String[0];
    private HashMap localEjbs = new HashMap();
    private LoginConfig loginConfig = null;
    private String mapperClass = "org.apache.catalina.core.StandardContextMapper";
    private HashMap mimeMappings = new HashMap();
    private HashMap parameters = new HashMap();
    private boolean paused = false;
    private String publicId = null;
    private boolean reloadable = false;
    private boolean override = false;
    private boolean privileged = false;
    private boolean replaceWelcomeFiles = false;
    private HashMap resourceEnvRefs = new HashMap();
    private HashMap resources = new HashMap();
    private HashMap resourceParams = new HashMap();
    private HashMap roleMappings = new HashMap();
    private String[] securityRoles = new String[0];
    private HashMap servletMappings = new HashMap();
    private int sessionTimeout = 30;
    private HashMap statusPages = new HashMap();
    private HashMap taglibs = new HashMap();
    private String[] welcomeFiles = new String[0];
    private String[] wrapperLifecycles = new String[0];
    private String[] wrapperListeners = new String[0];
    private String workDir = null;
    private String wrapperClass = "org.apache.catalina.core.StandardWrapper";
    private boolean useNaming = true;
    private boolean filesystemBased = false;
    private String namingContextName = null;
    protected boolean cachingAllowed = true;

    public StandardContext() {
        this.pipeline.setBasic(new StandardContextValve());
    }

    public boolean isCachingAllowed() {
        return this.cachingAllowed;
    }

    public void setCachingAllowed(boolean cachingAllowed) {
        this.cachingAllowed = cachingAllowed;
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean useNaming) {
        this.useNaming = useNaming;
    }

    public boolean isFilesystemBased() {
        return this.filesystemBased;
    }

    public Object[] getApplicationListeners() {
        return this.applicationListenersObjects;
    }

    public void setApplicationListeners(Object[] listeners) {
        this.applicationListenersObjects = listeners;
    }

    public boolean getAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        boolean oldAvailable = this.available;
        this.available = available;
        this.support.firePropertyChange("available", new Boolean(oldAvailable), new Boolean(this.available));
    }

    public CharsetMapper getCharsetMapper() {
        block2: {
            if (this.charsetMapper != null) break block2;
            try {
                Class<?> clazz = Class.forName(this.charsetMapperClass);
                this.charsetMapper = (CharsetMapper)clazz.newInstance();
            }
            catch (Throwable t) {
                this.charsetMapper = new CharsetMapper();
            }
        }
        return this.charsetMapper;
    }

    public void setCharsetMapper(CharsetMapper mapper) {
        CharsetMapper oldCharsetMapper = this.charsetMapper;
        this.charsetMapper = mapper;
        this.support.firePropertyChange("charsetMapper", oldCharsetMapper, this.charsetMapper);
    }

    public boolean getConfigured() {
        return this.configured;
    }

    public void setConfigured(boolean configured) {
        boolean oldConfigured = this.configured;
        this.configured = configured;
        this.support.firePropertyChange("configured", new Boolean(oldConfigured), new Boolean(this.configured));
    }

    public boolean getCookies() {
        return this.cookies;
    }

    public void setCookies(boolean cookies) {
        boolean oldCookies = this.cookies;
        this.cookies = cookies;
        this.support.firePropertyChange("cookies", new Boolean(oldCookies), new Boolean(this.cookies));
    }

    public boolean getCrossContext() {
        return this.crossContext;
    }

    public void setCrossContext(boolean crossContext) {
        boolean oldCrossContext = this.crossContext;
        this.crossContext = crossContext;
        this.support.firePropertyChange("crossContext", new Boolean(oldCrossContext), new Boolean(this.crossContext));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        String oldDisplayName = this.displayName;
        this.displayName = displayName;
        this.support.firePropertyChange("displayName", oldDisplayName, this.displayName);
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = distributable;
        this.support.firePropertyChange("distributable", new Boolean(oldDistributable), new Boolean(this.distributable));
    }

    public String getDocBase() {
        return this.docBase;
    }

    public void setDocBase(String docBase) {
        this.docBase = docBase;
    }

    public String getInfo() {
        return info;
    }

    public synchronized void setLoader(Loader loader) {
        super.setLoader(loader);
    }

    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    public void setLoginConfig(LoginConfig config) {
        String errorPage;
        if (config == null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardContext.loginConfig.required"));
        }
        String loginPage = config.getLoginPage();
        if (loginPage != null && !loginPage.startsWith("/")) {
            if (this.isServlet22()) {
                this.log(ContainerBase.sm.getString("standardContext.loginConfig.loginWarning", loginPage));
                config.setLoginPage("/" + loginPage);
            } else {
                throw new IllegalArgumentException(ContainerBase.sm.getString("standardContext.loginConfig.loginPage", loginPage));
            }
        }
        if ((errorPage = config.getErrorPage()) != null && !errorPage.startsWith("/")) {
            if (this.isServlet22()) {
                this.log(ContainerBase.sm.getString("standardContext.loginConfig.errorWarning", errorPage));
                config.setErrorPage("/" + errorPage);
            } else {
                throw new IllegalArgumentException(ContainerBase.sm.getString("standardContext.loginConfig.errorPage", errorPage));
            }
        }
        LoginConfig oldLoginConfig = this.loginConfig;
        this.loginConfig = config;
        this.support.firePropertyChange("loginConfig", oldLoginConfig, this.loginConfig);
    }

    public String getPath() {
        return this.getName();
    }

    public void setPath(String path) {
        this.setName(RequestUtil.URLDecode(path));
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        if (this.debug >= 1) {
            this.log("Setting deployment descriptor public ID to '" + publicId + "'");
        }
        String oldPublicId = this.publicId;
        this.publicId = publicId;
        this.support.firePropertyChange("publicId", oldPublicId, publicId);
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public boolean getOverride() {
        return this.override;
    }

    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", new Boolean(oldReloadable), new Boolean(this.reloadable));
    }

    public void setOverride(boolean override) {
        boolean oldOverride = this.override;
        this.override = override;
        this.support.firePropertyChange("override", new Boolean(oldOverride), new Boolean(this.override));
    }

    public boolean getPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(boolean privileged) {
        boolean oldPrivileged = this.privileged;
        this.privileged = privileged;
        this.support.firePropertyChange("privileged", new Boolean(oldPrivileged), new Boolean(this.privileged));
    }

    public boolean isReplaceWelcomeFiles() {
        return this.replaceWelcomeFiles;
    }

    public void setReplaceWelcomeFiles(boolean replaceWelcomeFiles) {
        boolean oldReplaceWelcomeFiles = this.replaceWelcomeFiles;
        this.replaceWelcomeFiles = replaceWelcomeFiles;
        this.support.firePropertyChange("replaceWelcomeFiles", new Boolean(oldReplaceWelcomeFiles), new Boolean(this.replaceWelcomeFiles));
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ApplicationContext(this.getBasePath(), this);
        }
        return this.context;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int timeout) {
        int oldSessionTimeout = this.sessionTimeout;
        this.sessionTimeout = timeout;
        this.support.firePropertyChange("sessionTimeout", new Integer(oldSessionTimeout), new Integer(this.sessionTimeout));
    }

    public String getWrapperClass() {
        return this.wrapperClass;
    }

    public void setWrapperClass(String wrapperClass) {
        this.wrapperClass = wrapperClass;
    }

    public synchronized void setResources(DirContext resources) {
        if (resources instanceof BaseDirContext) {
            ((BaseDirContext)resources).setDocBase(this.getBasePath());
            ((BaseDirContext)resources).setCached(this.isCachingAllowed());
        }
        if (resources instanceof FileDirContext) {
            this.filesystemBased = true;
        }
        super.setResources(resources);
        if (this.started) {
            this.postResources();
        }
    }

    public String getCharsetMapperClass() {
        return this.charsetMapperClass;
    }

    public void setCharsetMapperClass(String mapper) {
        String oldCharsetMapperClass = this.charsetMapperClass;
        this.charsetMapperClass = mapper;
        this.support.firePropertyChange("charsetMapperClass", oldCharsetMapperClass, this.charsetMapperClass);
    }

    public String getMapperClass() {
        return this.mapperClass;
    }

    public void setMapperClass(String mapperClass) {
        String oldMapperClass = this.mapperClass;
        this.mapperClass = mapperClass;
        this.support.firePropertyChange("mapperClass", oldMapperClass, this.mapperClass);
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
        if (this.started) {
            this.postWorkDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationListener(String listener) {
        String[] stringArray = this.applicationListeners;
        synchronized (this.applicationListeners) {
            String[] results = new String[this.applicationListeners.length + 1];
            int i = 0;
            while (i < this.applicationListeners.length) {
                if (listener.equals(this.applicationListeners[i])) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                results[i] = this.applicationListeners[i];
                ++i;
            }
            results[this.applicationListeners.length] = listener;
            this.applicationListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("addApplicationListener", listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationParameter(ApplicationParameter parameter) {
        ApplicationParameter[] applicationParameterArray = this.applicationParameters;
        synchronized (this.applicationParameters) {
            String newName = parameter.getName();
            int i = 0;
            while (i < this.applicationParameters.length) {
                if (this.name.equals(this.applicationParameters[i].getName()) && !this.applicationParameters[i].getOverride()) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                ++i;
            }
            ApplicationParameter[] results = new ApplicationParameter[this.applicationParameters.length + 1];
            System.arraycopy(this.applicationParameters, 0, results, 0, this.applicationParameters.length);
            results[this.applicationParameters.length] = parameter;
            this.applicationParameters = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("addApplicationParameter", parameter);
            return;
        }
    }

    public void addChild(Container child) {
        if (!(child instanceof Wrapper)) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardContext.notWrapper"));
        }
        Wrapper wrapper = (Wrapper)child;
        String jspFile = wrapper.getJspFile();
        if (jspFile != null && !jspFile.startsWith("/")) {
            if (this.isServlet22()) {
                this.log(ContainerBase.sm.getString("standardContext.wrapper.warning", jspFile));
                wrapper.setJspFile("/" + jspFile);
            } else {
                throw new IllegalArgumentException(ContainerBase.sm.getString("standardContext.wrapper.error", jspFile));
            }
        }
        super.addChild(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConstraint(SecurityConstraint constraint) {
        SecurityCollection[] collections = constraint.findCollections();
        int i = 0;
        while (i < collections.length) {
            String[] patterns = collections[i].findPatterns();
            int j = 0;
            while (j < patterns.length) {
                patterns[j] = this.adjustURLPattern(patterns[j]);
                if (!this.validateURLPattern(patterns[j])) {
                    throw new IllegalArgumentException(ContainerBase.sm.getString("standardContext.securityConstraint.pattern", patterns[j]));
                }
                ++j;
            }
            ++i;
        }
        SecurityConstraint[] securityConstraintArray = this.constraints;
        synchronized (this.constraints) {
            SecurityConstraint[] results = new SecurityConstraint[this.constraints.length + 1];
            int i2 = 0;
            while (i2 < this.constraints.length) {
                results[i2] = this.constraints[i2];
                ++i2;
            }
            results[this.constraints.length] = constraint;
            this.constraints = results;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEjb(ContextEjb ejb) {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            this.ejbs.put(ejb.getName(), ejb);
        }
        this.fireContainerEvent("addEjb", ejb.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEnvironment(ContextEnvironment environment) {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            ContextEnvironment env = (ContextEnvironment)this.envs.get(environment.getName());
            if (env != null && !env.getOverride()) {
                return;
            }
            this.envs.put(environment.getName(), environment);
        }
        this.fireContainerEvent("addEnvironment", environment.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceParams(ResourceParams resourceParameters) {
        HashMap hashMap = this.resourceParams;
        synchronized (hashMap) {
            this.resourceParams.put(resourceParameters.getName(), resourceParameters);
        }
        this.fireContainerEvent("addResourceParams", resourceParameters.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorPage(ErrorPage errorPage) {
        String exceptionType;
        if (errorPage == null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardContext.errorPage.required"));
        }
        String location = errorPage.getLocation();
        if (location != null && !location.startsWith("/")) {
            if (this.isServlet22()) {
                this.log(ContainerBase.sm.getString("standardContext.errorPage.warning", location));
                errorPage.setLocation("/" + location);
            } else {
                throw new IllegalArgumentException(ContainerBase.sm.getString("standardContext.errorPage.error", location));
            }
        }
        if ((exceptionType = errorPage.getExceptionType()) != null) {
            HashMap hashMap = this.exceptionPages;
            synchronized (hashMap) {
                this.exceptionPages.put(exceptionType, errorPage);
            }
        }
        HashMap hashMap = this.statusPages;
        synchronized (hashMap) {
            this.statusPages.put(new Integer(errorPage.getErrorCode()), errorPage);
        }
        this.fireContainerEvent("addErrorPage", errorPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterDef(FilterDef filterDef) {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            this.filterDefs.put(filterDef.getFilterName(), filterDef);
        }
        this.fireContainerEvent("addFilterDef", filterDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterMap(FilterMap filterMap) {
        String filterName = filterMap.getFilterName();
        String servletName = filterMap.getServletName();
        String urlPattern = filterMap.getURLPattern();
        if (this.findFilterDef(filterName) == null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardContext.filterMap.name", filterName));
        }
        if (servletName == null && urlPattern == null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardContext.filterMap.either"));
        }
        if (servletName != null && urlPattern != null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardContext.filterMap.either"));
        }
        if (urlPattern != null && !this.validateURLPattern(urlPattern)) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardContext.filterMap.pattern", urlPattern));
        }
        FilterMap[] filterMapArray = this.filterMaps;
        synchronized (this.filterMaps) {
            FilterMap[] results = new FilterMap[this.filterMaps.length + 1];
            System.arraycopy(this.filterMaps, 0, results, 0, this.filterMaps.length);
            results[this.filterMaps.length] = filterMap;
            this.filterMaps = results;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.fireContainerEvent("addFilterMap", filterMap);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceListener(String listener) {
        String[] stringArray = this.instanceListeners;
        synchronized (this.instanceListeners) {
            String[] results = new String[this.instanceListeners.length + 1];
            int i = 0;
            while (i < this.instanceListeners.length) {
                results[i] = this.instanceListeners[i];
                ++i;
            }
            results[this.instanceListeners.length] = listener;
            this.instanceListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("addInstanceListener", listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalEjb(ContextLocalEjb ejb) {
        HashMap hashMap = this.localEjbs;
        synchronized (hashMap) {
            this.localEjbs.put(ejb.getName(), ejb);
        }
        this.fireContainerEvent("addLocalEjb", ejb.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMimeMapping(String extension, String mimeType) {
        HashMap hashMap = this.mimeMappings;
        synchronized (hashMap) {
            this.mimeMappings.put(extension, mimeType);
        }
        this.fireContainerEvent("addMimeMapping", extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardContext.parameter.required"));
        }
        if (this.parameters.get(name) != null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardContext.parameter.duplicate", name));
        }
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.put(name, value);
        }
        this.fireContainerEvent("addParameter", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(ContextResource resource) {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            this.resources.put(resource.getName(), resource);
        }
        this.fireContainerEvent("addResource", resource.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceEnvRef(String name, String type) {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            this.resourceEnvRefs.put(name, type);
        }
        this.fireContainerEvent("addResourceEnvRef", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoleMapping(String role, String link) {
        HashMap hashMap = this.roleMappings;
        synchronized (hashMap) {
            this.roleMappings.put(role, link);
        }
        this.fireContainerEvent("addRoleMapping", role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecurityRole(String role) {
        String[] stringArray = this.securityRoles;
        synchronized (this.securityRoles) {
            String[] results = new String[this.securityRoles.length + 1];
            int i = 0;
            while (i < this.securityRoles.length) {
                results[i] = this.securityRoles[i];
                ++i;
            }
            results[this.securityRoles.length] = role;
            this.securityRoles = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("addSecurityRole", role);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServletMapping(String pattern, String name) {
        if (this.findChild(name) == null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardContext.servletMap.name", name));
        }
        if (!this.validateURLPattern(pattern = this.adjustURLPattern(RequestUtil.URLDecode(pattern)))) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardContext.servletMap.pattern", pattern));
        }
        HashMap hashMap = this.servletMappings;
        synchronized (hashMap) {
            this.servletMappings.put(pattern, name);
        }
        this.fireContainerEvent("addServletMapping", pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaglib(String uri, String location) {
        HashMap hashMap = this.taglibs;
        synchronized (hashMap) {
            this.taglibs.put(uri, location);
        }
        this.fireContainerEvent("addTaglib", uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWelcomeFile(String name) {
        String[] stringArray = this.welcomeFiles;
        synchronized (this.welcomeFiles) {
            if (this.replaceWelcomeFiles) {
                this.welcomeFiles = new String[0];
                this.setReplaceWelcomeFiles(false);
            }
            String[] results = new String[this.welcomeFiles.length + 1];
            int i = 0;
            while (i < this.welcomeFiles.length) {
                results[i] = this.welcomeFiles[i];
                ++i;
            }
            results[this.welcomeFiles.length] = name;
            this.welcomeFiles = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.postWelcomeFiles();
            this.fireContainerEvent("addWelcomeFile", name);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWrapperLifecycle(String listener) {
        String[] stringArray = this.wrapperLifecycles;
        synchronized (this.wrapperLifecycles) {
            String[] results = new String[this.wrapperLifecycles.length + 1];
            int i = 0;
            while (i < this.wrapperLifecycles.length) {
                results[i] = this.wrapperLifecycles[i];
                ++i;
            }
            results[this.wrapperLifecycles.length] = listener;
            this.wrapperLifecycles = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("addWrapperLifecycle", listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWrapperListener(String listener) {
        String[] stringArray = this.wrapperListeners;
        synchronized (this.wrapperListeners) {
            String[] results = new String[this.wrapperListeners.length + 1];
            int i = 0;
            while (i < this.wrapperListeners.length) {
                results[i] = this.wrapperListeners[i];
                ++i;
            }
            results[this.wrapperListeners.length] = listener;
            this.wrapperListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("addWrapperListener", listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wrapper createWrapper() {
        StandardWrapper wrapper = new StandardWrapper();
        String[] stringArray = this.instanceListeners;
        synchronized (this.instanceListeners) {
            int i = 0;
            while (i < this.instanceListeners.length) {
                try {
                    Class<?> clazz = Class.forName(this.instanceListeners[i]);
                    InstanceListener listener = (InstanceListener)clazz.newInstance();
                    wrapper.addInstanceListener(listener);
                }
                catch (Throwable t) {
                    this.log("createWrapper", t);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            String[] stringArray2 = this.wrapperLifecycles;
            synchronized (this.wrapperLifecycles) {
                int i2 = 0;
                while (i2 < this.wrapperLifecycles.length) {
                    try {
                        Class<?> clazz = Class.forName(this.wrapperLifecycles[i2]);
                        LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                        if (wrapper instanceof Lifecycle) {
                            ((Lifecycle)wrapper).addLifecycleListener(listener);
                        }
                    }
                    catch (Throwable t) {
                        this.log("createWrapper", t);
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                        return null;
                    }
                    ++i2;
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
                String[] stringArray3 = this.wrapperListeners;
                synchronized (this.wrapperListeners) {
                    int i3 = 0;
                    while (i3 < this.wrapperListeners.length) {
                        try {
                            Class<?> clazz = Class.forName(this.wrapperListeners[i3]);
                            ContainerListener listener = (ContainerListener)clazz.newInstance();
                            wrapper.addContainerListener(listener);
                        }
                        catch (Throwable t) {
                            this.log("createWrapper", t);
                            // ** MonitorExit[var4_8] (shouldn't be in output)
                            return null;
                        }
                        ++i3;
                    }
                    // ** MonitorExit[var4_8] (shouldn't be in output)
                    return wrapper;
                }
            }
        }
    }

    public String[] findApplicationListeners() {
        return this.applicationListeners;
    }

    public ApplicationParameter[] findApplicationParameters() {
        return this.applicationParameters;
    }

    public SecurityConstraint[] findConstraints() {
        return this.constraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb findEjb(String name) {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            return (ContextEjb)this.ejbs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb[] findEjbs() {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            ContextEjb[] results = new ContextEjb[this.ejbs.size()];
            return this.ejbs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment findEnvironment(String name) {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            return (ContextEnvironment)this.envs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment[] findEnvironments() {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            ContextEnvironment[] results = new ContextEnvironment[this.envs.size()];
            return this.envs.values().toArray(results);
        }
    }

    public ErrorPage findErrorPage(int errorCode) {
        return (ErrorPage)this.statusPages.get(new Integer(errorCode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorPage findErrorPage(String exceptionType) {
        HashMap hashMap = this.exceptionPages;
        synchronized (hashMap) {
            return (ErrorPage)this.exceptionPages.get(exceptionType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorPage[] findErrorPages() {
        HashMap hashMap = this.exceptionPages;
        synchronized (hashMap) {
            HashMap hashMap2 = this.statusPages;
            synchronized (hashMap2) {
                ErrorPage[] results1 = new ErrorPage[this.exceptionPages.size()];
                results1 = this.exceptionPages.values().toArray(results1);
                ErrorPage[] results2 = new ErrorPage[this.statusPages.size()];
                results2 = this.statusPages.values().toArray(results2);
                ErrorPage[] results = new ErrorPage[results1.length + results2.length];
                int i = 0;
                while (i < results1.length) {
                    results[i] = results1[i];
                    ++i;
                }
                int i2 = results1.length;
                while (i2 < results.length) {
                    results[i2] = results2[i2 - results1.length];
                    ++i2;
                }
                return results;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterDef findFilterDef(String filterName) {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            return (FilterDef)this.filterDefs.get(filterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterDef[] findFilterDefs() {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            FilterDef[] results = new FilterDef[this.filterDefs.size()];
            return this.filterDefs.values().toArray(results);
        }
    }

    public FilterMap[] findFilterMaps() {
        return this.filterMaps;
    }

    public String[] findInstanceListeners() {
        return this.instanceListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLocalEjb findLocalEjb(String name) {
        HashMap hashMap = this.localEjbs;
        synchronized (hashMap) {
            return (ContextLocalEjb)this.localEjbs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLocalEjb[] findLocalEjbs() {
        HashMap hashMap = this.localEjbs;
        synchronized (hashMap) {
            ContextLocalEjb[] results = new ContextLocalEjb[this.localEjbs.size()];
            return this.localEjbs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findMimeMapping(String extension) {
        HashMap hashMap = this.mimeMappings;
        synchronized (hashMap) {
            return (String)this.mimeMappings.get(extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findMimeMappings() {
        HashMap hashMap = this.mimeMappings;
        synchronized (hashMap) {
            String[] results = new String[this.mimeMappings.size()];
            return this.mimeMappings.keySet().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            return (String)this.parameters.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findParameters() {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            String[] results = new String[this.parameters.size()];
            return this.parameters.keySet().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource findResource(String name) {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            return (ContextResource)this.resources.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findResourceEnvRef(String name) {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            return (String)this.resourceEnvRefs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findResourceEnvRefs() {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            String[] results = new String[this.resourceEnvRefs.size()];
            return this.resourceEnvRefs.keySet().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource[] findResources() {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            ContextResource[] results = new ContextResource[this.resources.size()];
            return this.resources.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findRoleMapping(String role) {
        String realRole = null;
        HashMap hashMap = this.roleMappings;
        synchronized (hashMap) {
            realRole = (String)this.roleMappings.get(role);
        }
        if (realRole != null) {
            return realRole;
        }
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findSecurityRole(String role) {
        String[] stringArray = this.securityRoles;
        synchronized (this.securityRoles) {
            int i = 0;
            while (i < this.securityRoles.length) {
                if (role.equals(this.securityRoles[i])) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    public String[] findSecurityRoles() {
        return this.securityRoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findServletMapping(String pattern) {
        HashMap hashMap = this.servletMappings;
        synchronized (hashMap) {
            return (String)this.servletMappings.get(pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findServletMappings() {
        HashMap hashMap = this.servletMappings;
        synchronized (hashMap) {
            String[] results = new String[this.servletMappings.size()];
            return this.servletMappings.keySet().toArray(results);
        }
    }

    public String findStatusPage(int status) {
        return (String)this.statusPages.get(new Integer(status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findStatusPages() {
        HashMap hashMap = this.statusPages;
        synchronized (hashMap) {
            int[] results = new int[this.statusPages.size()];
            Iterator elements = this.statusPages.keySet().iterator();
            int i = 0;
            while (elements.hasNext()) {
                results[i++] = (Integer)elements.next();
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findTaglib(String uri) {
        HashMap hashMap = this.taglibs;
        synchronized (hashMap) {
            return (String)this.taglibs.get(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findTaglibs() {
        HashMap hashMap = this.taglibs;
        synchronized (hashMap) {
            String[] results = new String[this.taglibs.size()];
            return this.taglibs.keySet().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findWelcomeFile(String name) {
        String[] stringArray = this.welcomeFiles;
        synchronized (this.welcomeFiles) {
            int i = 0;
            while (i < this.welcomeFiles.length) {
                if (name.equals(this.welcomeFiles[i])) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    public String[] findWelcomeFiles() {
        return this.welcomeFiles;
    }

    public String[] findWrapperLifecycles() {
        return this.wrapperLifecycles;
    }

    public String[] findWrapperListeners() {
        return this.wrapperListeners;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        while (this.getPaused()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        super.invoke(request, response);
    }

    public synchronized void reload() {
        if (!this.started) {
            throw new IllegalStateException(ContainerBase.sm.getString("containerBase.notStarted", this.logName()));
        }
        this.log(ContainerBase.sm.getString("standardContext.reloadingStarted"));
        this.setPaused(true);
        ClassLoader oldCCL = this.bindThread();
        Container[] children = this.findChildren();
        int i = 0;
        while (i < children.length) {
            Wrapper wrapper = (Wrapper)children[i];
            if (wrapper instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)wrapper)).stop();
                }
                catch (LifecycleException e) {
                    this.log(ContainerBase.sm.getString("standardContext.stoppingWrapper", wrapper.getName()), e);
                }
            }
            ++i;
        }
        if (this.context != null) {
            this.context.clearAttributes();
        }
        this.filterStop();
        this.listenerStop();
        if (this.manager != null && this.manager instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.manager)).stop();
            }
            catch (LifecycleException e) {
                this.log(ContainerBase.sm.getString("standardContext.stoppingManager"), e);
            }
        }
        this.unbindThread(oldCCL);
        if (this.loader != null && this.loader instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.loader)).stop();
            }
            catch (LifecycleException e) {
                this.log(ContainerBase.sm.getString("standardContext.stoppingLoader"), e);
            }
        }
        if (this.isUseNaming()) {
            ContextBindings.unbindClassLoader((Object)this, (Object)this);
        }
        if (this.loader != null && this.loader instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.loader)).start();
            }
            catch (LifecycleException e) {
                this.log(ContainerBase.sm.getString("standardContext.startingLoader"), e);
            }
        }
        boolean ok = true;
        if (this.isUseNaming()) {
            try {
                this.createNamingContext();
            }
            catch (NamingException e) {
                this.log(ContainerBase.sm.getString("standardContext.namingInitFailed", this.getName()));
                ok = false;
            }
        }
        oldCCL = this.bindThread();
        if (ok && !this.listenerStart()) {
            this.log(ContainerBase.sm.getString("standardContext.listenerStartFailed"));
            ok = false;
        }
        if (ok && !this.filterStart()) {
            this.log(ContainerBase.sm.getString("standardContext.filterStartFailed"));
            ok = false;
        }
        this.postResources();
        this.postWelcomeFiles();
        int i2 = 0;
        while (i2 < children.length) {
            if (!ok) break;
            Wrapper wrapper = (Wrapper)children[i2];
            if (wrapper instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)wrapper)).start();
                }
                catch (LifecycleException e) {
                    this.log(ContainerBase.sm.getString("standardContext.startingWrapper", wrapper.getName()), e);
                    ok = false;
                }
            }
            ++i2;
        }
        this.loadOnStartup(children);
        if (this.manager != null && this.manager instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.manager)).start();
            }
            catch (LifecycleException e) {
                this.log(ContainerBase.sm.getString("standardContext.startingManager"), e);
            }
        }
        this.unbindThread(oldCCL);
        if (ok) {
            this.log(ContainerBase.sm.getString("standardContext.reloadingCompleted"));
        } else {
            this.setAvailable(false);
            this.log(ContainerBase.sm.getString("standardContext.reloadingFailed"));
        }
        this.setPaused(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationListener(String listener) {
        String[] stringArray = this.applicationListeners;
        synchronized (this.applicationListeners) {
            int n = -1;
            int i = 0;
            while (i < this.applicationListeners.length) {
                if (this.applicationListeners[i].equals(listener)) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.applicationListeners.length - 1];
            int i2 = 0;
            while (i2 < this.applicationListeners.length) {
                if (i2 != n) {
                    results[j++] = this.applicationListeners[i2];
                }
                ++i2;
            }
            this.applicationListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeApplicationListener", listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationParameter(String name) {
        ApplicationParameter[] applicationParameterArray = this.applicationParameters;
        synchronized (this.applicationParameters) {
            int n = -1;
            int i = 0;
            while (i < this.applicationParameters.length) {
                if (name.equals(this.applicationParameters[i].getName())) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            ApplicationParameter[] results = new ApplicationParameter[this.applicationParameters.length - 1];
            int i2 = 0;
            while (i2 < this.applicationParameters.length) {
                if (i2 != n) {
                    results[j++] = this.applicationParameters[i2];
                }
                ++i2;
            }
            this.applicationParameters = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeApplicationParameter", name);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConstraint(SecurityConstraint constraint) {
        SecurityConstraint[] securityConstraintArray = this.constraints;
        synchronized (this.constraints) {
            int n = -1;
            int i = 0;
            while (i < this.constraints.length) {
                if (this.constraints[i].equals(constraint)) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            SecurityConstraint[] results = new SecurityConstraint[this.constraints.length - 1];
            int i2 = 0;
            while (i2 < this.constraints.length) {
                if (i2 != n) {
                    results[j++] = this.constraints[i2];
                }
                ++i2;
            }
            this.constraints = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeConstraint", constraint);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEjb(String name) {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            this.ejbs.remove(name);
        }
        this.fireContainerEvent("removeEjb", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEnvironment(String name) {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            this.envs.remove(name);
        }
        this.fireContainerEvent("removeEnvironment", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErrorPage(ErrorPage errorPage) {
        String exceptionType = errorPage.getExceptionType();
        if (exceptionType != null) {
            HashMap hashMap = this.exceptionPages;
            synchronized (hashMap) {
                this.exceptionPages.remove(exceptionType);
            }
        }
        HashMap hashMap = this.statusPages;
        synchronized (hashMap) {
            this.statusPages.remove(new Integer(errorPage.getErrorCode()));
        }
        this.fireContainerEvent("removeErrorPage", errorPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterDef(FilterDef filterDef) {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            this.filterDefs.remove(filterDef.getFilterName());
        }
        this.fireContainerEvent("removeFilterDef", filterDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterMap(FilterMap filterMap) {
        FilterMap[] filterMapArray = this.filterMaps;
        synchronized (this.filterMaps) {
            int n = -1;
            int i = 0;
            while (i < this.filterMaps.length) {
                if (this.filterMaps[i] == filterMap) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            FilterMap[] results = new FilterMap[this.filterMaps.length - 1];
            System.arraycopy(this.filterMaps, 0, results, 0, n);
            System.arraycopy(this.filterMaps, n + 1, results, n, this.filterMaps.length - 1 - n);
            this.filterMaps = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeFilterMap", filterMap);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(String listener) {
        String[] stringArray = this.instanceListeners;
        synchronized (this.instanceListeners) {
            int n = -1;
            int i = 0;
            while (i < this.instanceListeners.length) {
                if (this.instanceListeners[i].equals(listener)) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.instanceListeners.length - 1];
            int i2 = 0;
            while (i2 < this.instanceListeners.length) {
                if (i2 != n) {
                    results[j++] = this.instanceListeners[i2];
                }
                ++i2;
            }
            this.instanceListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeInstanceListener", listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalEjb(String name) {
        HashMap hashMap = this.localEjbs;
        synchronized (hashMap) {
            this.localEjbs.remove(name);
        }
        this.fireContainerEvent("removeLocalEjb", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMimeMapping(String extension) {
        HashMap hashMap = this.mimeMappings;
        synchronized (hashMap) {
            this.mimeMappings.remove(extension);
        }
        this.fireContainerEvent("removeMimeMapping", extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.remove(name);
        }
        this.fireContainerEvent("removeParameter", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(String name) {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            this.resources.remove(name);
        }
        this.fireContainerEvent("removeResource", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceEnvRef(String name) {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            this.resourceEnvRefs.remove(name);
        }
        this.fireContainerEvent("removeResourceEnvRef", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoleMapping(String role) {
        HashMap hashMap = this.roleMappings;
        synchronized (hashMap) {
            this.roleMappings.remove(role);
        }
        this.fireContainerEvent("removeRoleMapping", role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityRole(String role) {
        String[] stringArray = this.securityRoles;
        synchronized (this.securityRoles) {
            int n = -1;
            int i = 0;
            while (i < this.securityRoles.length) {
                if (role.equals(this.securityRoles[i])) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.securityRoles.length - 1];
            int i2 = 0;
            while (i2 < this.securityRoles.length) {
                if (i2 != n) {
                    results[j++] = this.securityRoles[i2];
                }
                ++i2;
            }
            this.securityRoles = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeSecurityRole", role);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServletMapping(String pattern) {
        HashMap hashMap = this.servletMappings;
        synchronized (hashMap) {
            this.servletMappings.remove(pattern);
        }
        this.fireContainerEvent("removeServletMapping", pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaglib(String uri) {
        HashMap hashMap = this.taglibs;
        synchronized (hashMap) {
            this.taglibs.remove(uri);
        }
        this.fireContainerEvent("removeTaglib", uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWelcomeFile(String name) {
        String[] stringArray = this.welcomeFiles;
        synchronized (this.welcomeFiles) {
            int n = -1;
            int i = 0;
            while (i < this.welcomeFiles.length) {
                if (this.welcomeFiles[i].equals(name)) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.welcomeFiles.length - 1];
            int i2 = 0;
            while (i2 < this.welcomeFiles.length) {
                if (i2 != n) {
                    results[j++] = this.welcomeFiles[i2];
                }
                ++i2;
            }
            this.welcomeFiles = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.postWelcomeFiles();
            this.fireContainerEvent("removeWelcomeFile", name);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWrapperLifecycle(String listener) {
        String[] stringArray = this.wrapperLifecycles;
        synchronized (this.wrapperLifecycles) {
            int n = -1;
            int i = 0;
            while (i < this.wrapperLifecycles.length) {
                if (this.wrapperLifecycles[i].equals(listener)) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.wrapperLifecycles.length - 1];
            int i2 = 0;
            while (i2 < this.wrapperLifecycles.length) {
                if (i2 != n) {
                    results[j++] = this.wrapperLifecycles[i2];
                }
                ++i2;
            }
            this.wrapperLifecycles = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeWrapperLifecycle", listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWrapperListener(String listener) {
        String[] stringArray = this.wrapperListeners;
        synchronized (this.wrapperListeners) {
            int n = -1;
            int i = 0;
            while (i < this.wrapperListeners.length) {
                if (this.wrapperListeners[i].equals(listener)) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.wrapperListeners.length - 1];
            int i2 = 0;
            while (i2 < this.wrapperListeners.length) {
                if (i2 != n) {
                    results[j++] = this.wrapperListeners[i2];
                }
                ++i2;
            }
            this.wrapperListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeWrapperListener", listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStart() {
        if (this.debug >= 1) {
            this.log("Starting filters");
        }
        boolean ok = true;
        HashMap hashMap = this.filterConfigs;
        synchronized (hashMap) {
            this.filterConfigs.clear();
            Iterator names = this.filterDefs.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                if (this.debug >= 1) {
                    this.log(" Starting filter '" + name + "'");
                }
                ApplicationFilterConfig filterConfig = null;
                try {
                    filterConfig = new ApplicationFilterConfig(this, (FilterDef)this.filterDefs.get(name));
                    this.filterConfigs.put(name, filterConfig);
                }
                catch (Throwable t) {
                    this.log(ContainerBase.sm.getString("standardContext.filterStart", name), t);
                    ok = false;
                }
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStop() {
        if (this.debug >= 1) {
            this.log("Stopping filters");
        }
        HashMap hashMap = this.filterConfigs;
        synchronized (hashMap) {
            Iterator names = this.filterConfigs.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                if (this.debug >= 1) {
                    this.log(" Stopping filter '" + name + "'");
                }
                ApplicationFilterConfig filterConfig = (ApplicationFilterConfig)this.filterConfigs.get(name);
                filterConfig.release();
            }
            this.filterConfigs.clear();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterConfig findFilterConfig(String name) {
        HashMap hashMap = this.filterConfigs;
        synchronized (hashMap) {
            return (FilterConfig)this.filterConfigs.get(name);
        }
    }

    public boolean listenerStart() {
        if (this.debug >= 1) {
            this.log("Configuring application event listeners");
        }
        ClassLoader loader = this.getLoader().getClassLoader();
        String[] listeners = this.findApplicationListeners();
        Object[] results = new Object[listeners.length];
        boolean ok = true;
        int i = 0;
        while (i < results.length) {
            if (this.debug >= 2) {
                this.log(" Configuring event listener class '" + listeners[i] + "'");
            }
            try {
                Class<?> clazz = loader.loadClass(listeners[i]);
                results[i] = clazz.newInstance();
            }
            catch (Throwable t) {
                this.log(ContainerBase.sm.getString("standardContext.applicationListener", listeners[i]), t);
                ok = false;
            }
            ++i;
        }
        if (!ok) {
            this.log(ContainerBase.sm.getString("standardContext.applicationSkipped"));
            return false;
        }
        if (this.debug >= 1) {
            this.log("Sending application start events");
        }
        this.setApplicationListeners(results);
        Object[] instances = this.getApplicationListeners();
        if (instances == null) {
            return ok;
        }
        ServletContextEvent event = new ServletContextEvent(this.getServletContext());
        int i2 = 0;
        while (i2 < instances.length) {
            if (instances[i2] != null && instances[i2] instanceof ServletContextListener) {
                ServletContextListener listener = (ServletContextListener)instances[i2];
                try {
                    this.fireContainerEvent("beforeContextInitialized", listener);
                    listener.contextInitialized(event);
                    this.fireContainerEvent("afterContextInitialized", listener);
                }
                catch (Throwable t) {
                    this.fireContainerEvent("afterContextInitialized", listener);
                    this.log(ContainerBase.sm.getString("standardContext.listenerStart", instances[i2].getClass().getName()), t);
                    ok = false;
                }
            }
            ++i2;
        }
        return ok;
    }

    public boolean listenerStop() {
        if (this.debug >= 1) {
            this.log("Sending application stop events");
        }
        boolean ok = true;
        Object[] listeners = this.getApplicationListeners();
        if (listeners == null) {
            return ok;
        }
        ServletContextEvent event = new ServletContextEvent(this.getServletContext());
        int i = 0;
        while (i < listeners.length) {
            int j = listeners.length - 1 - i;
            if (listeners[j] != null && listeners[j] instanceof ServletContextListener) {
                ServletContextListener listener = (ServletContextListener)listeners[j];
                try {
                    this.fireContainerEvent("beforeContextDestroyed", listener);
                    listener.contextDestroyed(event);
                    this.fireContainerEvent("beforeContextDestroyed", listener);
                }
                catch (Throwable t) {
                    this.fireContainerEvent("beforeContextDestroyed", listener);
                    this.log(ContainerBase.sm.getString("standardContext.listenerStop", listeners[j].getClass().getName()), t);
                    ok = false;
                }
            }
            ++i;
        }
        this.setApplicationListeners(null);
        return ok;
    }

    public void loadOnStartup(Container[] children) {
        TreeMap<Integer, ArrayList<Wrapper>> map = new TreeMap<Integer, ArrayList<Wrapper>>();
        int i = 0;
        while (i < children.length) {
            Wrapper wrapper = (Wrapper)children[i];
            int loadOnStartup = wrapper.getLoadOnStartup();
            if (loadOnStartup >= 0) {
                Integer key;
                ArrayList<Wrapper> list;
                if (loadOnStartup == 0) {
                    loadOnStartup = Integer.MAX_VALUE;
                }
                if ((list = (ArrayList<Wrapper>)map.get(key = new Integer(loadOnStartup))) == null) {
                    list = new ArrayList<Wrapper>();
                    map.put(key, list);
                }
                list.add(wrapper);
            }
            ++i;
        }
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            Integer key = (Integer)keys.next();
            ArrayList list = (ArrayList)map.get(key);
            Iterator wrappers = list.iterator();
            while (wrappers.hasNext()) {
                Wrapper wrapper = (Wrapper)wrappers.next();
                try {
                    wrapper.load();
                }
                catch (ServletException e) {
                    this.log(ContainerBase.sm.getString("standardWrapper.loadException", this.getName()), e);
                }
            }
        }
    }

    public synchronized void start() throws LifecycleException {
        String useNamingProperty;
        boolean ok;
        block34: {
            if (this.debug >= 1) {
                this.log("Starting");
            }
            if (this.debug >= 1) {
                this.log("Processing start(), current available=" + this.getAvailable());
            }
            this.setAvailable(false);
            this.setConfigured(false);
            ok = true;
            if (this.getResources() == null) {
                if (this.debug >= 1) {
                    this.log("Configuring default Resources");
                }
                try {
                    if (this.docBase != null && this.docBase.endsWith(".war")) {
                        this.setResources((DirContext)new WARDirContext());
                        break block34;
                    }
                    this.setResources((DirContext)new FileDirContext());
                }
                catch (IllegalArgumentException e) {
                    this.log("Error initializing resources: " + e.getMessage());
                    ok = false;
                }
            } else {
                DirContext dirContext = this.getResources();
                if (dirContext instanceof ProxyDirContext) {
                    dirContext = ((ProxyDirContext)dirContext).getDirContext();
                    this.log("Configuring ProxyDirContext Resources" + dirContext);
                }
                if (dirContext instanceof BaseDirContext) {
                    ((BaseDirContext)dirContext).setDocBase(this.getBasePath());
                    ((BaseDirContext)dirContext).setCached(this.isCachingAllowed());
                }
                if (dirContext instanceof FileDirContext) {
                    this.filesystemBased = true;
                }
            }
        }
        if (this.getLoader() == null) {
            if (this.debug >= 1) {
                this.log("Configuring non-privileged default Loader");
            }
            this.setLoader(new WebappLoader(this.getParentClassLoader()));
        }
        if (this.getManager() == null) {
            if (this.debug >= 1) {
                this.log("Configuring default Manager");
            }
            this.setManager(new StandardManager());
        }
        if (ok) {
            DirContextURLStreamHandler.bind((DirContext)this.getResources());
        }
        this.getCharsetMapper();
        this.postWorkDirectory();
        if (this.debug >= 1) {
            this.log("Processing standard container startup");
        }
        if (ok) {
            super.start();
        }
        if (!this.getConfigured()) {
            ok = false;
        }
        if ((useNamingProperty = System.getProperty("catalina.useNaming")) != null && useNamingProperty.equals("false")) {
            this.useNaming = false;
        }
        if (ok && this.isUseNaming()) {
            try {
                this.createNamingContext();
            }
            catch (NamingException e) {
                this.log(ContainerBase.sm.getString("standardContext.namingInitFailed", this.getName()));
                ok = false;
            }
        }
        if (ok) {
            this.getServletContext().setAttribute("org.apache.catalina.resources", (Object)this.getResources());
        }
        ClassLoader oldCCL = this.bindThread();
        if (ok && !this.listenerStart()) {
            ok = false;
        }
        if (ok && !this.filterStart()) {
            ok = false;
        }
        if (ok) {
            if (this.debug >= 1) {
                this.log("Posting standard context attributes");
            }
            this.postWelcomeFiles();
        }
        if (ok) {
            this.loadOnStartup(this.findChildren());
        }
        this.unbindThread(oldCCL);
        if (ok) {
            if (this.debug >= 1) {
                this.log("Starting completed");
            }
            this.setAvailable(true);
        } else {
            this.log(ContainerBase.sm.getString("standardContext.startFailed"));
            try {
                this.stop();
            }
            catch (Throwable t) {
                this.log(ContainerBase.sm.getString("standardContext.startCleanup"), t);
            }
            this.setAvailable(false);
        }
    }

    public synchronized void stop() throws LifecycleException {
        DirContext dirContext;
        if (this.debug >= 1) {
            this.log("Stopping");
        }
        this.setAvailable(false);
        ClassLoader oldCCL = this.bindThread();
        this.filterStop();
        this.listenerStop();
        this.setCharsetMapper(null);
        if (this.isUseNaming()) {
            ContextBindings.unbindClassLoader((Object)this, (Object)this);
            ContextAccessController.unsetSecurityToken((Object)this.getNamingContextName(), (Object)this);
        }
        if ((dirContext = this.getResources()) != null && dirContext instanceof ProxyDirContext) {
            dirContext = ((ProxyDirContext)dirContext).getDirContext();
        }
        if (dirContext != null) {
            if (this.debug >= 1) {
                this.log("Releasing document base " + this.docBase);
            }
            if (dirContext instanceof BaseDirContext) {
                ((BaseDirContext)dirContext).release();
            } else {
                this.log("Cannot release " + this.resources);
            }
        }
        if (this.debug >= 1) {
            this.log("Processing standard container shutdown");
        }
        super.stop();
        this.unbindThread(oldCCL);
        if (this.debug >= 1) {
            this.log("Stopping complete");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardContext[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    protected void addDefaultMapper(String mapperClass) {
        super.addDefaultMapper(this.mapperClass);
    }

    protected String adjustURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return urlPattern;
        }
        if (urlPattern.startsWith("/") || urlPattern.startsWith("*.")) {
            return urlPattern;
        }
        if (!this.isServlet22()) {
            return urlPattern;
        }
        this.log(ContainerBase.sm.getString("standardContext.urlPattern.patternWarning", urlPattern));
        return "/" + urlPattern;
    }

    protected boolean isServlet22() {
        if (this.publicId == null) {
            return false;
        }
        return this.publicId.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN");
    }

    protected File engineBase() {
        return new File(System.getProperty("catalina.base"));
    }

    private ClassLoader bindThread() {
        ClassLoader oldContextClassLoader;
        block3: {
            oldContextClassLoader = Thread.currentThread().getContextClassLoader();
            if (this.getResources() == null) {
                return oldContextClassLoader;
            }
            Thread.currentThread().setContextClassLoader(this.getLoader().getClassLoader());
            DirContextURLStreamHandler.bind((DirContext)this.getResources());
            if (!this.isUseNaming()) break block3;
            try {
                ContextBindings.bindThread((Object)this, (Object)this);
            }
            catch (NamingException e) {
                this.log(ContainerBase.sm.getString("standardContext.namingInitFailed", this.getName()));
            }
        }
        return oldContextClassLoader;
    }

    private void unbindThread(ClassLoader oldContextClassLoader) {
        Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        oldContextClassLoader = null;
        if (this.isUseNaming()) {
            ContextBindings.unbindThread((Object)this, (Object)this);
        }
        DirContextURLStreamHandler.unbind();
    }

    private String getBasePath() {
        String docBase = null;
        Container container = this;
        while (container != null) {
            if (container instanceof Host) break;
            container = container.getParent();
        }
        if (container == null) {
            docBase = new File(this.engineBase(), this.getDocBase()).getPath();
        } else {
            File file = new File(this.getDocBase());
            if (!file.isAbsolute()) {
                String appBase = ((Host)container).getAppBase();
                file = new File(appBase);
                if (!file.isAbsolute()) {
                    file = new File(this.engineBase(), appBase);
                }
                docBase = new File(file, this.getDocBase()).getPath();
            } else {
                docBase = file.getPath();
            }
        }
        return docBase;
    }

    private void createNamingContext() throws NamingException {
        TransactionRef ref;
        Hashtable contextEnv = new Hashtable();
        NamingContext namingContext = new NamingContext(contextEnv, this.getNamingContextName());
        ContextAccessController.setSecurityToken((Object)this.getNamingContextName(), (Object)this);
        ContextBindings.bindContext((Object)this, (javax.naming.Context)namingContext, (Object)this);
        ContextBindings.bindThread((Object)this, (Object)this);
        ContextAccessController.setWritable((Object)this.getNamingContextName(), (Object)this);
        javax.naming.Context compCtx = namingContext.createSubcontext("comp");
        javax.naming.Context envCtx = compCtx.createSubcontext("env");
        Iterator envsList = this.envs.values().iterator();
        while (envsList.hasNext()) {
            ContextEnvironment env = (ContextEnvironment)envsList.next();
            Object value = null;
            String type = env.getType();
            try {
                if (type.equals("java.lang.String")) {
                    value = env.getValue();
                } else if (type.equals("java.lang.Byte")) {
                    value = Byte.decode(env.getValue());
                } else if (type.equals("java.lang.Short")) {
                    value = Short.decode(env.getValue());
                } else if (type.equals("java.lang.Integer")) {
                    value = Integer.decode(env.getValue());
                } else if (type.equals("java.lang.Long")) {
                    value = Long.decode(env.getValue());
                } else if (type.equals("java.lang.Boolean")) {
                    value = Boolean.valueOf(env.getValue());
                } else if (type.equals("java.lang.Double")) {
                    value = Double.valueOf(env.getValue());
                } else if (type.equals("java.lang.Float")) {
                    value = Float.valueOf(env.getValue());
                } else {
                    this.log(ContainerBase.sm.getString("standardContext.invalidEnvEntryType", env.getName()));
                }
            }
            catch (NumberFormatException e) {
                this.log(ContainerBase.sm.getString("standardContext.invalidEnvEntryValue", env.getName()));
            }
            if (value == null) continue;
            try {
                this.createSubcontexts(envCtx, env.getName());
                envCtx.bind(env.getName(), value);
            }
            catch (NamingException e) {
                this.log(ContainerBase.sm.getString("standardContext.invalidEnvEntryValue", e));
            }
        }
        Iterator ejbsList = this.ejbs.values().iterator();
        while (ejbsList.hasNext()) {
            ContextEjb ejb = (ContextEjb)ejbsList.next();
            EjbRef ref2 = new EjbRef(ejb.getType(), ejb.getHome(), ejb.getRemote(), ejb.getLink());
            this.addAdditionalParameters((Reference)ref2, ejb.getName());
            try {
                this.createSubcontexts(envCtx, ejb.getName());
                envCtx.bind(ejb.getName(), (Object)ref2);
            }
            catch (NamingException e) {
                this.log(ContainerBase.sm.getString("standardContext.bindFailed", e));
            }
        }
        Iterator resourcesList = this.resources.values().iterator();
        while (resourcesList.hasNext()) {
            ContextResource resource = (ContextResource)resourcesList.next();
            ref = new ResourceRef(resource.getType(), resource.getDescription(), resource.getScope(), resource.getAuth());
            this.addAdditionalParameters((Reference)ref, resource.getName());
            try {
                this.createSubcontexts(envCtx, resource.getName());
                envCtx.bind(resource.getName(), (Object)ref);
            }
            catch (NamingException e) {
                this.log(ContainerBase.sm.getString("standardContext.bindFailed", e));
            }
        }
        Iterator resourceEnvsKeyList = this.resourceEnvRefs.keySet().iterator();
        while (resourceEnvsKeyList.hasNext()) {
            String key = (String)resourceEnvsKeyList.next();
            String type = (String)this.resourceEnvRefs.get(key);
            ResourceEnvRef ref3 = new ResourceEnvRef(type);
            this.addAdditionalParameters((Reference)ref3, key);
            try {
                this.createSubcontexts(envCtx, key);
                envCtx.bind(key, (Object)ref3);
            }
            catch (NamingException e) {
                this.log(ContainerBase.sm.getString("standardContext.bindFailed", e));
            }
        }
        try {
            ref = new TransactionRef();
            compCtx.bind("UserTransaction", (Object)ref);
            this.addAdditionalParameters((Reference)ref, "UserTransaction");
        }
        catch (NamingException e) {
            this.log(ContainerBase.sm.getString("standardContext.bindFailed", e));
        }
        try {
            compCtx.bind("Resources", (Object)this.getResources());
        }
        catch (NamingException e) {
            this.log(ContainerBase.sm.getString("standardContext.bindFailed", e));
        }
        ContextAccessController.setReadOnly((Object)this.getNamingContextName());
        ContextBindings.unbindThread((Object)this, (Object)this);
        ContextBindings.bindClassLoader((Object)this, (Object)this, (ClassLoader)this.getLoader().getClassLoader());
    }

    private String getNamingContextName() {
        if (this.namingContextName == null) {
            Container parent = this.getParent();
            if (parent == null) {
                this.namingContextName = this.getName();
            } else {
                Stack<String> stk = new Stack<String>();
                StringBuffer buff = new StringBuffer();
                while (parent != null) {
                    stk.push(parent.getName());
                    parent = parent.getParent();
                }
                while (!stk.empty()) {
                    buff.append("/" + stk.pop());
                }
                buff.append(this.getName());
                this.namingContextName = buff.toString();
            }
        }
        return this.namingContextName;
    }

    private void createSubcontexts(javax.naming.Context ctx, String name) throws NamingException {
        javax.naming.Context currentContext = ctx;
        StringTokenizer tokenizer = new StringTokenizer(name, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("") || !tokenizer.hasMoreTokens()) continue;
            try {
                currentContext = currentContext.createSubcontext(token);
            }
            catch (NamingException e) {
                currentContext = (javax.naming.Context)currentContext.lookup(token);
            }
        }
    }

    private void addAdditionalParameters(Reference ref, String name) {
        ResourceParams resourceParameters = (ResourceParams)this.resourceParams.get(name);
        if (resourceParameters == null) {
            return;
        }
        Hashtable params = resourceParameters.getParameters();
        Enumeration enumeration = params.keys();
        while (enumeration.hasMoreElements()) {
            String paramName = (String)enumeration.nextElement();
            String paramValue = (String)params.get(paramName);
            StringRefAddr refAddr = new StringRefAddr(paramName, paramValue);
            ref.add(refAddr);
        }
    }

    private boolean getPaused() {
        return this.paused;
    }

    private void postResources() {
        this.getServletContext().setAttribute("org.apache.catalina.resources", (Object)this.getResources());
    }

    private void postWelcomeFiles() {
        this.getServletContext().setAttribute("org.apache.catalina.WELCOME_FILES", (Object)this.welcomeFiles);
    }

    private void postWorkDirectory() {
        File dir;
        String workDir = this.getWorkDir();
        if (workDir == null) {
            String temp;
            String hostName = null;
            String engineName = null;
            String hostWorkDir = null;
            Container parentHost = this.getParent();
            if (parentHost != null) {
                Container parentEngine;
                hostName = parentHost.getName();
                if (parentHost instanceof StandardHost) {
                    hostWorkDir = ((StandardHost)parentHost).getWorkDir();
                }
                if ((parentEngine = parentHost.getParent()) != null) {
                    engineName = parentEngine.getName();
                }
            }
            if (hostName == null || hostName.length() < 1) {
                hostName = "_";
            }
            if (engineName == null || engineName.length() < 1) {
                engineName = "_";
            }
            if ((temp = this.getPath()).startsWith("/")) {
                temp = temp.substring(1);
            }
            temp = temp.replace('/', '_');
            if ((temp = temp.replace('\\', '_')).length() < 1) {
                temp = "_";
            }
            workDir = hostWorkDir != null ? hostWorkDir + File.separator + temp : "work" + File.separator + engineName + File.separator + hostName + File.separator + temp;
            this.setWorkDir(workDir);
        }
        if (!(dir = new File(workDir)).isAbsolute()) {
            File catalinaHome = new File(System.getProperty("catalina.base"));
            String catalinaHomePath = null;
            try {
                catalinaHomePath = catalinaHome.getCanonicalPath();
                dir = new File(catalinaHomePath, workDir);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        dir.mkdirs();
        this.getServletContext().setAttribute("javax.servlet.context.tempdir", (Object)dir);
        if (this.getServletContext() instanceof ApplicationContext) {
            ((ApplicationContext)this.getServletContext()).setAttributeReadOnly("javax.servlet.context.tempdir");
        }
    }

    private void setPaused(boolean paused) {
        this.paused = paused;
    }

    private boolean validateURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return false;
        }
        if (urlPattern.startsWith("*.")) {
            return urlPattern.indexOf(47) < 0;
        }
        return urlPattern.startsWith("/");
    }
}

