/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Vector;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.cluster.ClusterMemberInfo;
import org.apache.catalina.cluster.ClusterReceiver;
import org.apache.catalina.cluster.ClusterSender;
import org.apache.catalina.cluster.MulticastReceiver;
import org.apache.catalina.cluster.MulticastSender;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class StandardCluster
implements Cluster,
Lifecycle,
Runnable {
    private static final String info = "StandardCluster/1.0";
    private String threadName = "StandardCluster";
    private String clusterImpName = "StandardCluster";
    private StringManager sm = StringManager.getManager("org.apache.catalina.cluster");
    private ClusterMemberInfo localClusterMember = null;
    private Vector clusterMembers = new Vector();
    private Thread thread = null;
    private boolean threadDone = false;
    private String clusterName = null;
    private Container container = null;
    private ClusterSender clusterSender = null;
    private ClusterReceiver clusterReceiver = null;
    private int multicastPort;
    private InetAddress multicastAddress = null;
    private MulticastSocket multicastSocket = null;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private boolean started = false;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private int debug = 0;
    private int checkInterval = 60;

    public String getInfo() {
        return info;
    }

    protected String getName() {
        return this.clusterImpName;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setClusterName(String clusterName) {
        String oldClusterName = this.clusterName;
        this.clusterName = clusterName;
        this.support.firePropertyChange("clusterName", oldClusterName, this.clusterName);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public Container getContainer() {
        return this.container;
    }

    public void setMulticastPort(int multicastPort) {
        int oldMulticastPort = this.multicastPort;
        this.multicastPort = multicastPort;
        this.support.firePropertyChange("multicastPort", oldMulticastPort, this.multicastPort);
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public void setMulticastAddress(String multicastAddress) {
        try {
            InetAddress oldMulticastAddress = this.multicastAddress;
            this.multicastAddress = InetAddress.getByName(multicastAddress);
            this.support.firePropertyChange("multicastAddress", oldMulticastAddress, this.multicastAddress);
        }
        catch (UnknownHostException e) {
            this.log(this.sm.getString("standardCluster.invalidAddress", multicastAddress));
        }
    }

    public InetAddress getMulticastAddress() {
        return this.multicastAddress;
    }

    public void setCheckInterval(int checkInterval) {
        int oldCheckInterval = this.checkInterval;
        this.checkInterval = checkInterval;
        this.support.firePropertyChange("checkInterval", oldCheckInterval, this.checkInterval);
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public ClusterMemberInfo[] getRemoteClusterMembers() {
        return (ClusterMemberInfo[])this.clusterMembers.toArray();
    }

    public ClusterMemberInfo getLocalClusterMember() {
        return this.localClusterMember;
    }

    public ClusterSender getClusterSender(String senderId) {
        Logger logger = null;
        MulticastSender send = new MulticastSender(senderId, this.multicastSocket, this.multicastAddress, this.multicastPort);
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        send.setLogger(logger);
        send.setDebug(this.debug);
        if (this.debug > 1) {
            this.log(this.sm.getString("standardCluster.createSender", senderId));
        }
        return send;
    }

    public ClusterReceiver getClusterReceiver(String senderId) {
        Logger logger = null;
        MulticastReceiver recv = new MulticastReceiver(senderId, this.multicastSocket, this.multicastAddress, this.multicastPort);
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        recv.setDebug(this.debug);
        recv.setLogger(logger);
        recv.setCheckInterval(this.checkInterval);
        recv.start();
        if (this.debug > 1) {
            this.log(this.sm.getString("standardCluster.createReceiver", senderId));
        }
        return recv;
    }

    protected void log(String message) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log(this.getName() + "[" + this.container.getName() + "]: " + message);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println(this.getName() + "[" + containerName + "]: " + message);
        }
    }

    private void processReceive() {
        Object[] objs = this.clusterReceiver.getObjects();
        int i = 0;
        while (i < objs.length) {
            this.clusterMembers.add((ClusterMemberInfo)objs[i]);
            ++i;
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("standardCluster.alreadyStarted"));
        }
        try {
            this.multicastSocket = new MulticastSocket(this.multicastPort);
            if (this.multicastSocket != null && this.multicastAddress != null) {
                this.multicastSocket.joinGroup(this.multicastAddress);
                this.clusterSender = this.getClusterSender(this.getName());
                this.clusterReceiver = this.getClusterReceiver(this.getName());
                this.localClusterMember = new ClusterMemberInfo();
                this.localClusterMember.setClusterName(this.getClusterName());
                this.localClusterMember.setHostName(null);
                this.localClusterMember.setClusterInfo(this.getInfo());
                this.clusterSender.send(this.localClusterMember);
                if (this.debug > 1) {
                    this.log(this.sm.getString("standardCluster.joinGroup", this.multicastAddress));
                }
            } else {
                this.log(this.sm.getString("standardCluster.socketOrAddressNull"));
            }
        }
        catch (IOException e) {
            this.log(this.sm.getString("standardCluster.joinException", e.toString()));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            this.log(this.sm.getString("standardCluster.notStarted"));
        }
        try {
            this.multicastSocket.leaveGroup(this.multicastAddress);
            this.multicastSocket = null;
        }
        catch (IOException e) {
            this.log(this.sm.getString("standardCluster.leaveException", this.multicastAddress));
        }
        if (this.debug > 1) {
            this.log(this.sm.getString("standardCluster.leaveGroup", this.multicastAddress));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.threadStop();
    }

    public void run() {
        while (!this.threadDone) {
            this.processReceive();
            this.threadSleep();
        }
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException e) {}
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.threadName = "StandardCluster[" + this.getClusterName() + "]";
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.thread = null;
    }
}

