/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.util;

import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import java.lang.reflect.Modifier;

public class NameTool {
    private NameTool() {
    }

    public static String getFullClassName(ITypeBinding bnd) {
        return bnd.getName();
    }

    public static String getFullPackageName(IReferenceTypeBinding bnd) {
        IPackageBinding pkgBnd = bnd.getPackage();
        if (pkgBnd == null) {
            return "";
        }
        String[] comp = pkgBnd.getNameComponents();
        StringBuffer buf = new StringBuffer(comp.length);
        int i = 0;
        while (i < comp.length) {
            buf.append((i > 0 ? "." : "") + comp[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String toDotNotation(String[] components) {
        StringBuffer buf = new StringBuffer(components.length);
        int i = 0;
        while (i < components.length) {
            buf.append((i > 0 ? "." : "") + components[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String getHumanReadableModifiers(int modifiers) {
        StringBuffer mods = new StringBuffer();
        if (Modifier.isPublic(modifiers)) {
            mods.append("public ");
        }
        if (Modifier.isPrivate(modifiers)) {
            mods.append("private ");
        }
        if (Modifier.isProtected(modifiers)) {
            mods.append("protected ");
        }
        if (Modifier.isStatic(modifiers)) {
            mods.append("static ");
        }
        if (Modifier.isFinal(modifiers)) {
            mods.append("final ");
        }
        if (Modifier.isSynchronized(modifiers)) {
            mods.append("synchronized ");
        }
        if (Modifier.isAbstract(modifiers)) {
            mods.append("abstract ");
        }
        if (Modifier.isNative(modifiers)) {
            mods.append("native ");
        }
        if (Modifier.isTransient(modifiers)) {
            mods.append("transient ");
        }
        if (Modifier.isVolatile(modifiers)) {
            mods.append("volatile ");
        }
        if (Modifier.isStrict(modifiers)) {
            mods.append("strictfp ");
        }
        return mods.toString();
    }
}

