/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.util;

import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.util.NameTool;

public class InheritanceTool {
    private InheritanceTool() {
    }

    public static boolean bndImplements(IReferenceTypeBinding bnd, String interfaceName) {
        if (bnd == null || interfaceName == null) {
            return false;
        }
        if (InheritanceTool.bindingIsIntf(bnd, interfaceName)) {
            return true;
        }
        IReferenceTypeBinding[] intfs = bnd.getInterfaces();
        if (intfs != null) {
            int i = 0;
            while (i < intfs.length) {
                if (InheritanceTool.bndImplements(intfs[i], interfaceName)) {
                    return true;
                }
                ++i;
            }
        }
        if (bnd.getSuperclass() != null) {
            return InheritanceTool.bndImplements(bnd.getSuperclass(), interfaceName);
        }
        return false;
    }

    public static boolean bndExtends(IReferenceTypeBinding bnd, String superClassName) {
        if (bnd == null || superClassName == null) {
            return false;
        }
        if (InheritanceTool.bindingIsClass(bnd, superClassName)) {
            return true;
        }
        if (bnd.getSuperclass() != null) {
            return InheritanceTool.bndExtends(bnd.getSuperclass(), superClassName);
        }
        return false;
    }

    private static boolean bindingIsClass(IReferenceTypeBinding bnd, String className) {
        return bnd.isClass() && className.equals(NameTool.getFullClassName(bnd));
    }

    private static boolean bindingIsIntf(IReferenceTypeBinding bnd, String interfaceName) {
        return bnd.isInterface() && interfaceName.equals(NameTool.getFullClassName(bnd));
    }
}

