/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.MethodBinding;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SourceContent;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.Wrapper;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperConstructorInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class SuperConstructorInvocation
implements ISuperConstructorInvocation {
    private ExplicitConstructorCall cc;
    private BlockScope scope;
    private SourceContent source;
    private IExpression expr;
    private List args;
    private IComment[] comments;
    private IComment endOfLineComment;
    private boolean commentParsed = false;

    public SuperConstructorInvocation(ExplicitConstructorCall cc, BlockScope scope, SourceContent source) {
        this.cc = cc;
        this.scope = scope;
        this.source = source;
    }

    public int getNodeType() {
        return 44;
    }

    public IExpression getExpression() {
        if (this.expr == null) {
            this.expr = Wrapper.wrapExpression(this.cc.qualification, this.scope, this.source);
        }
        return this.expr;
    }

    public List arguments() {
        if (this.args == null) {
            this.args = new Vector();
            Expression[] arguments = this.cc.arguments;
            if (arguments != null) {
                int i = 0;
                while (i < arguments.length) {
                    this.args.add(Wrapper.wrapExpression(arguments[i], this.scope, this.source));
                    ++i;
                }
            }
        }
        return this.args;
    }

    public IMethodBinding resolveConstructorBinding() {
        org.eclipse.jdt.internal.compiler.lookup.MethodBinding binding = this.cc.binding;
        if (binding == null) {
            return null;
        }
        return new MethodBinding(binding);
    }

    public int getStartPosition() {
        return this.cc.sourceStart;
    }

    public IComment[] getComments() {
        if (this.comments == null) {
            this.comments = this.source.getBlockComment(this.cc.sourceEnd + 1);
        }
        return this.comments;
    }

    public IComment getEndOfLineComment() {
        if (!this.commentParsed) {
            this.endOfLineComment = this.source.getEndOfLineComment(this.cc.sourceEnd + 1);
            this.commentParsed = true;
        }
        return this.endOfLineComment;
    }

    public void traverse(IVisitor visitor) {
        if (visitor.visit(this)) {
            List arguments;
            IExpression expression = this.getExpression();
            if (expression != null) {
                expression.traverse(visitor);
            }
            if ((arguments = this.arguments()) != null) {
                Iterator iterator = arguments.iterator();
                while (iterator.hasNext()) {
                    ((Traversable)iterator.next()).traverse(visitor);
                }
            }
        }
        visitor.endVisit(this);
    }
}

