/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.Comment;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.Javadoc;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IJavadoc;
import java.util.ArrayList;

public class SourceContent {
    private char[] src;
    private int[] lineSeparators;

    public SourceContent(char[] src, int[] lineSeparators) {
        this.src = src;
        this.lineSeparators = lineSeparators;
    }

    public IComment getEndOfLineComment(int initialPosition) {
        int lineEnd = this.lineEnd(initialPosition);
        int currentIndex = initialPosition;
        while (currentIndex < lineEnd) {
            if (this.src[currentIndex] == '/' && this.src[currentIndex + 1] == '/') {
                return new Comment(0, new String(this.src, currentIndex, lineEnd - currentIndex - 1), currentIndex);
            }
            ++currentIndex;
        }
        while (Character.isWhitespace(this.src[currentIndex])) {
            ++currentIndex;
        }
        if (this.src[currentIndex] == '/' && this.src[currentIndex + 1] == '/') {
            return new Comment(0, new String(this.src, currentIndex, this.lineEnd(currentIndex) - currentIndex - 1), currentIndex);
        }
        return null;
    }

    public IComment[] getBlockComment(int initialPosition) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        int start = -1;
        int currentPosition = initialPosition + 1;
        block0: while (true) {
            if (Character.isWhitespace(this.src[currentPosition])) {
                ++currentPosition;
                continue;
            }
            if (this.src[currentPosition] != '/' || this.src[currentPosition + 1] != '*') break;
            start = currentPosition;
            currentPosition += 2;
            while (true) {
                if (this.src[currentPosition] == '*' && this.src[currentPosition + 1] == '/') {
                    comments.add(new Comment(1, new String(this.src, start, currentPosition + 2 - start), start));
                    currentPosition += 2;
                    continue block0;
                }
                ++currentPosition;
            }
            break;
        }
        return comments.toArray(new IComment[comments.size()]);
    }

    public IJavadoc getJavadoc(int initialPosition) {
        int start = -1;
        int currentPosition = initialPosition;
        while (Character.isWhitespace(this.src[currentPosition++])) {
        }
        if (this.src[currentPosition - 1] == '/' && this.src[currentPosition] == '*' && this.src[currentPosition + 1] == '*') {
            start = currentPosition - 1;
            currentPosition += 2;
            while (true) {
                if (this.src[currentPosition] == '*' && this.src[currentPosition + 1] == '/') {
                    return new Javadoc(new String(this.src, start, currentPosition + 2 - start), start);
                }
                ++currentPosition;
            }
        }
        return null;
    }

    public int lineNumber(int position) {
        if (position < 0 || position >= this.src.length || this.lineSeparators == null) {
            return -1;
        }
        int i = 0;
        while (i < this.lineSeparators.length) {
            if (position < this.lineSeparators[i] + 1) {
                return i + 1;
            }
            ++i;
        }
        return this.lineSeparators.length + 1;
    }

    public int columnNumber(int position) {
        if (position < 0 || position >= this.src.length || this.lineSeparators == null) {
            return -1;
        }
        int currentOffset = 0;
        int i = 0;
        while (i < this.lineSeparators.length) {
            if (position < this.lineSeparators[i] + 1) {
                return position - currentOffset + 1;
            }
            currentOffset = this.lineSeparators[i] + 1;
            ++i;
        }
        return position - currentOffset + 1;
    }

    private int lineEnd(int startPos) {
        if (startPos < 0 || startPos >= this.src.length || this.lineSeparators == null) {
            return -1;
        }
        if (this.lineSeparators.length == 0) {
            return this.src.length - 1;
        }
        int i = 0;
        while (i < this.lineSeparators.length) {
            if (this.lineSeparators[i] >= startPos) {
                return this.lineSeparators[i];
            }
            ++i;
        }
        return -1;
    }

    public int getLineCount() {
        return this.lineSeparators == null ? 1 : this.lineSeparators.length + 1;
    }
}

