/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.PackageNameFromStrings;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.QualifiedName;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SimpleNameFromString;
import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IQualifier;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import java.util.Vector;

public class QualifiedNameFromTypeBinding
extends QualifiedName {
    private ReferenceTypeBinding tb;
    private int position;
    private IQualifier qual;

    public QualifiedNameFromTypeBinding(ReferenceTypeBinding tb, int position) {
        this.tb = tb;
        this.position = position;
    }

    public int getStartPosition() {
        return this.position;
    }

    public IQualifier getQualifier() {
        if (this.qual == null) {
            String[] components = this.getNameComponents();
            Object qualifierBinding = null;
            ReferenceTypeBinding outerClass = (ReferenceTypeBinding)this.tb.getDeclaringClass();
            if (outerClass != null) {
                this.qual = components.length == 2 ? new SimpleNameFromString(components[0], this.getStartPosition(), outerClass) : new QualifiedNameFromTypeBinding(outerClass, this.getStartPosition());
            } else {
                String[] qualifierComponents = new String[components.length - 1];
                int i = 0;
                while (i < qualifierComponents.length) {
                    qualifierComponents[i] = components[i];
                    ++i;
                }
                this.qual = new PackageNameFromStrings(qualifierComponents, this.getStartPosition());
            }
        }
        return this.qual;
    }

    public String getName() {
        return this.tb.getName();
    }

    public String[] getNameComponents() {
        Vector<String> nameComponents = new Vector<String>();
        int index = 0;
        IPackageBinding pack = this.tb.getPackage();
        if (pack != null) {
            String[] packNameComponents = pack.getNameComponents();
            int i = 0;
            while (i < packNameComponents.length) {
                nameComponents.insertElementAt(packNameComponents[i], i);
                ++i;
            }
            index = packNameComponents.length;
        }
        IReferenceTypeBinding currentClass = this.tb;
        while (currentClass.getDeclaringClass() != null) {
            nameComponents.insertElementAt(currentClass.getDeclaringClass().getName(), index);
            currentClass = currentClass.getDeclaringClass();
        }
        nameComponents.add(this.tb.getName());
        return nameComponents.toArray(new String[nameComponents.size()]);
    }

    public IBinding resolveBinding() {
        return this.tb;
    }

    public ITypeBinding resolveTypeBinding() {
        return this.tb;
    }
}

