/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SourceContent;
import com.sap.tc.jtools.jlint.jom.interfaces.IBreakStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import org.eclipse.jdt.internal.compiler.ast.Break;

public class BreakStatement
implements IBreakStatement {
    private Break bs;
    private String label;
    private SourceContent source;
    private IComment[] comments;
    private IComment endOfLineComment;
    private boolean commentParsed = false;

    public BreakStatement(Break bs, SourceContent source) {
        this.bs = bs;
        this.source = source;
        if (bs.label != null) {
            this.label = new String(bs.label);
        }
    }

    public int getNodeType() {
        return 10;
    }

    public String getLabel() {
        return this.label;
    }

    public int getStartPosition() {
        return this.bs.sourceStart;
    }

    public void traverse(IVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public IComment[] getComments() {
        if (this.comments == null) {
            this.comments = this.source.getBlockComment(this.bs.sourceEnd + 1);
        }
        return this.comments;
    }

    public IComment getEndOfLineComment() {
        if (!this.commentParsed) {
            this.endOfLineComment = this.source.getEndOfLineComment(this.bs.sourceEnd + 1);
            this.commentParsed = true;
        }
        return this.endOfLineComment;
    }
}

