/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SourceContent;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.Wrapper;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class Block
implements IBlock {
    private Statement[] statements;
    private int startPosition;
    private int endPosition;
    private BlockScope scope;
    private SourceContent source;
    private List statementList;
    private IComment[] comments;
    private IComment endOfLineComment;
    private boolean commentParsed = false;

    public Block(Statement[] statements, int startPosition, int endPosition, BlockScope scope, SourceContent source) {
        this.statements = statements == null ? new Statement[0] : statements;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.scope = scope;
        this.source = source;
    }

    public Block(org.eclipse.jdt.internal.compiler.ast.Block block, SourceContent source) {
        this.statements = block.statements;
        if (this.statements == null) {
            this.statements = new Statement[0];
        }
        this.startPosition = block.sourceStart;
        this.endPosition = block.sourceEnd;
        this.scope = block.scope;
        this.source = source;
    }

    public int getNodeType() {
        return 8;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public List statements() {
        if (this.statementList == null) {
            this.statementList = new ArrayList(this.statements.length);
            int i = 0;
            while (i < this.statements.length) {
                IStatement stmt = Wrapper.wrapStatement(this.statements[i], this.scope, this.source);
                this.statementList.add(stmt);
                ++i;
            }
        }
        return this.statementList;
    }

    public void traverse(IVisitor visitor) {
        if (visitor.visit(this)) {
            Iterator iter = this.statements().iterator();
            while (iter.hasNext()) {
                ((Traversable)iter.next()).traverse(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public IComment[] getComments() {
        if (this.comments == null) {
            this.comments = this.source.getBlockComment(this.endPosition);
        }
        return this.comments;
    }

    public IComment getEndOfLineComment() {
        if (!this.commentParsed) {
            this.endOfLineComment = this.source.getEndOfLineComment(this.startPosition);
            this.commentParsed = true;
        }
        return this.endOfLineComment;
    }
}

