/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ArrayType;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ArrayTypeBinding;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.BindingFactory;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayTypeFromTypeReference
extends ArrayType {
    private TypeReference at;
    private int dim;
    private int extraDims;

    public ArrayTypeFromTypeReference(ArrayTypeReference at) {
        this((TypeReference)at, 0);
    }

    public ArrayTypeFromTypeReference(ArrayQualifiedTypeReference at) {
        this((TypeReference)at, 0);
    }

    public ArrayTypeFromTypeReference(TypeReference at, int extraDims) {
        this.at = at;
        if (at instanceof ArrayTypeReference) {
            this.dim = ((ArrayTypeReference)at).dimensions;
        } else if (at instanceof ArrayQualifiedTypeReference) {
            this.dim = ((ArrayQualifiedTypeReference)at).dimensions();
        }
        this.extraDims = extraDims;
    }

    public ITypeBinding getComponentType() {
        if (this.extraDims == 1) {
            return BindingFactory.getTypeBinding(this.at.resolvedType);
        }
        if (this.extraDims > 1) {
            return new ArrayTypeBinding(this.at.resolvedType, this.extraDims - 1);
        }
        ArrayBinding binding = (ArrayBinding)this.at.resolvedType;
        if (binding == null) {
            return null;
        }
        if (this.dim == 1) {
            return BindingFactory.getTypeBinding(binding.leafComponentType);
        }
        return new ArrayTypeBinding(binding.leafComponentType, this.dim - 1);
    }

    public ITypeBinding getElementType() {
        if (this.at.dimensions() == 0) {
            return BindingFactory.getTypeBinding(this.at.resolvedType);
        }
        ArrayBinding binding = (ArrayBinding)this.at.resolvedType;
        if (binding == null) {
            return null;
        }
        TypeBinding tb = binding.leafComponentType();
        return BindingFactory.getTypeBinding(tb);
    }

    public int getDimensions() {
        return this.dim + this.extraDims;
    }

    public ITypeBinding resolveBinding() {
        TypeBinding tb = this.at.resolvedType;
        return BindingFactory.getTypeBinding(tb);
    }

    public int getStartPosition() {
        return this.at.sourceStart;
    }
}

