/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom;

import com.sap.tc.jtools.jlint.java.flow.BooleanFlowLineMethod;
import com.sap.tc.jtools.jlint.java.flow.Flow;
import com.sap.tc.jtools.jlint.java.flow.FlowInterface;
import com.sap.tc.jtools.jlint.java.flow.FlowLine;
import com.sap.tc.jtools.jlint.java.flow.FlowLineManipulator;
import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import java.util.HashMap;
import java.util.Map;

public abstract class JomTestVisitorWithFlow
extends JomTestVisitor {
    private Map flowPre = new HashMap();
    private Map flowPost = new HashMap();
    private FlowInterface currentFlow = new Flow();

    public abstract boolean visitExternal(IIfStatement var1);

    public final boolean visit(IIfStatement stmt) {
        this.flowPre.put(stmt, this.currentFlow);
        boolean out = this.visitExternal(stmt);
        this.flowPost.put(stmt.getExpression(), this.currentFlow);
        return out;
    }

    public final void endVisit(IBlock block) {
        boolean out = this.endVisitExternal(block);
        this.flowPost.put(block, this.currentFlow);
    }

    private boolean endVisitExternal(IBlock block) {
        return true;
    }

    public abstract void endVisitExternal(IIfStatement var1);

    public final void endVisit(IIfStatement stmt) {
        IStatement thenStmt = stmt.getThenStatement();
        FlowInterface outThen = (FlowInterface)this.flowPost.get(thenStmt);
        if (stmt.getElseStatement() != null) {
            outThen.addFlowLines((FlowInterface)this.flowPost.get(stmt.getElseStatement()));
            this.currentFlow = outThen;
        } else {
            outThen.addFlowLines((FlowInterface)this.flowPost.get(stmt.getExpression()));
            this.currentFlow = outThen;
        }
        this.endVisitExternal(stmt);
    }

    public final void manipulateFlow(String type, FlowLineManipulator manipulator) {
        FlowInterface clone = (FlowInterface)this.currentFlow.clone();
        this.currentFlow = clone.manipulateFlowLine(type, manipulator);
    }

    public final void addFlowLine(String type, FlowLine flowLine) {
        this.currentFlow.addFlowLine(type, flowLine);
    }

    public final boolean check(String type, BooleanFlowLineMethod checkMethod) {
        return this.currentFlow.isAlwaysTrue(type, checkMethod);
    }

    public final void resetFlow(String type) {
        this.currentFlow.resetFlowLines(type);
    }
}

