/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom;

import com.sap.tc.jtools.jlint.ProcessorUnitInterface;
import com.sap.tc.jtools.jlint.RequirementInterface;
import com.sap.tc.jtools.jlint.Result;
import com.sap.tc.jtools.jlint.TestProcessorInterface;
import com.sap.tc.jtools.jlint.exceptions.ExecutionException;
import com.sap.tc.jtools.jlint.java.JavaFileArrayTestObject;
import com.sap.tc.jtools.jlint.jdt.ClasspathLocation;
import com.sap.tc.jtools.jlint.jdt.MyTypeRequestor;
import com.sap.tc.jtools.jlint.jdt.NameEnvironment;
import com.sap.tc.jtools.jlint.jom.JomSyntaxTreeRequirement;
import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.JomVisitor;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.BindingFactory;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.exceptions.CancelJobException;
import com.sap.tc.jtools.jtci.interfaces.Listener;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;

public class JomProjectVisitorProcessor
implements TestProcessorInterface {
    public static final String CLASS_NAME = "com.sap.tc.jtools.jlint.jom.JomProjectVisitorProcessor";
    public static final String ROLE_JOM_VISITOR = "jom visitor";
    public static final String REQUIREMENT_JOM_SYNTAX_TREE = "jom syntax tree";
    public static final String JST_PAR_FILENAME = "filename";
    public static final String SEPARATOR = "/";
    private JomVisitor rootVisitor = new JomVisitor();
    private Vector testVisitors = new Vector();
    private Vector errors = new Vector();
    private ParameterInterface[] parameter = new ParameterInterface[1];
    private ICompilationUnit[] syntaxTrees = null;
    protected ClasspathLocation[] searchPaths;
    private JavaFileArrayTestObject testObject;
    private LookupEnvironment lue;
    private INameEnvironment environment;
    private Listener listener;

    public JomProjectVisitorProcessor(JavaFileArrayTestObject testObject, ClasspathLocation[] searchPaths) {
        this.testObject = testObject;
        this.parameter[0] = ParameterTool.createParameter((String)"Target file list", (String)"STRING[]", (Object)testObject.getFileNames());
        this.searchPaths = searchPaths;
        this.environment = new NameEnvironment(searchPaths);
        MyTypeRequestor typeRequestor = new MyTypeRequestor();
        typeRequestor.lue = this.lue = new LookupEnvironment((ITypeRequestor)typeRequestor, new CompilerOptions(), null, this.environment);
    }

    public TestObject getTestObject() {
        return this.testObject;
    }

    public String getName() {
        return CLASS_NAME;
    }

    public ParameterInterface[] getParameters() {
        return this.parameter;
    }

    public Object getData() {
        return null;
    }

    public ResultInterface[] getErrors() {
        Vector<Object> resultVector = new Vector<Object>();
        Iterator tests = ((AbstractList)this.testVisitors).iterator();
        while (tests.hasNext()) {
            List res = ((JomTestVisitor)tests.next()).getErrorList();
            if (res == null) continue;
            Iterator iter = res.iterator();
            while (iter.hasNext()) {
                Result element = (Result)iter.next();
                resultVector.add(element);
            }
        }
        Vector res2 = this.rootVisitor.getErrors();
        int i = 0;
        while (i < res2.size()) {
            resultVector.add(res2.elementAt(i));
            ++i;
        }
        Iterator iter = ((AbstractList)this.errors).iterator();
        while (iter.hasNext()) {
            resultVector.add((Result)iter.next());
        }
        return resultVector.toArray(new Result[resultVector.size()]);
    }

    public void addProcessorUnit(ProcessorUnitInterface processorUnit, String role) {
        if (!role.equals(ROLE_JOM_VISITOR)) {
            return;
        }
        this.testVisitors.add(processorUnit);
    }

    public void execute() throws ExecutionException {
        Iterator tests = ((AbstractList)this.testVisitors).iterator();
        while (tests.hasNext()) {
            this.rootVisitor.addVisitor((ITestVisitor)tests.next());
        }
        this.lue.completeTypeBindings();
        int i = 0;
        while (i < this.syntaxTrees.length) {
            try {
                this.syntaxTrees[i].traverse(this.rootVisitor);
            }
            catch (Exception e) {
                String baseDir = this.testObject.getBaseDir();
                String fileName = baseDir == null ? this.syntaxTrees[i].getFileName() : this.syntaxTrees[i].getFileName().substring(baseDir.length() + 1);
                StringWriter stackTraceWriter = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTraceWriter));
                Properties p = new Properties();
                p.setProperty("EXCEPTION", stackTraceWriter.toString());
                p.setProperty("__MSG_KEY", "syntax_error");
                this.errors.add(new Result(this.getName(), this.testObject.getType(), this.testObject.getID(), JavaFileArrayTestObject.getPosition(fileName), 0, "syntax_error", p));
            }
            if (this.listener != null) {
                this.listener.processedTestObjectComponent();
                if (this.listener.isCanceled()) {
                    throw new CancelJobException();
                }
            }
            ++i;
        }
        BindingFactory.clearCache();
    }

    public RequirementInterface[] getRequirements() {
        String[] files = this.testObject.getFileNames();
        RequirementInterface[] reqs = new RequirementInterface[files.length];
        int i = 0;
        while (i < reqs.length) {
            String currentSource = this.testObject.getBaseDir() == null ? files[i] : this.testObject.getBaseDir() + SEPARATOR + files[i];
            reqs[i] = new JomSyntaxTreeRequirement(currentSource, this.searchPaths, this.lue, this.environment);
            ++i;
        }
        return reqs;
    }

    public void setPrerequisites(Object[] reqs) {
        this.syntaxTrees = new ICompilationUnit[reqs.length];
        int i = 0;
        while (i < reqs.length) {
            this.syntaxTrees[i] = (ICompilationUnit)reqs[i];
            ++i;
        }
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }
}

