/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jdt;

import com.sap.tc.jtools.jlint.jdt.ClasspathDirectory;
import com.sap.tc.jtools.jlint.jdt.JdtSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

class ClasspathMultiDirectory
extends ClasspathDirectory {
    String sourcePath;

    ClasspathMultiDirectory(String sourcePath, String binaryPath) {
        super(binaryPath);
        this.sourcePath = sourcePath;
        if (!sourcePath.endsWith("/")) {
            this.sourcePath = this.sourcePath + "/";
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathMultiDirectory)) {
            return false;
        }
        ClasspathMultiDirectory md = (ClasspathMultiDirectory)o;
        return this.binaryPath.equals(md.binaryPath) && this.sourcePath.equals(md.sourcePath);
    }

    NameEnvironmentAnswer findSourceFile(String qualifiedSourceFileName, String qualifiedPackageName, char[] typeName, String[] additionalSourceFilenames) {
        String fullSourceName = this.sourcePath + qualifiedSourceFileName;
        File f = new File(fullSourceName);
        if (f.exists()) {
            try {
                if (f.getCanonicalPath().replace('\\', '/').endsWith(qualifiedSourceFileName)) {
                    return new NameEnvironmentAnswer((ICompilationUnit)new JdtSource(new FileReader(fullSourceName), fullSourceName));
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        int i = 0;
        int l = additionalSourceFilenames.length;
        while (i < l) {
            if (fullSourceName.equals(additionalSourceFilenames[i])) {
                try {
                    return new NameEnvironmentAnswer((ICompilationUnit)new JdtSource(new FileReader(fullSourceName), fullSourceName));
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return "Source classpath directory " + this.sourcePath + " with binary directory " + this.binaryPath;
    }
}

