/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jdt;

import com.sap.tc.jtools.jlint.jdt.ClasspathLocation;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

class ClasspathJar
extends ClasspathLocation {
    String zipFilename;
    ZipFile zipFile;
    HashMap packageCache;

    ClasspathJar(String zipFilename) {
        this.zipFilename = zipFilename;
        this.zipFile = null;
        this.packageCache = null;
    }

    void cleanup() {
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.zipFile = null;
        }
        this.packageCache = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathJar)) {
            return false;
        }
        return this.zipFilename.equals(((ClasspathJar)o).zipFilename);
    }

    NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        if (!this.isPackage(qualifiedPackageName)) {
            return null;
        }
        try {
            ClassFileReader reader = ClassFileReader.read((ZipFile)this.zipFile, (String)qualifiedBinaryFileName);
            if (reader != null) {
                return new NameEnvironmentAnswer((IBinaryType)reader);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    boolean isPackage(String qualifiedPackageName) {
        if (this.packageCache != null) {
            return this.packageCache.containsKey(qualifiedPackageName);
        }
        this.packageCache = new HashMap();
        this.packageCache.put("", "");
        try {
            this.zipFile = new ZipFile(this.zipFilename);
            Enumeration<? extends ZipEntry> e = this.zipFile.entries();
            block2: while (e.hasMoreElements()) {
                String fileName = e.nextElement().getName();
                int last = fileName.lastIndexOf(47);
                while (last > 0) {
                    String packageName = fileName.substring(0, last);
                    if (this.packageCache.containsKey(packageName)) continue block2;
                    this.packageCache.put(packageName, packageName);
                    last = packageName.lastIndexOf(47);
                }
            }
            return this.packageCache.containsKey(qualifiedPackageName);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String toString() {
        return "Classpath jar file " + this.zipFilename;
    }
}

