/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jdt;

import com.sap.tc.jtools.jlint.jdt.ClasspathLocation;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

class ClasspathDirectory
extends ClasspathLocation {
    String binaryPath;
    HashMap directoryCache;
    String[] missingPackageHolder = new String[1];

    ClasspathDirectory(String binaryPath) {
        this.binaryPath = binaryPath;
        if (!binaryPath.endsWith("/")) {
            this.binaryPath = this.binaryPath + "/";
        }
        this.directoryCache = new HashMap();
    }

    void cleanup() {
        this.directoryCache = new HashMap();
    }

    String[] directoryList(String qualifiedPackageName) {
        String[] dirList = (String[])this.directoryCache.get(qualifiedPackageName);
        if (dirList == this.missingPackageHolder) {
            return null;
        }
        if (dirList != null) {
            return dirList;
        }
        File dir = new File(this.binaryPath + qualifiedPackageName);
        if (dir != null && dir.isDirectory()) {
            String parentPackage;
            String packageName;
            int index = qualifiedPackageName.length();
            int last = qualifiedPackageName.lastIndexOf(47);
            while (--index > last && !Character.isUpperCase(qualifiedPackageName.charAt(index))) {
            }
            if (index <= last || !(last != -1 ? !this.doesFileExist(packageName = qualifiedPackageName.substring(last + 1), parentPackage = qualifiedPackageName.substring(0, last)) : !this.doesFileExist(qualifiedPackageName, ""))) {
                dirList = dir.list();
                if (dirList == null) {
                    dirList = new String[]{};
                }
                this.directoryCache.put(qualifiedPackageName, dirList);
                return dirList;
            }
        }
        this.directoryCache.put(qualifiedPackageName, this.missingPackageHolder);
        return null;
    }

    boolean doesFileExist(String fileName, String qualifiedPackageName) {
        String[] dirList = this.directoryList(qualifiedPackageName);
        if (dirList == null) {
            return false;
        }
        int i = dirList.length;
        while (--i >= 0) {
            if (!fileName.equals(dirList[i])) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathDirectory)) {
            return false;
        }
        return this.binaryPath.equals(((ClasspathDirectory)o).binaryPath);
    }

    NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        if (!this.doesFileExist(binaryFileName, qualifiedPackageName)) {
            return null;
        }
        try {
            ClassFileReader reader = ClassFileReader.read((String)(this.binaryPath + qualifiedBinaryFileName));
            if (reader != null) {
                return new NameEnvironmentAnswer((IBinaryType)reader);
            }
        }
        catch (ClassFormatException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    boolean isPackage(String qualifiedPackageName) {
        return this.directoryList(qualifiedPackageName) != null;
    }

    void reset() {
        this.directoryCache = new HashMap();
    }

    public String toString() {
        return "Binary classpath directory " + this.binaryPath;
    }
}

