/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.javaelements;

import com.sap.tc.jtools.jlint.javaelements.ClassInterface;
import com.sap.tc.jtools.jlint.javaelements.MethodInterface;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;

public class Method
implements MethodInterface,
Persistable {
    private ClassInterface cls;
    private String methodName;
    private boolean isConstructor;
    private int modifiers;
    private String returnType;
    private String[] parameterTypes;
    private String[] exceptionTypes;

    public Method(String methodName, boolean isConstructor, int modifiers, String returnType, String[] parameterTypes, String[] exceptions) {
        this.methodName = methodName;
        this.isConstructor = isConstructor;
        this.modifiers = modifiers;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.exceptionTypes = exceptions;
    }

    public Method(StructureTree tree, ClassInterface cls) throws BadTreeException {
        if (tree.getHeader().getTag().equals("METHOD")) {
            this.isConstructor = false;
            this.returnType = tree.getParameter("RETURN_TYPE");
        } else if (tree.getHeader().getTag().equals("CONSTRUCTOR")) {
            this.isConstructor = true;
        } else {
            throw new BadTreeException("wrong tag in method object: " + tree.getHeader().getTag());
        }
        this.cls = cls;
        this.methodName = tree.getParameter("NAME");
        this.modifiers = Integer.parseInt(tree.getParameter("MODIFIERS"));
        StructureTree[] parameterTrees = tree.getChildren("PARAMETER");
        this.parameterTypes = new String[parameterTrees.length];
        int i = 0;
        while (i < parameterTrees.length) {
            this.parameterTypes[i] = parameterTrees[i].getText();
            ++i;
        }
        StructureTree[] exceptionTrees = tree.getChildren("EXCEPTION");
        this.exceptionTypes = new String[exceptionTrees.length];
        int i2 = 0;
        while (i2 < exceptionTrees.length) {
            this.exceptionTypes[i2] = exceptionTrees[i2].getText();
            ++i2;
        }
    }

    public StructureTree toStructureTree() {
        String methodOrConstructor = this.isConstructor ? "CONSTRUCTOR" : "METHOD";
        Header header = new Header(methodOrConstructor);
        header.setParameter("MODIFIERS", Integer.toString(this.modifiers));
        if (!this.isConstructor) {
            header.setParameter("RETURN_TYPE", this.returnType);
            header.setParameter("NAME", this.getMethodName());
        }
        StructureTree tree = new StructureTree(header);
        int i = 0;
        while (i < this.parameterTypes.length) {
            StructureTree parTree = new StructureTree(new Header("PARAMETER"));
            parTree.setText(this.parameterTypes[i]);
            tree.addNewChild(parTree);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.exceptionTypes.length) {
            StructureTree excTree = new StructureTree(new Header("EXCEPTION"));
            excTree.setText(this.exceptionTypes[i2]);
            tree.addNewChild(excTree);
            ++i2;
        }
        return tree;
    }

    public String[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public String getMethodName() {
        if (this.isConstructor) {
            return null;
        }
        return this.methodName;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public ClassInterface getDefiningClass() {
        return this.cls;
    }

    public void setDefiningClass(ClassInterface cls) {
        this.cls = cls;
    }
}

