/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.javaelements;

import com.sap.tc.jtools.jlint.javaelements.ClassInterface;
import com.sap.tc.jtools.jlint.javaelements.FieldInterface;
import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;

public class Field
implements FieldInterface,
Persistable {
    private ClassInterface cls;
    private String name;
    private int modifiers;
    private String type;
    private String value;

    public Field(String name, int modifiers, String type, String value) {
        this.name = name;
        this.modifiers = modifiers;
        this.type = type;
        this.value = value;
    }

    public Field(String name, int modifiers, String type) {
        this.name = name;
        this.modifiers = modifiers;
        this.type = type;
    }

    public Field(StructureTree tree, ClassInterface definingClass) {
        this.name = tree.getParameter("NAME");
        this.modifiers = Integer.parseInt(tree.getParameter("MODIFIERS"));
        this.type = tree.getParameter("TYPE");
        String myValue = tree.getParameter("VALUE");
        if ("char".equals(this.type) && myValue != null) {
            char c = (char)Integer.parseInt(myValue);
            myValue = new String(new char[]{c});
        }
        this.value = myValue;
        this.cls = definingClass;
    }

    public StructureTree toStructureTree() {
        Header header = new Header("FIELD");
        header.setParameter("MODIFIERS", Integer.toString(this.modifiers));
        header.setParameter("NAME", this.name);
        header.setParameter("TYPE", this.type);
        if (this.value != null) {
            if ("char".equals(this.type)) {
                char[] charArray = this.value.toCharArray();
                if (charArray.length > 0) {
                    String encodedValue = String.valueOf((int)charArray[0]);
                    header.setParameter("VALUE", encodedValue);
                }
            } else {
                header.setParameter("VALUE", this.value);
            }
        }
        return new StructureTree(header);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public ClassInterface getDefiningClass() {
        return this.cls;
    }

    public void setDefiningClass(ClassInterface cls) {
        this.cls = cls;
    }
}

