/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.javadiff.bytecode;

import com.sap.tc.jtools.jlint.javadiff.bytecode.IllegalClassFormat;
import com.sap.tc.jtools.jlint.javaelements.Class;
import com.sap.tc.jtools.jlint.javaelements.Field;
import com.sap.tc.jtools.jlint.javaelements.Method;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class BinaryParser {
    private static final int ACC_INTERFACE = 512;
    private String className;
    private String packageName;
    private String superTypeName;
    private String[] interfaceNames;
    private int constant_pool_count;
    private ConstantPoolEntry[] constant_pool;
    private int access_flags;
    private int this_class;
    private int super_class;
    private int interfaces_count;
    private int[] interfaces;
    private int fields_count;
    private FieldOrMethodInfo[] field_info;
    private int methods_count;
    private FieldOrMethodInfo[] method_info;
    private int attributes_count;
    private AttributeInfo[] attribute_info;
    private Vector methods = new Vector();
    private Vector fields = new Vector();
    private Vector innerClasses = new Vector();
    static final String[] entryTypes = new String[]{"unused", "UTF8", "unused", "integer", "float", "long", "double", "class", "string", "fieldref", "methodref", "interfacemethodref", "nameandtype"};

    public Class parseClass(byte[] classFile) {
        return this.parseClass(classFile, new Class[0]);
    }

    public Class parseClass(byte[] classFile, Class[] innerClasses) {
        int offset = 0;
        this.parseHeader(classFile);
        offset = this.parseConstantPool(classFile);
        this.access_flags = BinaryParser.bytesToUShort(classFile, offset);
        this.this_class = BinaryParser.bytesToUShort(classFile, offset += 2);
        this.super_class = BinaryParser.bytesToUShort(classFile, offset += 2);
        this.interfaces_count = BinaryParser.bytesToUShort(classFile, offset += 2);
        offset += 2;
        this.interfaces = new int[this.interfaces_count];
        int i = 0;
        while (i < this.interfaces_count) {
            this.interfaces[i] = BinaryParser.bytesToUShort(classFile, offset);
            offset += 2;
            ++i;
        }
        this.fields_count = BinaryParser.bytesToUShort(classFile, offset);
        offset += 2;
        this.field_info = new FieldOrMethodInfo[this.fields_count];
        int i2 = 0;
        while (i2 < this.fields_count) {
            this.field_info[i2] = new FieldOrMethodInfo(classFile, offset);
            offset += this.field_info[i2].getSize();
            ++i2;
        }
        this.methods_count = BinaryParser.bytesToInt(classFile, offset, 2);
        offset += 2;
        this.method_info = new FieldOrMethodInfo[this.methods_count];
        int i3 = 0;
        while (i3 < this.methods_count) {
            this.method_info[i3] = new FieldOrMethodInfo(classFile, offset);
            offset += this.method_info[i3].getSize();
            ++i3;
        }
        this.attributes_count = BinaryParser.bytesToInt(classFile, offset, 2);
        offset += 2;
        this.attribute_info = new AttributeInfo[this.attributes_count];
        int i4 = 0;
        while (i4 < this.attributes_count) {
            this.attribute_info[i4] = new AttributeInfo(classFile, offset).unwrap();
            offset += this.attribute_info[i4].getSize();
            ++i4;
        }
        this.resolveClass();
        return new Class(this.packageName, this.className, this.superTypeName, this.interfaceNames, (this.access_flags & 0x200) == 512, this.access_flags & 0xFFFFFFDF, this.methods.toArray(new Method[this.methods.size()]), this.fields.toArray(new Field[this.fields.size()]), innerClasses);
    }

    private void parseHeader(byte[] classFile) {
        if (classFile.length < 10) {
            throw new IllegalClassFormat("class file does not contain a complete header");
        }
        byte[] magic = new byte[]{classFile[0], classFile[1], classFile[2], classFile[3]};
        if (magic[0] != -54 || magic[1] != -2 || magic[2] != -70 || magic[3] != -66) {
            throw new IllegalClassFormat("wrong magic number, file is not a java class file.");
        }
    }

    private int parseConstantPool(byte[] classFile) {
        this.constant_pool_count = BinaryParser.bytesToUShort(classFile, 8);
        this.constant_pool = new ConstantPoolEntry[this.constant_pool_count];
        int parse_offset = 10;
        int i = 1;
        while (i < this.constant_pool_count) {
            this.constant_pool[i] = new ConstantPoolEntry(parse_offset, classFile);
            parse_offset += this.constant_pool[i].getSize();
            if (this.constant_pool[i].skipNext()) {
                ++i;
            }
            ++i;
        }
        return parse_offset;
    }

    private void resolveClass() {
        this.className = this.constant_pool[this.this_class].getName().replace('/', '.');
        if (this.className.indexOf(46) != -1) {
            this.packageName = this.className.substring(0, this.className.lastIndexOf(46));
            this.className = this.className.substring(this.packageName.length() + 1);
        } else {
            this.packageName = "<null>";
        }
        this.className = this.className.replace('$', '.');
        this.superTypeName = this.constant_pool[this.super_class].getName().replace('/', '.');
        if (this.superTypeName.equals("java.lang.Object")) {
            this.superTypeName = null;
        }
        int i = 0;
        while (i < this.method_info.length) {
            if (!this.method_info[i].getName().equals("<clinit>") && !this.method_info[i].getName().startsWith("class$")) {
                this.methods.add(this.parseMethod(this.method_info[i]));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.field_info.length) {
            if (!this.field_info[i2].getName().startsWith("class$") && !this.field_info[i2].getName().startsWith("this$")) {
                this.fields.add(this.parseField(this.field_info[i2]));
            }
            ++i2;
        }
        this.interfaceNames = new String[this.interfaces_count];
        int i3 = 0;
        while (i3 < this.interfaces_count) {
            this.interfaceNames[i3] = this.constant_pool[this.interfaces[i3]].getName().replace('/', '.');
            ++i3;
        }
    }

    private Field parseField(FieldOrMethodInfo info) {
        ConstantValueAttribute attr;
        String name = info.getName();
        String type = this.convertType(this.constant_pool[info.descriptor_index].getName());
        int modifiers = info.access_flags;
        String value = null;
        if (Modifier.isFinal(modifiers) && (attr = info.getConstantValue()) != null) {
            value = this.constant_pool[attr.constantvalue_index].getValue().toString();
        }
        return new Field(name, modifiers, type, value);
    }

    private Method parseMethod(FieldOrMethodInfo info) {
        String[] exceptionTypes;
        String[] paramTypes;
        String methodName = info.getName();
        boolean isConstructor = methodName.equals("<init>");
        int modifiers = info.access_flags;
        String desc = info.getDescriptor();
        int close = desc.indexOf(41);
        int[] temp = new int[100];
        int count = 0;
        if (desc.charAt(0) != '(' || close == -1) {
            throw new IllegalClassFormat("Invalid Method Descriptor: " + desc);
        }
        String returnType = this.convertType(desc.substring(close + 1, desc.length()));
        if (close > 1) {
            String pars = desc.substring(1, close);
            Vector<String> params = new Vector<String>();
            while (!pars.equals("")) {
                temp[count] = this.getDimension(pars);
                String type = this.parseType(pars.substring(temp[count], pars.length())).replace('/', '.');
                String paramWithDims = this.convertType(type);
                int i = 0;
                while (i < temp[count]) {
                    paramWithDims = paramWithDims + "[]";
                    ++i;
                }
                params.add(paramWithDims);
                pars = pars.charAt(temp[count]) == 'L' ? pars.substring(temp[count] + type.length() + 2, pars.length()) : pars.substring(temp[count] + 1, pars.length());
                ++count;
            }
            paramTypes = new String[params.size()];
            paramTypes = params.toArray(paramTypes);
        } else {
            paramTypes = new String[]{};
        }
        ExceptionsAttribute ex = info.getExceptions();
        if (ex == null) {
            exceptionTypes = new String[]{};
        } else {
            exceptionTypes = new String[ex.numberOfExceptions];
            int i = 0;
            while (i < ex.numberOfExceptions) {
                exceptionTypes[i] = this.constant_pool[ex.exceptionIndexTable[i]].getName().replace('/', '.');
                ++i;
            }
        }
        return new Method(methodName, isConstructor, modifiers, returnType, paramTypes, exceptionTypes);
    }

    private String convertType(String string) {
        if (string.equals("V")) {
            return "void";
        }
        if (string.equals("B")) {
            return "byte";
        }
        if (string.equals("Z")) {
            return "boolean";
        }
        if (string.equals("I")) {
            return "int";
        }
        if (string.equals("J")) {
            return "long";
        }
        if (string.equals("C")) {
            return "char";
        }
        if (string.equals("S")) {
            return "short";
        }
        if (string.startsWith("L")) {
            return string.substring(1, string.length() - 1).replace('/', '.');
        }
        if (string.equals("D")) {
            return "double";
        }
        if (string.equals("F")) {
            return "float";
        }
        if (string.startsWith("[")) {
            int dim = 0;
            String brackets = "";
            String bareString = string;
            while (bareString.startsWith("[")) {
                bareString = bareString.substring(1);
                ++dim;
                brackets = brackets + "[]";
            }
            return this.convertType(bareString) + brackets;
        }
        return string;
    }

    protected int getDimension(String desc) {
        int pos = 0;
        while (desc.charAt(pos) == '[') {
            ++pos;
        }
        return pos;
    }

    protected String parseType(String desc) {
        switch (desc.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return desc.substring(0, 1);
            }
            case 'L': {
                return desc.substring(1, desc.indexOf(59));
            }
        }
        throw new IllegalClassFormat("Invalid Method Descriptor: " + desc);
    }

    static int bytesToInt(byte[] bytes, int startoff, int length) {
        int result = 0;
        int i = 0;
        while (i < length) {
            result <<= 8;
            result += bytes[startoff + i] & 0xFF;
            ++i;
        }
        return result;
    }

    static int bytesToUShort(byte[] bytes, int startoff) {
        return (bytes[startoff] & 0xFF) << 8 | bytes[startoff + 1] & 0xFF;
    }

    static long bytesToLong(byte[] bytes, int startoff, int length) {
        long result = 0L;
        int i = 0;
        while (i < length) {
            result <<= 8;
            result += (long)(bytes[startoff + i] & 0xFF);
            ++i;
        }
        return result;
    }

    final class InnerClassesAttribute
    extends AttributeInfo {
        int numberOfClasses;
        InnerClassesInfo[] info;

        InnerClassesAttribute(int name_index, long length, byte[] data) {
            super(name_index, length);
            this.numberOfClasses = BinaryParser.bytesToInt(data, 0, 2);
            this.info = new InnerClassesInfo[this.numberOfClasses];
            int i = 0;
            while (i < this.numberOfClasses) {
                this.info[i] = new InnerClassesInfo(data, 2 + i * 8);
                ++i;
            }
        }
    }

    final class InnerClassesInfo {
        int innerClassInfoIndex;
        int outerClassInfoIndex;
        int innerNameIndex;
        int innerClassAccessFlags;

        InnerClassesInfo(byte[] data, int off) {
            this.innerClassInfoIndex = BinaryParser.bytesToInt(data, off, 2);
            this.outerClassInfoIndex = BinaryParser.bytesToInt(data, off + 2, 2);
            this.innerNameIndex = BinaryParser.bytesToInt(data, off + 4, 2);
            this.innerClassAccessFlags = BinaryParser.bytesToInt(data, off + 6, 2);
        }
    }

    final class ExceptionsAttribute
    extends AttributeInfo {
        int numberOfExceptions;
        int[] exceptionIndexTable;

        ExceptionsAttribute(int name_index, long length, byte[] data) {
            super(name_index, length);
            this.numberOfExceptions = BinaryParser.bytesToInt(data, 0, 2);
            this.exceptionIndexTable = new int[this.numberOfExceptions];
            int i = 0;
            while (i < this.numberOfExceptions) {
                this.exceptionIndexTable[i] = BinaryParser.bytesToInt(data, 2 + i * 2, 2);
                ++i;
            }
        }
    }

    final class SourceFileAttribute
    extends AttributeInfo {
        int sourceFileIndex;

        SourceFileAttribute(int name_index, long length, byte[] data) {
            super(name_index, length);
            this.sourceFileIndex = BinaryParser.bytesToInt(data, 0, 2);
        }

        String getFileName() {
            return BinaryParser.this.constant_pool[this.sourceFileIndex].getName();
        }
    }

    final class ConstantValueAttribute
    extends AttributeInfo {
        int attribute_name_index;
        int attribute_length;
        int constantvalue_index;

        ConstantValueAttribute(int name_index, long length, byte[] data) {
            super(name_index, length);
            this.constantvalue_index = BinaryParser.bytesToInt(data, 0, 2);
        }
    }

    class AttributeInfo {
        int attribute_name_index;
        long attribute_length;
        byte[] info;
        private int length;

        protected AttributeInfo(int name_index, long len) {
            this.attribute_name_index = name_index;
            this.attribute_length = len;
            this.length = 6 + (int)len;
        }

        AttributeInfo(byte[] byteCode, int offset) {
            this.attribute_name_index = BinaryParser.bytesToInt(byteCode, offset, 2);
            this.attribute_length = BinaryParser.bytesToLong(byteCode, offset + 2, 4);
            this.info = new byte[(int)this.attribute_length];
            long i = 0L;
            while (i < this.attribute_length) {
                this.info[(int)i] = byteCode[offset + 6 + (int)i];
                ++i;
            }
            this.length = 6 + (int)this.attribute_length;
        }

        public int getSize() {
            return this.length;
        }

        public String toString() {
            return "name_index=" + this.attribute_name_index + ";atribute_length=" + this.attribute_length + ";info=" + this.info;
        }

        AttributeInfo unwrap() {
            String name = BinaryParser.this.constant_pool[this.attribute_name_index].getName();
            if (name.equals("SourceFile")) {
                return new SourceFileAttribute(this.attribute_name_index, this.attribute_length, this.info);
            }
            if (name.equals("InnerClasses")) {
                return new InnerClassesAttribute(this.attribute_name_index, this.attribute_length, this.info);
            }
            if (name.equals("ConstantValue")) {
                return new ConstantValueAttribute(this.attribute_name_index, this.attribute_length, this.info);
            }
            if (name.equals("Exceptions")) {
                return new ExceptionsAttribute(this.attribute_name_index, this.attribute_length, this.info);
            }
            return this;
        }
    }

    final class FieldOrMethodInfo {
        int access_flags;
        int name_index;
        int descriptor_index;
        int attributes_count;
        int exceptions = -1;
        int constantValue = -1;
        AttributeInfo[] attributes;
        private int length = 8;

        FieldOrMethodInfo(byte[] byteCode, int offset) {
            this.access_flags = BinaryParser.bytesToInt(byteCode, offset, 2);
            this.name_index = BinaryParser.bytesToInt(byteCode, offset + 2, 2);
            this.descriptor_index = BinaryParser.bytesToInt(byteCode, offset + 4, 2);
            this.attributes_count = BinaryParser.bytesToInt(byteCode, offset + 6, 2);
            this.attributes = new AttributeInfo[this.attributes_count];
            int i = 0;
            while (i < this.attributes_count) {
                this.attributes[i] = new AttributeInfo(byteCode, offset + this.length).unwrap();
                this.length += this.attributes[i].getSize();
                if (this.attributes[i] instanceof ExceptionsAttribute) {
                    this.exceptions = i;
                }
                if (this.attributes[i] instanceof ConstantValueAttribute) {
                    this.constantValue = i;
                }
                ++i;
            }
        }

        int getSize() {
            return this.length;
        }

        String getName() {
            return BinaryParser.this.constant_pool[this.name_index].getName();
        }

        String getDescriptor() {
            return BinaryParser.this.constant_pool[this.descriptor_index].getName();
        }

        ExceptionsAttribute getExceptions() {
            if (this.exceptions != -1) {
                return (ExceptionsAttribute)this.attributes[this.exceptions];
            }
            return null;
        }

        ConstantValueAttribute getConstantValue() {
            if (this.constantValue != -1) {
                return (ConstantValueAttribute)this.attributes[this.constantValue];
            }
            return null;
        }
    }

    final class CPIUTF8
    extends ConstantPoolInfo {
        int length;
        byte[] values;
        String val;

        CPIUTF8(int length, byte[] classFile, int offset) {
            this.length = length;
            this.values = new byte[length];
            System.arraycopy(classFile, offset, this.values, 0, length);
            try {
                this.val = new String(this.values, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalClassFormat("illegal utf8 string: " + this.values);
            }
            this.values = null;
        }

        public String toString() {
            return "value=" + this.val;
        }

        public String getName() {
            return this.val;
        }

        Object getValue() {
            throw new UnsupportedOperationException("getValue() not supported for CPIUTF8");
        }
    }

    final class CPINameAndType
    extends ConstantPoolInfo {
        int name_and_type_index;
        int descriptor_index;

        CPINameAndType(int name_and_type_index, int descriptor_index) {
            this.descriptor_index = descriptor_index;
            this.name_and_type_index = name_and_type_index;
        }

        public String toString() {
            return "name_and_type_index=" + this.name_and_type_index + "; descriptor_index=" + this.descriptor_index;
        }

        Object getValue() {
            throw new UnsupportedOperationException("getValue() not supported for CPINameAndType");
        }
    }

    final class CPIDouble
    extends ConstantPoolInfo {
        double value;

        CPIDouble(double value) {
            this.value = value;
        }

        public String toString() {
            return "value=" + this.value;
        }

        Object getValue() {
            return new Double(this.value);
        }
    }

    final class CPILong
    extends ConstantPoolInfo {
        long value;

        CPILong(long value) {
            this.value = value;
        }

        public String toString() {
            return "value=" + this.value;
        }

        Object getValue() {
            return new Long(this.value);
        }
    }

    final class CPIFloat
    extends ConstantPoolInfo {
        float value;

        CPIFloat(float value) {
            this.value = value;
        }

        public String toString() {
            return "value=" + this.value;
        }

        Object getValue() {
            return new Float(this.value);
        }
    }

    final class CPIInt
    extends ConstantPoolInfo {
        int value;

        CPIInt(int value) {
            this.value = value;
        }

        public String toString() {
            return "value=" + this.value;
        }

        Object getValue() {
            return new Integer(this.value);
        }
    }

    final class CPIString
    extends ConstantPoolInfo {
        int string_index;

        CPIString(int string_index) {
            this.string_index = string_index;
        }

        public String toString() {
            return "string_index=" + this.string_index;
        }

        Object getValue() {
            return BinaryParser.this.constant_pool[this.string_index].getName();
        }
    }

    final class CPIRef
    extends ConstantPoolInfo {
        int class_index;
        int name_and_type_index;

        CPIRef(int class_index, int name_and_type_index) {
            this.class_index = class_index;
            this.name_and_type_index = name_and_type_index;
        }

        public String toString() {
            return "class_index=" + this.class_index + ";name_and_type_index=" + this.name_and_type_index;
        }

        Object getValue() {
            throw new UnsupportedOperationException("getValue() not supported for CPIRef");
        }
    }

    final class CPIClass
    extends ConstantPoolInfo {
        int name_index;

        CPIClass(int name_index) {
            this.name_index = name_index;
        }

        public String toString() {
            return "name_index=" + this.name_index;
        }

        Object getValue() {
            throw new UnsupportedOperationException("getValue() not supported for CPIClass");
        }
    }

    abstract class ConstantPoolInfo {
        ConstantPoolInfo() {
        }

        abstract Object getValue();
    }

    final class ConstantPoolEntry {
        static final byte CLASS = 7;
        static final byte FIELDREF = 9;
        static final byte METHODREF = 10;
        static final byte INTERFACEMETHODREF = 11;
        static final byte STRING = 8;
        static final byte INTEGER = 3;
        static final byte FLOAT = 4;
        static final byte LONG = 5;
        static final byte DOUBLE = 6;
        static final byte NAMEANDTYPE = 12;
        static final byte UTF8 = 1;
        byte tag;
        ConstantPoolInfo info;
        private int length;

        ConstantPoolEntry(int offset, byte[] classFile) {
            this.tag = classFile[offset];
            this.length = 1;
            switch (this.tag) {
                case 7: {
                    this.info = new CPIClass(BinaryParser.bytesToUShort(classFile, offset + this.length));
                    this.length += 2;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.info = new CPIRef(BinaryParser.bytesToUShort(classFile, offset + this.length), BinaryParser.bytesToUShort(classFile, offset + this.length + 2));
                    this.length += 4;
                    break;
                }
                case 8: {
                    this.info = new CPIString(BinaryParser.bytesToUShort(classFile, offset + this.length));
                    this.length += 2;
                    break;
                }
                case 3: {
                    this.info = new CPIInt(BinaryParser.bytesToInt(classFile, offset + this.length, 4));
                    this.length += 4;
                    break;
                }
                case 4: {
                    this.info = new CPIFloat(Float.intBitsToFloat(BinaryParser.bytesToInt(classFile, offset + this.length, 4)));
                    this.length += 4;
                    break;
                }
                case 5: {
                    this.info = new CPILong(BinaryParser.bytesToLong(classFile, offset + this.length, 8));
                    this.length += 8;
                    break;
                }
                case 6: {
                    this.info = new CPIDouble(Double.longBitsToDouble(BinaryParser.bytesToLong(classFile, offset + this.length, 8)));
                    this.length += 8;
                    break;
                }
                case 12: {
                    this.info = new CPINameAndType(BinaryParser.bytesToUShort(classFile, offset + this.length), BinaryParser.bytesToUShort(classFile, offset + this.length + 2));
                    this.length += 4;
                    break;
                }
                case 1: {
                    int len = BinaryParser.bytesToUShort(classFile, offset + this.length);
                    this.info = new CPIUTF8(len, classFile, offset + this.length + 2);
                    this.length += 2 + len;
                    break;
                }
                default: {
                    throw new IllegalClassFormat("illegal entry in constant pool: tag" + this.tag);
                }
            }
        }

        Object getValue() {
            switch (this.tag) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    return this.info.getValue();
                }
            }
            throw new IllegalClassFormat("constant pool entry has invalid type!");
        }

        boolean skipNext() {
            return this.tag == 5 || this.tag == 6;
        }

        int getSize() {
            return this.length;
        }

        public String toString() {
            return entryTypes[this.tag] + ";" + this.info.toString();
        }

        String getName() {
            switch (this.tag) {
                case 7: {
                    return BinaryParser.this.constant_pool[((CPIClass)this.info).name_index].getName();
                }
                case 1: {
                    CPIUTF8 utf = (CPIUTF8)this.info;
                    return utf.getName();
                }
            }
            throw new UnsupportedOperationException();
        }
    }
}

