/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.ws.wss.tokens.securitytoken;

import com.sap.security.core.policy.exceptions.ProcessException;
import com.sap.security.core.policy.exceptions.ProcessMessage;
import com.sap.security.core.securitypolicy.assertions.SecurityPolicyConstants;
import com.sap.security.core.server.util0.Base64;
import com.sap.security.core.ws.mapping.ReferenceableElement;
import com.sap.security.core.ws.wss.tokens.securitytoken.UnsupportedBinarySecurityTokenException;
import com.sap.security.core.ws.wss.tokens.securitytoken.UnsupportedBinarySecurityTokenMessage;
import iaik.x509.ChainVerifier;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class BinarySecurityToken
extends ReferenceableElement {
    private String value = null;
    private String valueType;
    private String encodingType;
    private String fingerprint;
    private String id;
    static /* synthetic */ Class class$java$security$cert$CertificateFactory;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$InputStream;

    public BinarySecurityToken() {
        this.encodingType = SecurityPolicyConstants.getInstance((String)"WS Security SAP NW 04 Stack 04").WSSE_BASE64_BINARY_URI;
        this.fingerprint = null;
        this.id = null;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public String getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public String getValueType() {
        return this.valueType;
    }

    public Object getSecurityToken() throws CertificateException, ParseException, UnsupportedBinarySecurityTokenException {
        if (!this.supportsCertificateEncoding(this.valueType)) {
            throw new UnsupportedBinarySecurityTokenException(UnsupportedBinarySecurityTokenMessage.ID0100_UNSUPPORTED_TOKEN_TYPE.create((Object)this.getValueType(), (Object)this.getEncodingType(), (Object)System.getProperties()), null);
        }
        if (!SecurityPolicyConstants.isBase64BinaryEncoding(this.encodingType)) {
            throw new UnsupportedBinarySecurityTokenException(UnsupportedBinarySecurityTokenMessage.ID0120_UNSUPPORTED_ENCODING_TYPE.create((Object)this.getValueType(), (Object)this.getEncodingType()), null);
        }
        try {
            java.security.cert.X509Certificate[] certificates = this.decodeCertificates(this.value, this.valueType, this.encodingType);
            return certificates;
        }
        catch (Throwable ex) {
            throw new UnsupportedBinarySecurityTokenException(UnsupportedBinarySecurityTokenMessage.ID0200_ERROR_DECODING_CERTIFICATE.create((Object)this.getValueType(), (Object)this.getEncodingType(), (Object)this.getValue()), ex);
        }
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setValue(String value) {
        this.value = value;
        this.fingerprint = null;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public void setSecurityToken(java.security.cert.X509Certificate[] certificates, String valueType, String encodingType) throws ProcessException, CertificateEncodingException {
        this.fingerprint = null;
        this.setEncodingType(encodingType);
        this.setValueType(valueType);
        this.setId(this.id);
        if (!SecurityPolicyConstants.isBase64BinaryEncoding(encodingType)) {
            throw new ProcessException(ProcessMessage.ID0013_BINARY_SECURITY_TOKEN_UNKNOWN_ENCODING.create((Object)encodingType), null);
        }
        try {
            this.setValue(this.encodeCertificates(certificates, this.valueType));
        }
        catch (Throwable ex) {
            throw new ProcessException(ProcessMessage.ID0012_BINARY_SECURITY_TOKEN_CREATE_ERROR.create((Object)ex.getMessage()), ex);
        }
    }

    public String getFingerprint() throws NoSuchAlgorithmException {
        if (this.fingerprint == null && this.value != null) {
            MessageDigest mdAlg = MessageDigest.getInstance("SHA");
            mdAlg.reset();
            mdAlg.update(this.value.getBytes());
            byte[] digest = mdAlg.digest();
            this.fingerprint = Base64.encode((byte[])digest, (int)0);
        }
        return this.fingerprint;
    }

    private String getProviderNameForCertPath(String valueType) {
        Provider[] providers = Security.getProviders("CertificateFactory.X.509");
        int i = 0;
        while (i < providers.length) {
            String providerName = providers[i].getName();
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509", providerName);
                Method getCertPathEncodingsMethod = (class$java$security$cert$CertificateFactory == null ? BinarySecurityToken.class$("java.security.cert.CertificateFactory") : class$java$security$cert$CertificateFactory).getMethod("getCertPathEncodings", new Class[0]);
                Iterator encodingIterator = (Iterator)getCertPathEncodingsMethod.invoke((Object)cf, new Object[0]);
                while (encodingIterator.hasNext()) {
                    String supportedEncoding = (String)encodingIterator.next();
                    if (SecurityPolicyConstants.isPKCS7CertificateChainType(valueType) && "PKCS7".equals(supportedEncoding)) {
                        return providerName;
                    }
                    if (!SecurityPolicyConstants.isX509PKIPathCertificateChainType(valueType) || !"PkiPath".equals(supportedEncoding)) continue;
                    return providerName;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    private boolean supportsCertificateEncoding(String valueType) {
        String providerName;
        if (SecurityPolicyConstants.isX509v3CertificateType(valueType)) {
            return true;
        }
        return (SecurityPolicyConstants.isPKCS7CertificateChainType(valueType) || SecurityPolicyConstants.isX509PKIPathCertificateChainType(valueType)) && (providerName = this.getProviderNameForCertPath(valueType)) != null;
    }

    public String encodeCertificates(java.security.cert.X509Certificate[] certificates, String valueType) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException, ClassNotFoundException, UnsupportedBinarySecurityTokenException, CertificateException, NoSuchProviderException {
        if (SecurityPolicyConstants.isX509v3CertificateType(valueType)) {
            return new String(Base64.encode((byte[])certificates[0].getEncoded(), (int)0));
        }
        if (SecurityPolicyConstants.isPKCS7CertificateChainType(valueType) || SecurityPolicyConstants.isX509PKIPathCertificateChainType(valueType)) {
            String pathEncoding = null;
            if (SecurityPolicyConstants.isPKCS7CertificateChainType(valueType)) {
                pathEncoding = "PKCS7";
            }
            if (SecurityPolicyConstants.isX509PKIPathCertificateChainType(valueType)) {
                pathEncoding = "PkiPath";
            }
            if (!this.supportsCertificateEncoding(valueType)) {
                throw new UnsupportedBinarySecurityTokenException(UnsupportedBinarySecurityTokenMessage.ID0100_UNSUPPORTED_TOKEN_TYPE.create((Object)this.getValueType(), (Object)this.getEncodingType(), (Object)System.getProperties()), null);
            }
            String providerName = this.getProviderNameForCertPath(valueType);
            CertificateFactory cf = CertificateFactory.getInstance("X.509", providerName);
            Method generateCertPathMethod = cf.getClass().getDeclaredMethod("generateCertPath", class$java$util$List == null ? (class$java$util$List = BinarySecurityToken.class$("java.util.List")) : class$java$util$List);
            Object certPathObject = generateCertPathMethod.invoke((Object)cf, Arrays.asList(certificates));
            Method getEncodedMethod = Class.forName("java.security.cert.CertPath").getMethod("getEncoded", class$java$lang$String == null ? (class$java$lang$String = BinarySecurityToken.class$("java.lang.String")) : class$java$lang$String);
            Object encodedBytes = getEncodedMethod.invoke(certPathObject, "PKCS7");
            byte[] encodedPkiPath = (byte[])encodedBytes;
            return Base64.encode((byte[])encodedPkiPath, (int)0);
        }
        return null;
    }

    public java.security.cert.X509Certificate[] decodeCertificates(String base64EncodedData, String valueType, String encoding) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, ParseException, SecurityException, NoSuchMethodException, ClassNotFoundException, CertificateException, NoSuchProviderException {
        if (SecurityPolicyConstants.isX509v3CertificateType(valueType) && SecurityPolicyConstants.isBase64BinaryEncoding(encoding)) {
            byte[] certBin = Base64.decode((String)this.value);
            X509Certificate cert = new X509Certificate(certBin);
            return new java.security.cert.X509Certificate[]{cert};
        }
        if ((SecurityPolicyConstants.isPKCS7CertificateChainType(valueType) || SecurityPolicyConstants.isX509PKIPathCertificateChainType(valueType)) && SecurityPolicyConstants.isBase64BinaryEncoding(encoding)) {
            String providerName;
            String pathEncoding = null;
            if (SecurityPolicyConstants.isPKCS7CertificateChainType(valueType)) {
                pathEncoding = "PKCS7";
            }
            if (SecurityPolicyConstants.isX509PKIPathCertificateChainType(valueType)) {
                pathEncoding = "PkiPath";
            }
            if ((providerName = this.getProviderNameForCertPath(valueType)) != null) {
                CertificateFactory cf = CertificateFactory.getInstance("X.509", providerName);
                Method generateCertPathMethod = cf.getClass().getDeclaredMethod("generateCertPath", class$java$io$InputStream == null ? (class$java$io$InputStream = BinarySecurityToken.class$("java.io.InputStream")) : class$java$io$InputStream, class$java$lang$String == null ? (class$java$lang$String = BinarySecurityToken.class$("java.lang.String")) : class$java$lang$String);
                Object certPathObject = generateCertPathMethod.invoke((Object)cf, new ByteArrayInputStream(Base64.decode((String)base64EncodedData)), "PKCS7");
                Method getCertificatesMethod = Class.forName("java.security.cert.CertPath").getMethod("getCertificates", new Class[0]);
                List certList = (List)getCertificatesMethod.invoke(certPathObject, new Object[0]);
                java.security.cert.X509Certificate[] unorderedCertificates = certList.toArray(new java.security.cert.X509Certificate[0]);
                Vector<Principal> issuerDNVector = new Vector<Principal>();
                int i = 0;
                while (i < unorderedCertificates.length) {
                    issuerDNVector.add(unorderedCertificates[i].getIssuerDN());
                    ++i;
                }
                java.security.cert.X509Certificate rootCertificate = null;
                int i2 = 0;
                while (i2 < unorderedCertificates.length) {
                    if (!issuerDNVector.contains(unorderedCertificates[i2].getSubjectDN())) {
                        rootCertificate = unorderedCertificates[i2];
                    }
                    ++i2;
                }
                java.security.cert.X509Certificate[] orderedCerts = ChainVerifier.orderCertificateChain(rootCertificate, (java.security.cert.X509Certificate[])unorderedCertificates);
                return orderedCerts;
            }
        }
        throw new CertificateException("Unsupported encoding:" + valueType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

