/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.securitypolicy.assertions.cert;

import com.sap.engine.interfaces.keystore.KeystoreManager;
import com.sap.security.core.securitypolicy.assertions.cert.KeyAndCertException;
import com.sap.security.core.securitypolicy.assertions.cert.KeyAndCertMessage;
import com.sap.security.core.securitypolicy.assertions.cert.KeyElement;
import com.sap.security.core.ws.wss.WSSecurityContext;
import iaik.security.ssl.KeyAndCert;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.naming.InitialContext;

public class KeystoreKeyElement
implements KeyElement {
    public static final String TYPE = "KeystoreKeyElement";
    private String view = "";
    private String alias = "";

    public String getElementType() {
        return TYPE;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getView() {
        return this.view;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setView(String view) {
        this.view = view;
    }

    public KeyAndCert getKeyAndCert(WSSecurityContext sctx) throws KeyAndCertException {
        Object res = AccessController.doPrivileged(new GetKeyAndCertPrivilegedAction(sctx));
        if (res instanceof KeyAndCert) {
            return (KeyAndCert)res;
        }
        Throwable ex = (Throwable)res;
        throw new KeyAndCertException(KeyAndCertMessage.ID0100_ERROR_KEYSTORE_READING_KEY_AND_CERT.create((Object)this.view, (Object)this.alias, (Object)ex.getClass().getName(), (Object)ex.getMessage()), ex);
    }

    private class GetKeyAndCertPrivilegedAction
    implements PrivilegedAction {
        WSSecurityContext sctx = null;

        GetKeyAndCertPrivilegedAction(WSSecurityContext sctx) {
            this.sctx = sctx;
        }

        public Object run() {
            try {
                KeystoreManager km = null;
                if (this.sctx.getApplicationServiceContext() != null) {
                    km = (KeystoreManager)this.sctx.getApplicationServiceContext().getContainerContext().getObjectRegistry().getServiceInterface("keystore");
                }
                if (km == null) {
                    InitialContext ctx = new InitialContext();
                    km = (KeystoreManager)ctx.lookup("keystore");
                }
                KeyStore keystore = km.getKeystore(KeystoreKeyElement.this.view);
                Certificate[] certificates = keystore.getCertificateChain(KeystoreKeyElement.this.alias);
                X509Certificate[] x509Certificates = new X509Certificate[certificates.length];
                System.arraycopy(certificates, 0, x509Certificates, 0, certificates.length);
                PrivateKey pk = (PrivateKey)keystore.getKey(KeystoreKeyElement.this.alias, "".toCharArray());
                return new KeyAndCert(x509Certificates, pk);
            }
            catch (Throwable ex) {
                return ex;
            }
        }
    }
}

