/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.securitypolicy.assertions;

import com.sap.engine.lib.security.BasicPasswordCallbackHandler;
import com.sap.security.core.policy.PolicyConstants;
import com.sap.security.core.policy.assertions.BaseAssertion;
import com.sap.security.core.policy.exceptions.ProcessException;
import com.sap.security.core.policy.exceptions.ProcessMessage;
import com.sap.security.core.policy.exceptions.VerifyException;
import com.sap.security.core.policy.exceptions.VerifyMessage;
import com.sap.security.core.securitypolicy.assertions.SecurityPolicyConstants;
import com.sap.security.core.ws.wss.SecurityHeader;
import com.sap.security.core.ws.wss.WSSecurityDocument;
import com.sap.security.core.ws.wss.tokens.securitytoken.UsernameToken;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Calendar;
import java.util.TimeZone;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class UsernameAssertion
extends BaseAssertion {
    public static final String TYPE = "UsernameAssertion";
    private String usage;
    String preference = null;
    private String name = "";
    private String password = null;
    private String type = "wsse:PasswordText";
    private String targetID = null;
    private String role = "soap:finalActor";
    private boolean containsCreated = false;
    private boolean containsNonce = false;
    private String maxClockSkewString = "60";
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$securitypolicy$assertions$UsernameAssertion == null ? (class$com$sap$security$core$securitypolicy$assertions$UsernameAssertion = UsernameAssertion.class$("com.sap.security.core.securitypolicy.assertions.UsernameAssertion")) : class$com$sap$security$core$securitypolicy$assertions$UsernameAssertion));
    final Category CATEGORY = Category.SYS_SECURITY;
    static /* synthetic */ Class class$com$sap$security$core$securitypolicy$assertions$UsernameAssertion;

    public String getType() {
        return this.type;
    }

    public void apply(Object o, String pid) throws ProcessException {
        if (o instanceof WSSecurityDocument && o != null) {
            WSSecurityDocument security = (WSSecurityDocument)o;
            SecurityPolicyConstants constants = security.getSecurityContext().getConstants();
            try {
                SecurityHeader securityHeader = security.getSecurityHeaderByRole(this.role);
                UsernameToken usernameToken = null;
                usernameToken = "wsse:PasswordText".equals(this.type) ? new UsernameToken(constants.getPasswordTextTypeURI(), this.name, this.password) : new UsernameToken(constants.getPasswordDigestTypeURI(), this.name, this.password);
                usernameToken.setContainsCreated(this.containsCreated);
                usernameToken.setContainsNonce(this.getContainsNonce());
                if (this.targetID != null) {
                    usernameToken.setId(this.targetID);
                }
                securityHeader.setUsernameToken(usernameToken);
            }
            catch (Exception ex) {
                throw new ProcessException(ProcessMessage.ID0500_USERNAME_APPLY_ERROR.create((Object)ex.getClass().getName(), (Object)ex.getMessage()), ex);
            }
        }
    }

    public void verify(Object o, String pid) throws VerifyException {
        long expirationTimeSeconds = 60L;
        long maximumSkewSeconds = 5L;
        if (o instanceof WSSecurityDocument && o != null) {
            WSSecurityDocument security = (WSSecurityDocument)o;
            SecurityHeader securityHeader = null;
            try {
                securityHeader = security.getSecurityHeaderByRole("soap:finalActor");
                UsernameToken usernameToken = securityHeader.getUsernameToken();
                if (usernameToken == null) {
                    throw new VerifyException(VerifyMessage.ID0500_USERNAME_NO_TOKEN_FOUND.create(), null);
                }
                if (!SecurityPolicyConstants.isPasswordTextType(usernameToken.getPassword().getType())) {
                    throw new VerifyException(VerifyMessage.ID0510_USERNAME_UNSUPPORTED_TYPE.create((Object)usernameToken.getPassword().getType(), (Object)usernameToken.getUsername()), null);
                }
                if (this.getContainsCreated()) {
                    if (usernameToken.getCreated() == null) {
                        throw new VerifyException(VerifyMessage.ID0550_USERNAME_CREATED_REQUIRED.create((Object)usernameToken.getUsername()), null);
                    }
                    Calendar createdElementCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                    createdElementCalendar.setTime(usernameToken.getCreated().getValue());
                    Calendar currentTimeCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                    if (this.maxClockSkewString == null) {
                        this.maxClockSkewString = security.getSecurityContext().getApplicationServiceContext() != null ? security.getSecurityContext().getApplicationServiceContext().getServiceState().getProperty("timestamp.max.clock.skew", "2") : "2";
                    }
                    if ((maximumSkewSeconds = (long)Integer.parseInt(this.maxClockSkewString)) != -1L && currentTimeCalendar.getTime().getTime() - createdElementCalendar.getTime().getTime() < -maximumSkewSeconds * 1000L) {
                        throw new VerifyException(VerifyMessage.ID0570_USERNAME_CLOCK_SKEW_ERROR.create((Object)createdElementCalendar.getTime(), (Object)currentTimeCalendar.getTime(), (Object)("" + maximumSkewSeconds)), null);
                    }
                    if (currentTimeCalendar.getTime().getTime() - createdElementCalendar.getTime().getTime() > expirationTimeSeconds * 1000L) {
                        throw new VerifyException(VerifyMessage.ID0560_USERNAME_CREATED_EXPIRED.create((Object)usernameToken.getCreated().getValue(), (Object)currentTimeCalendar.getTime(), (Object)("" + expirationTimeSeconds)), null);
                    }
                }
                String username = usernameToken.getUsername();
                String password = usernameToken.getPassword().getValue();
                if (password == null) {
                    throw new VerifyException(VerifyMessage.ID0580_USERNAME_NO_PASSWORD.create((Object)usernameToken.getType(), (Object)username), null);
                }
                BasicPasswordCallbackHandler handler = new BasicPasswordCallbackHandler(username, password);
                try {
                    LoginContext login = new LoginContext("basic", (CallbackHandler)handler);
                    login.login();
                    Subject subj = login.getSubject();
                    VerifyMessage.ID0520_USERNAME_AUTHENTICATION_SUCCEEDED.create((Object)usernameToken.getPassword().getType(), (Object)usernameToken.getUsername()).log(300, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
                }
                catch (LoginException lex) {
                    throw new VerifyException(VerifyMessage.ID0530_USERNAME_AUTHENTICATION_FAILED.create((Object)usernameToken.getPassword().getType(), (Object)usernameToken.getUsername(), (Object)lex.getMessage()), null);
                }
            }
            catch (Throwable ex) {
                if (ex instanceof VerifyException) {
                    throw (VerifyException)((Object)ex);
                }
                throw new VerifyException(VerifyMessage.ID0540_USERNAME_AUTHENTICATION_FAILED.create((Object)ex.getClass().getName(), (Object)ex.getMessage()), null);
            }
        }
    }

    public String getPassword() {
        return this.password;
    }

    public String getRole() {
        return this.role;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setRole(String string) {
        this.role = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setUsage(String string) {
        this.usage = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPreference() {
        return this.preference;
    }

    public String getTargetID() {
        return this.targetID;
    }

    public void setPreference(String string) {
        this.preference = string;
    }

    public void setTargetID(String string) {
        this.targetID = string;
    }

    public boolean getContainsCreated() {
        return this.containsCreated;
    }

    public boolean getContainsNonce() {
        return this.containsNonce;
    }

    public void setContainsCreated(boolean b) {
        this.containsCreated = b;
    }

    public void setContainsNonce(boolean b) {
        this.containsNonce = b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

