/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.securitypolicy.assertions;

import com.sap.security.core.server.xmlbind.exception.XMLBindConfigException;
import com.sap.security.core.server.xmlbind.exception.XMLBindException;
import com.sap.security.core.ws.mapping.WSMappingUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;

public class SecurityPolicyConstants {
    public static final String WEB_SERVICE_SECURITY_SOAP_MESSAGE_SECURITY_SAP_NETWEAVER_04_STACK_2 = "WS Security SAP NW 04 Stack 02";
    public static final String WEB_SERVICE_SECURITY_SOAP_MESSAGE_SECURITY_SAP_NETWEAVER_04_STACK_3 = "WS Security SAP NW 04 Stack 03";
    public static final String WEB_SERVICE_SECURITY_SOAP_MESSAGE_SECURITY_SAP_NETWEAVER_04_STACK_4 = "WS Security SAP NW 04 Stack 04";
    public static final String SIGNATURE_ALGORITHM_TYPE = "wsse:AlgSignature";
    public static final String PASSWORD_DIGEST_TYPE = "wsse:PasswordDigest";
    public static final String PASSWORD_TEXT_TYPE = "wsse:PasswordText";
    public static final String WSSE_X509PKIPATH_TYPE = "wsse:X509PKIPathv1";
    public static final String WSSE_PKCS7_TYPE = "wsse:PKCS7";
    public static final String WSSE_X509V3 = "wsse:X509v3";
    public static final String FINAL_ACTOR = "soap:finalActor";
    public static final String DSIG_ID_REFERENCE = "http://security.sap.com/ID";
    public static final String XENC_ATTACHMENT_ID_REFERENCE = "http://security.sap.com/AttachmentID";
    public static final String DSIG_XPATH_REFERENCE = "http://www.w3.orig/TR/1999/REC-xpath-19991116";
    public static final String XSD_DATE_TIME = "xsd:dateTime";
    public static final String WSSE_ALG_ENCRYPTION = "wsse:AlgEncryption";
    public static final String XENC_ENCRYPTEDKEY_URI = "http://www.w3.org/2001/04/xmlenc#EncryptedKey";
    public static final String XENC_CONTENT_ENCRYPTION_URI = "http://www.w3.org/2001/04/xmlenc#Content";
    public static final String XENC_ELEMENT_ENCRYPTION_URI = "http://www.w3.org/2001/04/xmlenc#Element";
    public static String XENC_URI = "http://www.w3.org/2001/04/xmlenc#";
    public static final String TRIPLE_DES_URI = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String DSIG_URI = "http://www.w3.org/2000/09/xmldsig#";
    public static final String DSIG_SAP_PATH_REFERENCE = "http://security.sap.com/Path";
    public static final String SOAP_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    public String WSSE_X509V3_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    public String WSSE_X509PKIPATH_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1";
    public String WSSE_PKCS7_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#PKCS7";
    public String PASSWORD_DIGEST_TYPE_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
    public String PASSWORD_TEXT_TYPE_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
    public String WSSE_BASE64_BINARY_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    public String WSSE_SUBJECT_KEY_IDENTIFIER_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier";
    public String WSSE_SWA_ATTACHMENT_CONTENT_ONLY = "http://docs.oasis-open.org/wss/2004/07/oasis-200407-wss-swa-profile-1.0-draft-07#Attachment-Content-Only";
    public String WSSE_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public String WSU_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private String WSSE_MAPPING_FILE = "/mapping/WSSMapping-v3.xml";
    private static HashMap instanceCache = new HashMap();
    private static List securityPolicyConstantsList = null;

    private SecurityPolicyConstants(String versionIdentifier) {
        if (WEB_SERVICE_SECURITY_SOAP_MESSAGE_SECURITY_SAP_NETWEAVER_04_STACK_3.equals(versionIdentifier)) {
            this.WSU_URI = "http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
            this.WSSE_URI = "http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
            this.WSSE_X509V3_URI = "http://www.docs.oasis-open.org/wss/2003/12/oasis-200401-wss-x509-token-profile-1.0#X509v3";
            this.WSSE_X509PKIPATH_URI = "http://www.docs.oasis-open.org/wss/2003/12/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1";
            this.WSSE_PKCS7_URI = "http://www.docs.oasis-open.org/wss/2003/12/oasis-200401-wss-x509-token-profile-1.0#PKCS7";
            this.PASSWORD_DIGEST_TYPE_URI = "http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
            this.PASSWORD_TEXT_TYPE_URI = "http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
            this.WSSE_BASE64_BINARY_URI = "http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
            this.WSSE_SUBJECT_KEY_IDENTIFIER_URI = "http://www.docs.oasis-open.org/wss/2003/12/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier";
            this.WSSE_MAPPING_FILE = "/mapping/WSSMapping-v2.xml";
        }
        if (WEB_SERVICE_SECURITY_SOAP_MESSAGE_SECURITY_SAP_NETWEAVER_04_STACK_2.equals(versionIdentifier)) {
            this.WSU_URI = "http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
            this.WSSE_URI = "http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
            this.WSSE_X509V3_URI = WSSE_X509V3;
            this.WSSE_X509PKIPATH_URI = WSSE_X509PKIPATH_TYPE;
            this.WSSE_PKCS7_URI = WSSE_PKCS7_TYPE;
            this.PASSWORD_DIGEST_TYPE_URI = PASSWORD_DIGEST_TYPE;
            this.PASSWORD_TEXT_TYPE_URI = PASSWORD_TEXT_TYPE;
            this.WSSE_BASE64_BINARY_URI = "wsse:Base64Binary";
            this.WSSE_SUBJECT_KEY_IDENTIFIER_URI = "wsse:X509SubjectKeyIdentifier";
            this.WSSE_MAPPING_FILE = "/mapping/WSSMapping-v2.xml";
        }
    }

    public static SecurityPolicyConstants getInstance(String versionIdentifier) {
        if (!instanceCache.containsKey(versionIdentifier)) {
            instanceCache.put(versionIdentifier, new SecurityPolicyConstants(versionIdentifier));
        }
        return (SecurityPolicyConstants)instanceCache.get(versionIdentifier);
    }

    private static List getSecurityPolicyConstantsList() {
        if (securityPolicyConstantsList == null) {
            securityPolicyConstantsList = new ArrayList();
            securityPolicyConstantsList.add(SecurityPolicyConstants.getInstance(WEB_SERVICE_SECURITY_SOAP_MESSAGE_SECURITY_SAP_NETWEAVER_04_STACK_4));
            securityPolicyConstantsList.add(SecurityPolicyConstants.getInstance(WEB_SERVICE_SECURITY_SOAP_MESSAGE_SECURITY_SAP_NETWEAVER_04_STACK_2));
            securityPolicyConstantsList.add(SecurityPolicyConstants.getInstance(WEB_SERVICE_SECURITY_SOAP_MESSAGE_SECURITY_SAP_NETWEAVER_04_STACK_3));
        }
        return securityPolicyConstantsList;
    }

    public static boolean isPasswordTextType(String passwordTextType) {
        Iterator securityPolicyConstantsIterator = SecurityPolicyConstants.getSecurityPolicyConstantsList().iterator();
        while (securityPolicyConstantsIterator.hasNext()) {
            SecurityPolicyConstants constants = (SecurityPolicyConstants)securityPolicyConstantsIterator.next();
            if (!constants.PASSWORD_TEXT_TYPE_URI.equals(passwordTextType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPasswordDigestType(String passwordDigestType) {
        Iterator securityPolicyConstantsIterator = SecurityPolicyConstants.getSecurityPolicyConstantsList().iterator();
        while (securityPolicyConstantsIterator.hasNext()) {
            SecurityPolicyConstants constants = (SecurityPolicyConstants)securityPolicyConstantsIterator.next();
            if (!constants.PASSWORD_DIGEST_TYPE_URI.equals(passwordDigestType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isX509v3CertificateType(String certificateType) {
        Iterator securityPolicyConstantsIterator = SecurityPolicyConstants.getSecurityPolicyConstantsList().iterator();
        while (securityPolicyConstantsIterator.hasNext()) {
            SecurityPolicyConstants constants = (SecurityPolicyConstants)securityPolicyConstantsIterator.next();
            if (!constants.WSSE_X509V3_URI.equals(certificateType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPKCS7CertificateChainType(String certificateChainType) {
        Iterator securityPolicyConstantsIterator = SecurityPolicyConstants.getSecurityPolicyConstantsList().iterator();
        while (securityPolicyConstantsIterator.hasNext()) {
            SecurityPolicyConstants constants = (SecurityPolicyConstants)securityPolicyConstantsIterator.next();
            if (!constants.WSSE_PKCS7_URI.equals(certificateChainType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isX509PKIPathCertificateChainType(String certificateChainType) {
        Iterator securityPolicyConstantsIterator = SecurityPolicyConstants.getSecurityPolicyConstantsList().iterator();
        while (securityPolicyConstantsIterator.hasNext()) {
            SecurityPolicyConstants constants = (SecurityPolicyConstants)securityPolicyConstantsIterator.next();
            if (!constants.WSSE_X509PKIPATH_URI.equals(certificateChainType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBase64BinaryEncoding(String encodingType) {
        Iterator securityPolicyConstantsIterator = SecurityPolicyConstants.getSecurityPolicyConstantsList().iterator();
        while (securityPolicyConstantsIterator.hasNext()) {
            SecurityPolicyConstants constants = (SecurityPolicyConstants)securityPolicyConstantsIterator.next();
            if (!constants.WSSE_BASE64_BINARY_URI.equals(encodingType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isX509SubjectKeyIdentifier(String encodingType) {
        Iterator securityPolicyConstantsIterator = SecurityPolicyConstants.getSecurityPolicyConstantsList().iterator();
        while (securityPolicyConstantsIterator.hasNext()) {
            SecurityPolicyConstants constants = (SecurityPolicyConstants)securityPolicyConstantsIterator.next();
            if (!constants.WSSE_SUBJECT_KEY_IDENTIFIER_URI.equals(encodingType)) continue;
            return true;
        }
        return false;
    }

    public String getPasswordTextTypeURI() {
        return this.PASSWORD_TEXT_TYPE_URI;
    }

    public String getPasswordDigestTypeURI() {
        return this.PASSWORD_DIGEST_TYPE_URI;
    }

    public static List getWSUNamespaces() {
        ArrayList<String> wsuNsList = new ArrayList<String>();
        Iterator securityPolicyConstantsIterator = SecurityPolicyConstants.getSecurityPolicyConstantsList().iterator();
        while (securityPolicyConstantsIterator.hasNext()) {
            SecurityPolicyConstants constants = (SecurityPolicyConstants)securityPolicyConstantsIterator.next();
            wsuNsList.add(constants.WSU_URI);
        }
        return wsuNsList;
    }

    public static List getWSSENamespaces() {
        ArrayList<String> wsuNsList = new ArrayList<String>();
        Iterator securityPolicyConstantsIterator = SecurityPolicyConstants.getSecurityPolicyConstantsList().iterator();
        while (securityPolicyConstantsIterator.hasNext()) {
            SecurityPolicyConstants constants = (SecurityPolicyConstants)securityPolicyConstantsIterator.next();
            wsuNsList.add(constants.WSSE_URI);
        }
        return wsuNsList;
    }

    public static boolean isValidWSSENamespace(String namespace) {
        Iterator securityPolicyConstantsIterator = SecurityPolicyConstants.getSecurityPolicyConstantsList().iterator();
        while (securityPolicyConstantsIterator.hasNext()) {
            SecurityPolicyConstants constants = (SecurityPolicyConstants)securityPolicyConstantsIterator.next();
            if (!constants.WSSE_URI.equals(namespace)) continue;
            return true;
        }
        return false;
    }

    public static WSMappingUtil getMappingUtilByNamespace(String wsseNamespace) throws XMLBindConfigException, XMLBindException, ParserConfigurationException {
        Iterator securityPolicyConstantsIterator = SecurityPolicyConstants.getSecurityPolicyConstantsList().iterator();
        while (securityPolicyConstantsIterator.hasNext()) {
            SecurityPolicyConstants constants = (SecurityPolicyConstants)securityPolicyConstantsIterator.next();
            if (!constants.WSSE_URI.equals(wsseNamespace)) continue;
            return WSMappingUtil.get(constants.WSSE_MAPPING_FILE);
        }
        return null;
    }

    public static SecurityPolicyConstants getConstantsByNamespace(String wsseNamespace) {
        Iterator securityPolicyConstantsIterator = SecurityPolicyConstants.getSecurityPolicyConstantsList().iterator();
        while (securityPolicyConstantsIterator.hasNext()) {
            SecurityPolicyConstants constants = (SecurityPolicyConstants)securityPolicyConstantsIterator.next();
            if (!constants.WSSE_URI.equals(wsseNamespace)) continue;
            return constants;
        }
        return null;
    }
}

