/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.securitypolicy.assertions;

import com.sap.security.core.policy.PolicyConstants;
import com.sap.security.core.policy.assertions.BaseAssertion;
import com.sap.security.core.policy.exceptions.ProcessException;
import com.sap.security.core.policy.exceptions.ProcessMessage;
import com.sap.security.core.policy.exceptions.VerifyException;
import com.sap.security.core.policy.exceptions.VerifyMessage;
import com.sap.security.core.ws.wss.SecurityHeader;
import com.sap.security.core.ws.wss.WSSecurityDocument;
import com.sap.security.core.ws.wss.tokens.timestamp.Timestamp;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TimeZone;

public class MessageAgeAssertion
extends BaseAssertion {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$securitypolicy$assertions$IntegrityAssertion == null ? (class$com$sap$security$core$securitypolicy$assertions$IntegrityAssertion = MessageAgeAssertion.class$("com.sap.security.core.securitypolicy.assertions.IntegrityAssertion")) : class$com$sap$security$core$securitypolicy$assertions$IntegrityAssertion));
    final Category CATEGORY = Category.SYS_SECURITY;
    public static final String TYPE = "MessageAge";
    private String usage;
    private String preference;
    private String age = null;
    private String targetID;
    private String role = "soap:finalActor";
    private String maxClockSkewString = null;
    static /* synthetic */ Class class$com$sap$security$core$securitypolicy$assertions$IntegrityAssertion;

    public String getAge() {
        return this.age;
    }

    public String getPreference() {
        return this.preference;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setAge(String age) {
        this.age = age;
    }

    public void setPreference(String preference) {
        this.preference = preference;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getType() {
        return TYPE;
    }

    public String getTargetID() {
        return this.targetID;
    }

    public void setTargetID(String targetID) {
        this.targetID = targetID;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String string) {
        this.role = string;
    }

    public void apply(Object o, String pid) throws ProcessException {
        if (o instanceof WSSecurityDocument) {
            WSSecurityDocument security = (WSSecurityDocument)o;
            try {
                SecurityHeader securityHeader = security.getSecurityHeaderByRole(this.getRole());
                Timestamp timestamp = new Timestamp();
                if (this.age != null) {
                    try {
                        int ageInt = Integer.parseInt(this.age);
                        timestamp.setExpires(ageInt);
                    }
                    catch (NumberFormatException nex) {
                        throw new ProcessException(ProcessMessage.ID0200_MESSAGE_AGE_FORMAT.create((Object)this.age, (Object)nex.getMessage()), nex);
                    }
                }
                if (this.targetID != null) {
                    timestamp.setId(this.targetID);
                }
                securityHeader.addTimestamp(timestamp);
            }
            catch (Exception ex) {
                if (ex instanceof ProcessException) {
                    throw (ProcessException)((Object)ex);
                }
                throw new ProcessException(ProcessMessage.ID0210_ERROR_ADDING_TIMESTAMP.create((Object)this.getRole(), (Object)ex.getClass().getName(), (Object)ex.getMessage()), ex);
            }
        }
    }

    public void verify(Object o, String pid) throws VerifyException {
        WSSecurityDocument security = (WSSecurityDocument)o;
        try {
            SecurityHeader securityHeader = security.getSecurityHeaderByRole(this.getRole());
            Iterator timestampIterator = securityHeader.getTimestamps();
            Calendar currentTimeCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            long maximumAgeSeconds = 60L;
            long maximumSkewSeconds = 0L;
            if (this.maxClockSkewString == null) {
                this.maxClockSkewString = security.getSecurityContext().getApplicationServiceContext() != null ? security.getSecurityContext().getApplicationServiceContext().getServiceState().getProperty("timestamp.max.clock.skew", "2") : "2";
            }
            maximumSkewSeconds = Integer.parseInt(this.maxClockSkewString);
            if (this.getAge() != null) {
                maximumAgeSeconds = Integer.parseInt(this.getAge());
            }
            if (!timestampIterator.hasNext()) {
                throw new VerifyException(VerifyMessage.ID0720_NO_TIMESTAMP_ERROR.create(), null);
            }
            Timestamp timestamp = (Timestamp)timestampIterator.next();
            if (timestampIterator.hasNext()) {
                throw new VerifyException(VerifyMessage.ID0710_TO_MANY_TIMESTAMP_ERROR.create(), null);
            }
            if (timestamp.getExpires() != null && timestamp.getExpires().getValue().getTime() < currentTimeCalendar.getTime().getTime()) {
                throw new VerifyException(VerifyMessage.ID0730_TIMESTAMP_SENDER_EXPIRATION_REACHED.create((Object)timestamp.getExpires().getValue(), (Object)currentTimeCalendar.getTime()), null);
            }
            Calendar timestampCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            timestampCalendar.setTime(timestamp.getCreated().getValue());
            if (maximumSkewSeconds != -1L && currentTimeCalendar.getTime().getTime() - timestampCalendar.getTime().getTime() < -maximumSkewSeconds * 1000L) {
                throw new VerifyException(VerifyMessage.ID0740_TIMESTAMP_CLOCK_SKEW_ERROR.create((Object)timestampCalendar.getTime(), (Object)currentTimeCalendar.getTime(), (Object)("" + maximumSkewSeconds)), null);
            }
            if (currentTimeCalendar.getTime().getTime() - timestampCalendar.getTime().getTime() > maximumAgeSeconds * 1000L) {
                throw new VerifyException(VerifyMessage.ID0750_TIMESTAMP_EXPIRED_ERROR.create((Object)timestampCalendar.getTime(), (Object)currentTimeCalendar.getTime(), (Object)("" + maximumAgeSeconds)), null);
            }
            VerifyMessage.ID0760_TIMESTAMP_CHECK_SUCCESSFULL.create((Object)timestampCalendar.getTime(), (Object)currentTimeCalendar.getTime(), (Object)("" + maximumAgeSeconds)).log(300, PolicyConstants.BUSINESS_CATEGORY, LOCATION, pid);
        }
        catch (Exception ex) {
            if (ex instanceof VerifyException) {
                throw (VerifyException)((Object)ex);
            }
            throw new VerifyException(VerifyMessage.ID0700_TIMESTAMP_PROCESSING_ERROR.create((Object)ex.getClass().getName(), (Object)ex.getMessage()), ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

