/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.securitypolicy.assertions;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.signature.transform.TransformationFactory;
import com.sap.security.core.policy.assertions.BaseAssertion;
import com.sap.security.core.policy.exceptions.ProcessException;
import com.sap.security.core.policy.exceptions.ProcessMessage;
import com.sap.security.core.policy.exceptions.VerifyException;
import com.sap.security.core.policy.exceptions.VerifyMessage;
import com.sap.security.core.securitypolicy.assertions.AlgorithmElement;
import com.sap.security.core.securitypolicy.assertions.ClaimsElement;
import com.sap.security.core.securitypolicy.assertions.DSIGProcessor;
import com.sap.security.core.securitypolicy.assertions.MessagePartsElement;
import com.sap.security.core.securitypolicy.assertions.SecurityPolicyConstants;
import com.sap.security.core.securitypolicy.assertions.SecurityTokenElement;
import com.sap.security.core.securitypolicy.assertions.jaas.ClientCertCallbackHandler;
import com.sap.security.core.server.ssf.SsfDataXML;
import com.sap.security.core.server.ssf.SsfProfileBasicImpl;
import com.sap.security.core.server.ssf.SsfRefXMLInfo;
import com.sap.security.core.server.ssf.SsfRefXMLList;
import com.sap.security.core.server.ssf.SsfSigRcpList;
import com.sap.security.core.ws.dsig.SignatureElement;
import com.sap.security.core.ws.mapping.WSMappingUtil;
import com.sap.security.core.ws.wss.NoSecurityHeaderException;
import com.sap.security.core.ws.wss.NoSecurityHeaderExceptionMessage;
import com.sap.security.core.ws.wss.SecurityHeader;
import com.sap.security.core.ws.wss.WSSecurityDocument;
import com.sap.security.core.ws.wss.tokens.securitytoken.BinarySecurityToken;
import com.sap.security.core.ws.wss.tokens.securitytoken.SecurityTokenReference;
import com.sap.security.core.ws.wss.xml.transforms.XLinkDigestTransform;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import iaik.security.ssl.KeyAndCert;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IntegrityAssertion
extends BaseAssertion {
    public static final String TYPE = "IntegrityAssertion";
    private String usage;
    String preference = null;
    private String binarySecurityTokenType = "wsse:X509v3";
    private List securityTokenList = new ArrayList();
    private List claimsList = new ArrayList();
    private List messagePartsList = new ArrayList();
    private String role = "soap:finalActor";
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$securitypolicy$assertions$IntegrityAssertion == null ? (class$com$sap$security$core$securitypolicy$assertions$IntegrityAssertion = IntegrityAssertion.class$("com.sap.security.core.securitypolicy.assertions.IntegrityAssertion")) : class$com$sap$security$core$securitypolicy$assertions$IntegrityAssertion));
    final Category CATEGORY = Category.SYS_SECURITY;
    static /* synthetic */ Class class$com$sap$security$core$securitypolicy$assertions$IntegrityAssertion;
    static /* synthetic */ Class class$com$sap$security$core$ws$dsig$SignatureElement;

    public String getPreference() {
        return this.preference;
    }

    public void setPreference(String preference) {
        this.preference = preference;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public Iterator getSecurityTokens() {
        return this.securityTokenList.iterator();
    }

    public void addSecurityToken(SecurityTokenElement securityToken) {
        this.securityTokenList.add(securityToken);
    }

    public Iterator getClaims() {
        return this.claimsList.iterator();
    }

    public void addClaim(ClaimsElement claim) {
        this.claimsList.add(claim);
    }

    public Iterator getMessageParts() {
        return this.messagePartsList.iterator();
    }

    public void addMessageParts(MessagePartsElement messagePart) {
        this.messagePartsList.add(messagePart);
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    private List getMessagePartsByDialect(String dialect) {
        ArrayList<MessagePartsElement> selectedMessagePartsList = new ArrayList<MessagePartsElement>();
        Iterator messagePartsIterator = this.messagePartsList.iterator();
        while (messagePartsIterator.hasNext()) {
            MessagePartsElement messagePart = (MessagePartsElement)messagePartsIterator.next();
            if (!dialect.equals(messagePart.getDialect())) continue;
            selectedMessagePartsList.add(messagePart);
        }
        return selectedMessagePartsList;
    }

    private List getSecurityTokensByType(String type) {
        ArrayList<SecurityTokenElement> selectedSecurityTokensList = new ArrayList<SecurityTokenElement>();
        Iterator securityTokenIterator = this.securityTokenList.iterator();
        while (securityTokenIterator.hasNext()) {
            SecurityTokenElement securityToken = (SecurityTokenElement)securityTokenIterator.next();
            if (!type.equals(securityToken.getTokenType())) continue;
            selectedSecurityTokensList.add(securityToken);
        }
        return selectedSecurityTokensList;
    }

    public String getType() {
        return TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verify(Object o, String pid) throws VerifyException {
        X509Certificate authenticationCertificate = null;
        if (!(o instanceof WSSecurityDocument)) return;
        if (o == null) return;
        WSSecurityDocument securityDocument = (WSSecurityDocument)o;
        SecurityPolicyConstants constants = securityDocument.getSecurityContext().getConstants();
        int signatureCount = 0;
        SsfSigRcpList[] signerListArray = null;
        SsfRefXMLList[] referenceListArray = null;
        Document soapDocument = securityDocument.getSoapDocument();
        try {
            Element securityHeaderElement = securityDocument.getSecurityHeaderElement();
            if (securityHeaderElement == null) {
                throw new NoSecurityHeaderException(NoSecurityHeaderExceptionMessage.ID0100_NO_SECURITY_HEADER.create((Object)"soap:finalActor"), null);
            }
            WSMappingUtil util2 = SecurityPolicyConstants.getMappingUtilByNamespace(securityHeaderElement.getNamespaceURI());
            SecurityHeader securityHeader = securityDocument.getSecurityHeaderByRole(this.role);
            NodeList nl = securityHeaderElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            signatureCount = nl.getLength();
            signerListArray = new SsfSigRcpList[signatureCount];
            referenceListArray = new SsfRefXMLList[signatureCount];
            TransformationFactory transformationFactory = TransformationFactory.newInstance();
            if (securityDocument.getAttachments() != null) {
                XLinkDigestTransform tf = new XLinkDigestTransform(new Object[]{securityDocument.getAttachments()});
                transformationFactory.registerTransformation((Transformation)tf);
            }
            int signatureIndex = 0;
            while (signatureIndex < signatureCount) {
                Element signatureElement = (Element)nl.item(signatureIndex);
                SignatureElement signatureObject = (SignatureElement)util2.unmarshall(signatureElement, (class$com$sap$security$core$ws$dsig$SignatureElement == null ? IntegrityAssertion.class$("com.sap.security.core.ws.dsig.SignatureElement") : class$com$sap$security$core$ws$dsig$SignatureElement).getClassLoader());
                if (signatureObject.getKeyInfo() == null) throw new VerifyException(VerifyMessage.ID0260_DSIG_NO_KEY_INFO.create((Object)signatureElement), null);
                if (signatureObject.getKeyInfo().getSecurityTokenReference() == null) throw new VerifyException(VerifyMessage.ID0270_DSIG_NO_SECURITY_TOKEN_REFERENCE.create((Object)signatureElement), null);
                SecurityTokenReference securityTokenReference = signatureObject.getKeyInfo().getSecurityTokenReference();
                String uri = securityTokenReference.getReference().getURI();
                BinarySecurityToken binarySecurityToken = securityHeader.getBinarySecurityTokenbyID(uri.substring(1));
                X509Certificate[] certificateArray = (X509Certificate[])binarySecurityToken.getSecurityToken();
                signerListArray[signatureIndex] = new SsfSigRcpList();
                referenceListArray[signatureIndex] = new SsfRefXMLList();
                referenceListArray[signatureIndex].setTransformationFactory(transformationFactory);
                referenceListArray[signatureIndex].setIdAttribute("Id", constants.WSU_URI);
                boolean result = SsfDataXML.verifyData((Element)signatureElement, null, (SsfSigRcpList)signerListArray[signatureIndex], (SsfRefXMLList)referenceListArray[signatureIndex], (X509Certificate)certificateArray[0]);
                VerifyMessage.ID0240_DSIG_VERIFY_INFO.create((Object)new Boolean(result), (Object)signerListArray, (Object)referenceListArray).log(300, this.CATEGORY, LOCATION, pid);
                if (!result) {
                    throw new VerifyException(VerifyMessage.ID0210_DSIG_NO_VALID_SIGNATURE.create(), null);
                }
                ++signatureIndex;
            }
            Iterator messagePartsIterator = this.getMessageParts();
            while (messagePartsIterator.hasNext()) {
                MessagePartsElement messagePart = (MessagePartsElement)messagePartsIterator.next();
                boolean messagePartSigned = false;
                int numberOfAcceptedSignatures = 0;
                if ("http://security.sap.com/Path".equals(messagePart.getDialect())) {
                    int signatureIndex2 = 0;
                    while (signatureIndex2 < signatureCount) {
                        SsfSigRcpList signerList = signerListArray[signatureIndex2];
                        numberOfAcceptedSignatures = 0;
                        int signerIndex = 0;
                        while (signerIndex < signerList.size()) {
                            Iterator securityTokenIterator = this.getSecurityTokens();
                            while (securityTokenIterator.hasNext()) {
                                SecurityTokenElement securityToken = (SecurityTokenElement)securityTokenIterator.next();
                                if (!securityToken.isCertificateTrusted(securityDocument.getSecurityContext(), signerList.get((int)signerIndex).cert, pid)) continue;
                                ++numberOfAcceptedSignatures;
                            }
                            ++signerIndex;
                        }
                        if (numberOfAcceptedSignatures > 0) {
                            int referenceIndex = 0;
                            while (referenceIndex < referenceListArray[signatureIndex2].size()) {
                                boolean identicalURIs;
                                SsfRefXMLInfo refXMLInfo = referenceListArray[signatureIndex2].get(referenceIndex);
                                boolean identicalTransformations = true;
                                List messagePartList = messagePart.getAlgorithmsByType("wsse:AlgCanonicalization");
                                int transformationIndex = 0;
                                while (transformationIndex < refXMLInfo.trans.length) {
                                    if (refXMLInfo.trans.length != messagePartList.size()) {
                                        identicalTransformations = false;
                                    } else {
                                        AlgorithmElement requiredAlgorithm = (AlgorithmElement)messagePartList.get(transformationIndex);
                                        if (!requiredAlgorithm.getURI().equals(refXMLInfo.trans[transformationIndex])) {
                                            identicalTransformations = false;
                                        }
                                    }
                                    ++transformationIndex;
                                }
                                if (!refXMLInfo.uri.startsWith("#")) throw new VerifyException(VerifyMessage.ID0250_DSIG_REFERENCE_FORMAT_ERROR.create((Object)refXMLInfo.uri), null);
                                Element signedElement = DOM.getElementByAttribute((Node)soapDocument.getDocumentElement(), (String)referenceListArray[signatureIndex2].getIdLocalName(), (String)referenceListArray[signatureIndex2].getIdURI(), (String)refXMLInfo.uri.substring(1));
                                if (identicalTransformations && (identicalURIs = messagePart.equalsURI(signedElement))) {
                                    messagePartSigned = true;
                                    if (authenticationCertificate == null) {
                                        if (signerListArray[signatureIndex2].size() == 1) {
                                            authenticationCertificate = signerListArray[signatureIndex2].get((int)0).cert;
                                        } else if (securityDocument.getSecurityContext().isAuthenticationEnabled()) {
                                            throw new VerifyException(VerifyMessage.ID0620_CERTIFICATE_AUTHENTICATION_TO_MANY_CERTIFICATES.create((Object)("" + signerListArray[signatureIndex2].size()), (Object)signerListArray[signatureIndex2]), null);
                                        }
                                    }
                                }
                                ++referenceIndex;
                            }
                        }
                        ++signatureIndex2;
                    }
                }
                if (!messagePartSigned) {
                    throw new VerifyException(VerifyMessage.ID0230_DSIG_PART_NOT_SIGNED_ERROR.create((Object)messagePart.getURI(), (Object)messagePart.getAlgorithmsByType("wsse:AlgCanonicalization"), (Object)("" + signatureCount), (Object)("" + numberOfAcceptedSignatures)), null);
                }
                VerifyMessage.ID0245_DSIG_ACCEPTED.create((Object)messagePart.getURI(), (Object)this.securityTokenList).log(300, this.CATEGORY, LOCATION, pid);
            }
            if (!securityDocument.getSecurityContext().isAuthenticationEnabled() || authenticationCertificate == null) return;
            try {
                Subject subject = this.authenticate(authenticationCertificate);
                VerifyMessage.ID0610_CERTIFICATE_AUTHENTICATION_SUCCEEDED.create((Object)subject, (Object)authenticationCertificate.getSubjectDN()).log(300, this.CATEGORY, LOCATION, pid);
                return;
            }
            catch (Exception ex) {
                throw new VerifyException(VerifyMessage.ID0600_CERTIFICATE_AUTHENTICATION_FAILED.create((Object)authenticationCertificate.getSubjectDN(), (Object)ex.getClass().getName(), (Object)ex.getMessage()), null);
            }
        }
        catch (Exception ex) {
            if (!(ex instanceof VerifyException)) throw new VerifyException(VerifyMessage.ID0200_DSIG_VALIDATE_ERROR.create((Object)ex.getClass().getName(), (Object)ex.getMessage()), ex);
            throw (VerifyException)((Object)ex);
        }
    }

    public void apply(Object o, String pid) throws ProcessException {
        DSIGProcessor processor = null;
        if (o instanceof WSSecurityDocument && o != null) {
            WSSecurityDocument security = (WSSecurityDocument)o;
            SecurityPolicyConstants constants = security.getSecurityContext().getConstants();
            try {
                SecurityHeader securityHeader = security.getSecurityHeaderByRole("soap:finalActor");
                List securityTokenList = this.getSecurityTokensByType("wsse:X509v3");
                if (securityTokenList.size() <= 0) {
                    throw new CertificateException("No security token found.");
                }
                SecurityTokenElement securityToken = (SecurityTokenElement)securityTokenList.get(0);
                KeyAndCert keyAndCert = securityToken.getKeyAndCert(security.getSecurityContext());
                String certID = null;
                try {
                    SsfProfileBasicImpl profile = new SsfProfileBasicImpl(keyAndCert.getPrivateKey(), keyAndCert.getCertificateChain());
                    X509Certificate signerCert = profile.getCertificate();
                    BinarySecurityToken secToken = new BinarySecurityToken();
                    if ("wsse:X509v3".equals(this.getBinarySecurityTokenType())) {
                        secToken.setSecurityToken(keyAndCert.getCertificateChain(), constants.WSSE_X509V3_URI, constants.WSSE_BASE64_BINARY_URI);
                    }
                    if ("wsse:X509PKIPathv1".equals(this.getBinarySecurityTokenType())) {
                        secToken.setSecurityToken(keyAndCert.getCertificateChain(), constants.WSSE_X509PKIPATH_URI, constants.WSSE_BASE64_BINARY_URI);
                    }
                    if ("wsse:PKCS7".equals(this.getBinarySecurityTokenType())) {
                        secToken.setSecurityToken(keyAndCert.getCertificateChain(), constants.WSSE_PKCS7_URI, constants.WSSE_BASE64_BINARY_URI);
                    }
                    secToken.setId(securityHeader.getGUID());
                    securityHeader.addBinarySecurityToken(secToken);
                    certID = securityHeader.getBinarySecurityTokenID(secToken);
                    processor = new DSIGProcessor(profile, constants);
                    processor.setCertificateReferenceID(certID);
                }
                catch (Exception ex) {
                    throw new ProcessException(ProcessMessage.ID0011_SECURITY_TOKEN_ERROR_DURING_ADDING.create((Object)ex.getMessage()), ex);
                }
                Iterator messagePartsIterator = this.getMessageParts();
                while (messagePartsIterator.hasNext()) {
                    MessagePartsElement messageParts = (MessagePartsElement)messagePartsIterator.next();
                    if (!"http://security.sap.com/ID".equals(messageParts.getDialect())) continue;
                    Iterator algorithmIterator = messageParts.getAlgorithms();
                    Vector<Transformation> transformationVector = new Vector<Transformation>();
                    while (algorithmIterator.hasNext()) {
                        AlgorithmElement algorithmElement = (AlgorithmElement)algorithmIterator.next();
                        if (algorithmElement.getURI() == null) continue;
                        if (XLinkDigestTransform.URI.equals(algorithmElement.getURI())) {
                            transformationVector.add(new XLinkDigestTransform(new Object[]{security.getAttachments()}));
                            continue;
                        }
                        transformationVector.add(Transformation.getInstance((String)algorithmElement.getURI(), null));
                    }
                    Object[] transformationArray = new Transformation[transformationVector.size()];
                    transformationVector.copyInto(transformationArray);
                    SsfRefXMLInfo ssfInfo = new SsfRefXMLInfo();
                    ssfInfo.uri = messageParts.getURI();
                    ssfInfo.setTransformations((Transformation[])transformationArray);
                    processor.addReference(ssfInfo);
                }
                security.addProcessor(processor);
            }
            catch (Exception ex) {
                if (ex instanceof ProcessException) {
                    throw (ProcessException)((Object)ex);
                }
                throw new ProcessException(ProcessMessage.ID0100_XML_DSIG_APPLY_ERROR.create((Object)ex.getClass().getName(), (Object)ex.getMessage()), ex);
            }
        }
    }

    private Subject authenticate(X509Certificate certificate) throws LoginException {
        X509Certificate[] certChain = new X509Certificate[]{certificate};
        ClientCertCallbackHandler handler = new ClientCertCallbackHandler(certChain);
        LoginContext login = new LoginContext("client_cert", handler);
        login.login();
        Subject subject = login.getSubject();
        return subject;
    }

    public String getBinarySecurityTokenType() {
        return this.binarySecurityTokenType;
    }

    public void setBinarySecurityTokenType(String string) {
        this.binarySecurityTokenType = string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

