/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.securitypolicy.assertions;

import com.sap.security.core.policy.exceptions.ProcessException;
import com.sap.security.core.policy.exceptions.ProcessMessage;
import com.sap.security.core.securitypolicy.assertions.SecurityPolicyConstants;
import com.sap.security.core.server.ssf.SsfDataXML;
import com.sap.security.core.server.ssf.SsfRefXMLList;
import com.sap.security.core.server.ssf.SsfSigRcpInfo;
import com.sap.security.core.server.ssf.SsfSigRcpList;
import com.sap.security.core.ws.mapping.WSMappingUtil;
import com.sap.security.core.ws.wss.WSProcessor;
import com.sap.security.core.ws.wss.WSSecurityDocument;
import com.sap.security.core.ws.wss.tokens.securitytoken.KeyIdentifierElement;
import com.sap.security.core.ws.wss.tokens.securitytoken.SecurityTokenReference;
import iaik.x509.X509Certificate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class EncryptionProcessor
implements WSProcessor {
    private String encryptionAlgorithm = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    private SsfSigRcpList ssfSigRcpList = null;
    private SsfRefXMLList ssfRefXMLList = null;
    static /* synthetic */ Class class$com$sap$security$core$securitypolicy$assertions$EncryptionProcessor;

    public void apply(WSSecurityDocument securityDocument) throws ProcessException {
        try {
            SecurityPolicyConstants constants = securityDocument.getSecurityContext().getConstants();
            Document soapDocument = securityDocument.getSoapDocument();
            Element securityHeaderElement = securityDocument.getSecurityHeaderElement();
            Element dummyKeyElement = soapDocument.createElement("dummyKeyElement");
            securityHeaderElement.appendChild(dummyKeyElement);
            SsfDataXML dataXML = new SsfDataXML(soapDocument.getDocumentElement());
            boolean result = dataXML.encrypt(dummyKeyElement, this.ssfRefXMLList, this.ssfSigRcpList, null, this.encryptionAlgorithm);
            if (!result) {
                throw new ProcessException(ProcessMessage.ID0710_CONFIDENTIALITY_CREATE_ERROR.create((Object)this.encryptionAlgorithm, (Object)this.ssfSigRcpList, (Object)this.ssfRefXMLList), null);
            }
            NodeList keyNameNL = dummyKeyElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyName");
            int i = 0;
            while (i < keyNameNL.getLength()) {
                Element keyNameElement = (Element)keyNameNL.item(i);
                String keyName = null;
                NodeList keyNameChildrenNodeList = keyNameElement.getChildNodes();
                int j = 0;
                while (j < keyNameChildrenNodeList.getLength()) {
                    Node childNode = keyNameChildrenNodeList.item(j);
                    if (childNode instanceof Text) {
                        keyName = childNode.getNodeValue();
                    }
                    ++j;
                }
                if (keyName != null) {
                    int j2 = 0;
                    while (j2 < this.ssfSigRcpList.size()) {
                        SsfSigRcpInfo rcpInfo = this.ssfSigRcpList.get(j2);
                        if (rcpInfo.cert.getSubjectDN().getName().equals(keyName)) {
                            KeyIdentifierElement keyIdentifier = new KeyIdentifierElement((X509Certificate)rcpInfo.cert, constants.WSSE_BASE64_BINARY_URI, constants.WSSE_SUBJECT_KEY_IDENTIFIER_URI);
                            SecurityTokenReference securityTokenReference = new SecurityTokenReference();
                            securityTokenReference.setKeyIdentifier(keyIdentifier);
                            WSMappingUtil util = SecurityPolicyConstants.getMappingUtilByNamespace(constants.WSSE_URI);
                            util.marshall(securityTokenReference, keyNameElement.getParentNode(), (class$com$sap$security$core$securitypolicy$assertions$EncryptionProcessor == null ? EncryptionProcessor.class$("com.sap.security.core.securitypolicy.assertions.EncryptionProcessor") : class$com$sap$security$core$securitypolicy$assertions$EncryptionProcessor).getClassLoader());
                            keyNameElement.getParentNode().removeChild(keyNameElement);
                        }
                        ++j2;
                    }
                }
                ++i;
            }
            NodeList encryptedDataNL = soapDocument.getDocumentElement().getElementsByTagNameNS(SecurityPolicyConstants.XENC_URI, "EncryptedData");
            int i2 = 0;
            while (i2 < encryptedDataNL.getLength()) {
                Element encryptedDataElement = (Element)encryptedDataNL.item(i2);
                NodeList keyInfoNL = encryptedDataElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
                if (keyInfoNL.getLength() == 1) {
                    encryptedDataElement.removeChild(keyInfoNL.item(0));
                }
                ++i2;
            }
            NodeList childNodeList = securityHeaderElement.getChildNodes();
            Node encryptedKeyTargetNode = null;
            int selectedIndex = -1;
            int i3 = childNodeList.getLength() - 1;
            while (i3 >= 0) {
                if (1 == childNodeList.item(i3).getNodeType()) {
                    Element currentElement = (Element)childNodeList.item(i3);
                    if (!("Signature".equals(currentElement.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(currentElement.getNamespaceURI()) || "EncryptedData".equals(currentElement.getLocalName()) && SecurityPolicyConstants.XENC_URI.equals(currentElement.getNamespaceURI()) || "EncryptedKey".equals(currentElement.getLocalName()) && SecurityPolicyConstants.XENC_URI.equals(currentElement.getNamespaceURI()))) {
                        if (selectedIndex == -1) {
                            selectedIndex = i3;
                        }
                    } else {
                        selectedIndex = -1;
                    }
                }
                --i3;
            }
            encryptedKeyTargetNode = selectedIndex < childNodeList.getLength() - 1 ? childNodeList.item(selectedIndex + 1) : securityHeaderElement.getFirstChild();
            NodeList dummyKeyElementChildsNodeList = dummyKeyElement.getChildNodes();
            while (dummyKeyElement.getChildNodes().getLength() > 0) {
                Node copiedNode = dummyKeyElement.getLastChild();
                dummyKeyElement.removeChild(copiedNode);
                securityHeaderElement.insertBefore(copiedNode, encryptedKeyTargetNode);
                encryptedKeyTargetNode = copiedNode;
            }
            securityHeaderElement.removeChild(dummyKeyElement);
        }
        catch (Throwable ex) {
            throw new ProcessException(ProcessMessage.ID0700_CONFIDENTIALITY_PROCESS_ERROR.create((Object)ex.getClass().getName(), (Object)ex.getMessage()), ex);
        }
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String string) {
        this.encryptionAlgorithm = string;
    }

    public SsfRefXMLList getSsfRefXMLList() {
        return this.ssfRefXMLList;
    }

    public void setSsfRefXMLList(SsfRefXMLList list) {
        this.ssfRefXMLList = list;
    }

    public SsfSigRcpList getSsfSigRcpList() {
        return this.ssfSigRcpList;
    }

    public void setSsfSigRcpList(SsfSigRcpList list) {
        this.ssfSigRcpList = list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

